/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.tiles;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.qozix.tileview.detail.DetailLevel;
import com.qozix.tileview.graphics.BitmapProvider;
import com.qozix.tileview.graphics.BitmapProviderAssets;
import com.qozix.tileview.tiles.Tile;
import com.qozix.tileview.tiles.TileCanvasView;
import com.qozix.tileview.tiles.TileRenderPoolExecutor;
import com.qozix.tileview.widgets.ScalingLayout;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TileCanvasViewGroup
extends ScalingLayout
implements TileCanvasView.TileCanvasDrawListener {
    private static final int RENDER_FLAG = 1;
    public static final int DEFAULT_RENDER_BUFFER = 250;
    public static final int FAST_RENDER_BUFFER = 15;
    private static final int DEFAULT_TRANSITION_DURATION = 200;
    private BitmapProvider mBitmapProvider;
    private HashMap mTileCanvasViewHashMap = new HashMap();
    private DetailLevel mDetailLevelToRender;
    private DetailLevel mLastRequestedDetailLevel;
    private DetailLevel mLastRenderedDetailLevel;
    private TileCanvasView mCurrentTileCanvasView;
    private boolean mRenderIsCancelled = false;
    private boolean mRenderIsSuppressed = false;
    private boolean mIsRendering = false;
    private boolean mShouldRecycleBitmaps = true;
    private boolean mTransitionsEnabled = true;
    private int mTransitionDuration = 200;
    private TileRenderThrottleHandler mTileRenderThrottleHandler;
    private TileRenderListener mTileRenderListener;
    private int mRenderBuffer = 250;
    private TileRenderPoolExecutor mTileRenderPoolExecutor;
    private Set mTilesInCurrentViewport = new HashSet();
    private Set mTilesNotInCurrentViewport = new HashSet();
    private Set mTilesAlreadyRendered = new HashSet();
    private Runnable mRenderPostExecuteRunnable = new Runnable(){

        @Override
        public void run() {
            if (!TileCanvasViewGroup.this.mTransitionsEnabled) {
                TileCanvasViewGroup.this.cleanup();
            }
            if (TileCanvasViewGroup.this.mTileRenderListener != null) {
                TileCanvasViewGroup.this.mTileRenderListener.onRenderComplete();
            }
            TileCanvasViewGroup.this.mLastRenderedDetailLevel = TileCanvasViewGroup.this.mDetailLevelToRender;
            TileCanvasViewGroup.this.invalidate();
            TileCanvasViewGroup.this.requestRender();
        }
    };

    public TileCanvasViewGroup(Context context) {
        super(context);
        this.setWillNotDraw(false);
        this.mTileRenderThrottleHandler = new TileRenderThrottleHandler(this);
        this.mTileRenderPoolExecutor = new TileRenderPoolExecutor();
    }

    public boolean getTransitionsEnabled() {
        return this.mTransitionsEnabled;
    }

    public void setTransitionsEnabled(boolean bl) {
        this.mTransitionsEnabled = bl;
    }

    public int getTransitionDuration() {
        return this.mTransitionDuration;
    }

    public void setTransitionDuration(int n) {
        this.mTransitionDuration = n;
    }

    public BitmapProvider getBitmapProvider() {
        if (this.mBitmapProvider == null) {
            this.mBitmapProvider = new BitmapProviderAssets();
        }
        return this.mBitmapProvider;
    }

    public void setBitmapProvider(BitmapProvider bitmapProvider) {
        this.mBitmapProvider = bitmapProvider;
    }

    public void setTileRenderListener(TileRenderListener tileRenderListener) {
        this.mTileRenderListener = tileRenderListener;
    }

    public int getRenderBuffer() {
        return this.mRenderBuffer;
    }

    public void setRenderBuffer(int n) {
        this.mRenderBuffer = n;
    }

    public boolean getShouldRecycleBitmaps() {
        return this.mShouldRecycleBitmaps;
    }

    public void setShouldRecycleBitmaps(boolean bl) {
        this.mShouldRecycleBitmaps = bl;
    }

    public void requestRender() {
        this.mRenderIsCancelled = false;
        this.mRenderIsSuppressed = false;
        if (this.mDetailLevelToRender == null) {
            return;
        }
        if (!this.mTileRenderThrottleHandler.hasMessages(1)) {
            this.mTileRenderThrottleHandler.sendEmptyMessageDelayed(1, this.mRenderBuffer);
        }
    }

    public void cancelRender() {
        this.mRenderIsCancelled = true;
        if (this.mTileRenderPoolExecutor != null) {
            this.mTileRenderPoolExecutor.cancel();
        }
    }

    public void suppressRender() {
        this.mRenderIsSuppressed = true;
    }

    public void updateTileSet(DetailLevel detailLevel) {
        this.mDetailLevelToRender = detailLevel;
        if (this.mDetailLevelToRender == null) {
            return;
        }
        if (this.mDetailLevelToRender.equals(this.mLastRequestedDetailLevel)) {
            return;
        }
        this.mLastRequestedDetailLevel = this.mDetailLevelToRender;
        this.mCurrentTileCanvasView = this.getCurrentTileCanvasView();
        this.mCurrentTileCanvasView.bringToFront();
        this.cancelRender();
        this.requestRender();
    }

    public boolean getIsRendering() {
        return this.mIsRendering;
    }

    public void clear() {
        this.suppressRender();
        this.cancelRender();
        this.mTilesInCurrentViewport.clear();
        this.mCurrentTileCanvasView.clearTiles(this.mShouldRecycleBitmaps);
    }

    public void reconcile(Set set) {
        for (Tile tile : this.mTilesInCurrentViewport) {
            if (set.contains(tile)) continue;
            this.mTilesNotInCurrentViewport.add(tile);
        }
        this.mTilesInCurrentViewport.addAll(set);
        this.mTilesInCurrentViewport.removeAll(this.mTilesNotInCurrentViewport);
        this.mTilesNotInCurrentViewport.clear();
    }

    private float getCurrentDetailLevelScale() {
        if (this.mDetailLevelToRender != null) {
            return this.mDetailLevelToRender.getScale();
        }
        return 1.0f;
    }

    private TileCanvasView getCurrentTileCanvasView() {
        float f = this.getCurrentDetailLevelScale();
        if (this.mTileCanvasViewHashMap.containsKey(Float.valueOf(f))) {
            return (TileCanvasView)((Object)this.mTileCanvasViewHashMap.get(Float.valueOf(f)));
        }
        TileCanvasView tileCanvasView = new TileCanvasView(this.getContext());
        tileCanvasView.setTileCanvasDrawListener(this);
        tileCanvasView.setScale(1.0f / f);
        this.mTileCanvasViewHashMap.put(Float.valueOf(f), tileCanvasView);
        this.addView(tileCanvasView);
        return tileCanvasView;
    }

    void renderTiles() {
        if (!this.mRenderIsCancelled && !this.mRenderIsSuppressed && this.mDetailLevelToRender != null) {
            this.beginRenderTask();
        }
    }

    private void beginRenderTask() {
        boolean bl = this.mDetailLevelToRender.computeCurrentState();
        if (!bl && this.mDetailLevelToRender.equals(this.mLastRenderedDetailLevel)) {
            return;
        }
        Set set = this.mDetailLevelToRender.getVisibleTilesFromLastViewportComputation();
        this.reconcile(set);
        if (this.mTileRenderPoolExecutor != null) {
            this.mTileRenderPoolExecutor.queue(this, this.getRenderSet());
        }
    }

    private void clearOutOfViewportTiles() {
        HashSet hashSet = new HashSet(this.mTilesAlreadyRendered);
        hashSet.removeAll(this.mTilesInCurrentViewport);
        this.mTilesAlreadyRendered.removeAll(hashSet);
        for (Tile tile : hashSet) {
            tile.destroy(this.mShouldRecycleBitmaps);
        }
        this.mCurrentTileCanvasView.invalidate();
    }

    private void cleanup() {
        this.clearOutOfViewportTiles();
        for (TileCanvasView tileCanvasView : this.mTileCanvasViewHashMap.values()) {
            if (this.mCurrentTileCanvasView == tileCanvasView) continue;
            tileCanvasView.clearTiles(this.mShouldRecycleBitmaps);
        }
        this.invalidate();
    }

    void onRenderTaskPreExecute() {
        this.mIsRendering = true;
        if (this.mTileRenderListener != null) {
            this.mTileRenderListener.onRenderStart();
        }
    }

    void onRenderTaskCancelled() {
        if (this.mTileRenderListener != null) {
            this.mTileRenderListener.onRenderCancelled();
        }
        this.mIsRendering = false;
    }

    void onRenderTaskPostExecute() {
        this.mIsRendering = false;
        this.mTileRenderThrottleHandler.post(this.mRenderPostExecuteRunnable);
    }

    Set getRenderSet() {
        HashSet hashSet = new HashSet(this.mTilesInCurrentViewport);
        hashSet.removeAll(this.mTilesAlreadyRendered);
        return hashSet;
    }

    void generateTileBitmap(Tile tile) {
        tile.generateBitmap(this.getContext(), this.getBitmapProvider());
    }

    void addTileToCurrentTileCanvasView(Tile tile) {
        if (!this.mTilesInCurrentViewport.contains(tile)) {
            return;
        }
        tile.setTransitionsEnabled(this.mTransitionsEnabled);
        tile.setTransitionDuration(this.mTransitionDuration);
        tile.stampTime();
        this.mTilesAlreadyRendered.add(tile);
        this.mCurrentTileCanvasView.addTile(tile);
    }

    void handleTileRenderException(Throwable throwable) {
        if (throwable instanceof OutOfMemoryError) {
            this.cleanup();
        }
    }

    boolean getRenderIsCancelled() {
        return this.mRenderIsCancelled;
    }

    @Override
    public void onDrawComplete(TileCanvasView tileCanvasView) {
        if (this.mTransitionsEnabled && tileCanvasView == this.mCurrentTileCanvasView) {
            this.cleanup();
        }
    }

    @Override
    public void onDrawPending(TileCanvasView tileCanvasView) {
        this.invalidate();
    }

    public void destroy() {
        this.mTileRenderPoolExecutor.shutdownNow();
        this.clear();
        for (TileCanvasView tileCanvasView : this.mTileCanvasViewHashMap.values()) {
            tileCanvasView.clearTiles(this.mShouldRecycleBitmaps);
        }
        this.mTileCanvasViewHashMap.clear();
        if (!this.mTileRenderThrottleHandler.hasMessages(1)) {
            this.mTileRenderThrottleHandler.removeMessages(1);
        }
    }

    public static interface TileRenderListener {
        public void onRenderStart();

        public void onRenderCancelled();

        public void onRenderComplete();
    }

    private static class TileRenderThrottleHandler
    extends Handler {
        private final WeakReference mTileCanvasViewGroupWeakReference;

        public TileRenderThrottleHandler(TileCanvasViewGroup tileCanvasViewGroup) {
            super(Looper.getMainLooper());
            this.mTileCanvasViewGroupWeakReference = new WeakReference<TileCanvasViewGroup>(tileCanvasViewGroup);
        }

        public final void handleMessage(Message message) {
            TileCanvasViewGroup tileCanvasViewGroup = (TileCanvasViewGroup)this.mTileCanvasViewGroupWeakReference.get();
            if (tileCanvasViewGroup != null) {
                tileCanvasViewGroup.renderTiles();
            }
        }
    }
}

