/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.markers;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.qozix.tileview.geom.FloatMathHelper;

public class MarkerLayout
extends ViewGroup {
    private float mScale = 1.0f;
    private float mAnchorX;
    private float mAnchorY;
    private MarkerTapListener mMarkerTapListener;

    public MarkerLayout(Context context) {
        super(context);
    }

    public void setAnchors(float f, float f2) {
        this.mAnchorX = f;
        this.mAnchorY = f2;
        this.requestLayout();
    }

    public void setScale(float f) {
        this.mScale = f;
        this.requestLayout();
    }

    public float getScale() {
        return this.mScale;
    }

    public View addMarker(View view, int n, int n2, Float f, Float f2) {
        LayoutParams layoutParams = new LayoutParams(-2, -2, n, n2, f, f2);
        return this.addMarker(view, layoutParams);
    }

    public View addMarker(View view, LayoutParams layoutParams) {
        this.addView(view, layoutParams);
        return view;
    }

    public void moveMarker(View view, int n, int n2) {
        LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
        layoutParams.x = n;
        layoutParams.y = n2;
        this.moveMarker(view, layoutParams);
    }

    public void moveMarker(View view, LayoutParams layoutParams) {
        if (this.indexOfChild(view) > -1) {
            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.requestLayout();
        }
    }

    public void removeMarker(View view) {
        this.removeView(view);
    }

    public void setMarkerTapListener(MarkerTapListener markerTapListener) {
        this.mMarkerTapListener = markerTapListener;
    }

    private View getViewFromTap(int n, int n2) {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View view = this.getChildAt(i);
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            Rect rect = layoutParams.getHitRect();
            if (!rect.contains(n, n2)) continue;
            return view;
        }
        return null;
    }

    public void processHit(int n, int n2) {
        View view;
        if (this.mMarkerTapListener != null && (view = this.getViewFromTap(n, n2)) != null) {
            this.mMarkerTapListener.onMarkerTap(view, n, n2);
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        this.measureChildren(n, n2);
        for (n3 = 0; n3 < this.getChildCount(); ++n3) {
            View view = this.getChildAt(n3);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            float f = layoutParams.anchorX == null ? this.mAnchorX : layoutParams.anchorX.floatValue();
            float f2 = layoutParams.anchorY == null ? this.mAnchorY : layoutParams.anchorY.floatValue();
            int n4 = view.getMeasuredWidth();
            int n5 = view.getMeasuredHeight();
            float f3 = (float)n4 * f;
            float f4 = (float)n5 * f2;
            int n6 = FloatMathHelper.scale(layoutParams.x, this.mScale);
            int n7 = FloatMathHelper.scale(layoutParams.y, this.mScale);
            layoutParams.mLeft = (int)((float)n6 + f3);
            layoutParams.mTop = (int)((float)n7 + f4);
            layoutParams.mRight = layoutParams.mLeft + n4;
            layoutParams.mBottom = layoutParams.mTop + n5;
        }
        n3 = View.MeasureSpec.getSize((int)n);
        int n8 = View.MeasureSpec.getSize((int)n2);
        this.setMeasuredDimension(n3, n8);
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            view.layout(layoutParams.mLeft, layoutParams.mTop, layoutParams.mRight, layoutParams.mBottom);
        }
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, 0, 0);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new LayoutParams(layoutParams);
    }

    public static interface MarkerTapListener {
        public void onMarkerTap(View var1, int var2, int var3);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int x = 0;
        public int y = 0;
        public Float anchorX = null;
        public Float anchorY = null;
        private int mTop;
        private int mLeft;
        private int mBottom;
        private int mRight;
        private Rect mHitRect;

        private Rect getHitRect() {
            if (this.mHitRect == null) {
                this.mHitRect = new Rect();
            }
            this.mHitRect.left = this.mLeft;
            this.mHitRect.top = this.mTop;
            this.mHitRect.right = this.mRight;
            this.mHitRect.bottom = this.mBottom;
            return this.mHitRect;
        }

        public LayoutParams(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public LayoutParams(int n, int n2) {
            super(n, n2);
        }

        public LayoutParams(int n, int n2, int n3, int n4) {
            super(n, n2);
            this.x = n3;
            this.y = n4;
        }

        public LayoutParams(int n, int n2, int n3, int n4, Float f, Float f2) {
            super(n, n2);
            this.x = n3;
            this.y = n4;
            this.anchorX = f;
            this.anchorY = f2;
        }
    }
}

