/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.detail;

import android.graphics.Rect;
import com.qozix.tileview.detail.DetailLevel;
import com.qozix.tileview.geom.FloatMathHelper;
import java.util.Collections;
import java.util.LinkedList;

public class DetailLevelManager {
    protected LinkedList mDetailLevelLinkedList = new LinkedList();
    private DetailLevelChangeListener mDetailLevelChangeListener;
    protected float mScale = 1.0f;
    private int mBaseWidth;
    private int mBaseHeight;
    private int mScaledWidth;
    private int mScaledHeight;
    private boolean mDetailLevelLocked;
    private int mPadding;
    private Rect mViewport = new Rect();
    private Rect mComputedViewport = new Rect();
    private DetailLevel mCurrentDetailLevel;

    public DetailLevelManager() {
        this.update();
    }

    public float getScale() {
        return this.mScale;
    }

    public void setScale(float f) {
        this.mScale = f;
        this.update();
    }

    public int getBaseWidth() {
        return this.mBaseWidth;
    }

    public int getBaseHeight() {
        return this.mBaseHeight;
    }

    public int getScaledWidth() {
        return this.mScaledWidth;
    }

    public int getScaledHeight() {
        return this.mScaledHeight;
    }

    public void setSize(int n, int n2) {
        this.mBaseWidth = n;
        this.mBaseHeight = n2;
        this.update();
    }

    public void setDetailLevelChangeListener(DetailLevelChangeListener detailLevelChangeListener) {
        this.mDetailLevelChangeListener = detailLevelChangeListener;
    }

    public void setViewportPadding(int n) {
        this.mPadding = n;
        this.updateComputedViewport();
    }

    public void updateViewport(int n, int n2, int n3, int n4) {
        this.mViewport.set(n, n2, n3, n4);
        this.updateComputedViewport();
    }

    private void updateComputedViewport() {
        this.mComputedViewport.set(this.mViewport);
        this.mComputedViewport.top -= this.mPadding;
        this.mComputedViewport.left -= this.mPadding;
        this.mComputedViewport.bottom += this.mPadding;
        this.mComputedViewport.right += this.mPadding;
    }

    public Rect getViewport() {
        return this.mViewport;
    }

    public Rect getComputedViewport() {
        return this.mComputedViewport;
    }

    public void lockDetailLevel() {
        this.mDetailLevelLocked = true;
    }

    public void unlockDetailLevel() {
        this.mDetailLevelLocked = false;
    }

    public void resetDetailLevels() {
        this.mDetailLevelLinkedList.clear();
        this.update();
    }

    public DetailLevel getCurrentDetailLevel() {
        return this.mCurrentDetailLevel;
    }

    protected void update() {
        DetailLevel detailLevel;
        boolean bl = false;
        if (!this.mDetailLevelLocked && (detailLevel = this.getDetailLevelForScale()) != null) {
            bl = !detailLevel.equals(this.mCurrentDetailLevel);
            this.mCurrentDetailLevel = detailLevel;
        }
        this.mScaledWidth = FloatMathHelper.scale(this.mBaseWidth, this.mScale);
        this.mScaledHeight = FloatMathHelper.scale(this.mBaseHeight, this.mScale);
        if (bl && this.mDetailLevelChangeListener != null) {
            this.mDetailLevelChangeListener.onDetailLevelChanged(this.mCurrentDetailLevel);
        }
    }

    public void addDetailLevel(float f, Object object, int n, int n2) {
        DetailLevel detailLevel = new DetailLevel(this, f, object, n, n2);
        if (this.mDetailLevelLinkedList.contains(detailLevel)) {
            return;
        }
        this.mDetailLevelLinkedList.add(detailLevel);
        Collections.sort(this.mDetailLevelLinkedList);
        this.update();
    }

    public DetailLevel getDetailLevelForScale() {
        int n;
        if (this.mDetailLevelLinkedList.size() == 0) {
            return null;
        }
        if (this.mDetailLevelLinkedList.size() == 1) {
            return (DetailLevel)this.mDetailLevelLinkedList.get(0);
        }
        DetailLevel detailLevel = null;
        for (int i = n = this.mDetailLevelLinkedList.size() - 1; i >= 0; --i) {
            detailLevel = (DetailLevel)this.mDetailLevelLinkedList.get(i);
            if (!(detailLevel.getScale() < this.mScale)) continue;
            if (i >= n) break;
            detailLevel = (DetailLevel)this.mDetailLevelLinkedList.get(i + 1);
            break;
        }
        return detailLevel;
    }

    public void invalidateAll() {
        for (DetailLevel detailLevel : this.mDetailLevelLinkedList) {
            detailLevel.invalidate();
        }
    }

    public static interface DetailLevelChangeListener {
        public void onDetailLevelChanged(DetailLevel var1);
    }
}

