/*
 * Decompiled with CFR 0.152.
 */
package com.qozix.tileview.detail;

import android.graphics.Rect;
import android.support.annotation.NonNull;
import com.qozix.tileview.detail.DetailLevelManager;
import com.qozix.tileview.tiles.Tile;
import java.util.HashSet;
import java.util.Set;

public class DetailLevel
implements Comparable {
    private float mScale;
    private int mTileWidth;
    private int mTileHeight;
    private Object mData;
    private DetailLevelManager mDetailLevelManager;
    private StateSnapshot mLastStateSnapshot;

    public DetailLevel(DetailLevelManager detailLevelManager, float f, Object object, int n, int n2) {
        this.mDetailLevelManager = detailLevelManager;
        this.mScale = f;
        this.mData = object;
        this.mTileWidth = n;
        this.mTileHeight = n2;
    }

    public boolean computeCurrentState() {
        float f = this.getRelativeScale();
        int n = this.mDetailLevelManager.getScaledWidth();
        int n2 = this.mDetailLevelManager.getScaledHeight();
        float f2 = (float)this.mTileWidth * f;
        float f3 = (float)this.mTileHeight * f;
        Rect rect = new Rect(this.mDetailLevelManager.getComputedViewport());
        rect.top = Math.max(rect.top, 0);
        rect.left = Math.max(rect.left, 0);
        rect.right = Math.min(rect.right, n);
        rect.bottom = Math.min(rect.bottom, n2);
        int n3 = (int)Math.floor((float)rect.top / f3);
        int n4 = (int)Math.ceil((float)rect.bottom / f3);
        int n5 = (int)Math.floor((float)rect.left / f2);
        int n6 = (int)Math.ceil((float)rect.right / f2);
        StateSnapshot stateSnapshot = new StateSnapshot(this, n3, n4, n5, n6);
        boolean bl = stateSnapshot.equals(this.mLastStateSnapshot);
        this.mLastStateSnapshot = stateSnapshot;
        return !bl;
    }

    public Set getVisibleTilesFromLastViewportComputation() {
        if (this.mLastStateSnapshot == null) {
            throw new StateNotComputedException();
        }
        HashSet<Tile> hashSet = new HashSet<Tile>();
        for (int i = this.mLastStateSnapshot.rowStart; i < this.mLastStateSnapshot.rowEnd; ++i) {
            for (int j = this.mLastStateSnapshot.columnStart; j < this.mLastStateSnapshot.columnEnd; ++j) {
                Tile tile = new Tile(j, i, this.mTileWidth, this.mTileHeight, this.mData, this);
                hashSet.add(tile);
            }
        }
        return hashSet;
    }

    public void invalidate() {
        this.mLastStateSnapshot = null;
    }

    public float getScale() {
        return this.mScale;
    }

    public float getRelativeScale() {
        return this.mDetailLevelManager.getScale() / this.mScale;
    }

    public int getTileWidth() {
        return this.mTileWidth;
    }

    public int getTileHeight() {
        return this.mTileHeight;
    }

    public Object getData() {
        return this.mData;
    }

    public int compareTo(@NonNull DetailLevel detailLevel) {
        return (int)Math.signum(this.getScale() - detailLevel.getScale());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DetailLevel) {
            DetailLevel detailLevel = (DetailLevel)object;
            return this.mScale == detailLevel.getScale();
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.getScale()) * 43L;
        return (int)l ^ (int)(l >> 32);
    }

    private static class StateSnapshot {
        public int rowStart;
        public int rowEnd;
        public int columnStart;
        public int columnEnd;
        public DetailLevel detailLevel;

        public StateSnapshot(DetailLevel detailLevel, int n, int n2, int n3, int n4) {
            this.detailLevel = detailLevel;
            this.rowStart = n;
            this.rowEnd = n2;
            this.columnStart = n3;
            this.columnEnd = n4;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof StateSnapshot) {
                StateSnapshot stateSnapshot = (StateSnapshot)object;
                return this.detailLevel.equals(stateSnapshot.detailLevel) && this.rowStart == stateSnapshot.rowStart && this.columnStart == stateSnapshot.columnStart && this.rowEnd == stateSnapshot.rowEnd && this.columnEnd == stateSnapshot.columnEnd;
            }
            return false;
        }
    }

    public static class StateNotComputedException
    extends IllegalStateException {
        public StateNotComputedException() {
            super("Grid has not been computed; you must call computeCurrentState at some point prior to calling getVisibleTilesFromLastViewportComputation.");
        }
    }
}

