/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLStringSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

final class MavenUtil {
    MavenUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Model readModel(File pomFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(pomFile);){
            Model model = new MavenXpp3Reader().read((InputStream)inputStream);
            model.setPomFile(pomFile);
            Model model2 = model;
            return model2;
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
    }

    static void writeModel(File pomFile, Model model) throws IOException {
        try (FileWriter fileWriter = new FileWriter(pomFile);){
            new MavenXpp3Writer().write((Writer)fileWriter, model);
        }
    }

    public static File pomFile(File workingDirectory, String relativePath) {
        File modulePomFile = new File(workingDirectory, relativePath);
        if (modulePomFile.isDirectory()) {
            modulePomFile = new File(modulePomFile, "pom.xml");
        }
        return modulePomFile;
    }

    public static void writeXml(File file, Document gitVersionedPom) throws IOException {
        byte[] existingPomBytes;
        byte[] gitVersionedPomBytes = gitVersionedPom.toXML().getBytes();
        if (file.exists() && Arrays.equals(gitVersionedPomBytes, existingPomBytes = Files.readAllBytes(file.toPath()))) {
            return;
        }
        Files.write(file.toPath(), gitVersionedPomBytes, new OpenOption[0]);
    }

    public static Document readXml(File file) throws IOException {
        String pomXml = new String(Files.readAllBytes(file.toPath()));
        XMLParser parser = new XMLParser();
        return parser.parse((XMLSource)new XMLStringSource(pomXml));
    }

    public static BuildBase getBuild(ModelBase model) {
        if (model instanceof Profile) {
            return ((Profile)model).getBuild();
        }
        return ((Model)model).getBuild();
    }
}

