/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.GitUtil;
import me.qoomon.gitversioning.commons.Lazy;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class GitSituation {
    private final Repository repository;
    private final File rootDirectory;
    private final ObjectId head;
    private final String rev;
    private final Supplier<ZonedDateTime> timestamp = Lazy.by(this::timestamp);
    private Supplier<String> branch = Lazy.by(this::branch);
    private final Supplier<Map<ObjectId, List<Ref>>> reverseTagRefMap = Lazy.by(this::reverseTagRefMap);
    private Supplier<List<String>> tags = Lazy.by(this::tags);
    private final Supplier<Boolean> clean = Lazy.by(this::clean);
    private Pattern describeTagPattern = Pattern.compile(".*");
    private Supplier<GitDescription> description = Lazy.by(this::describe);

    public GitSituation(Repository repository) throws IOException {
        this.repository = repository;
        this.rootDirectory = repository.getWorkTree();
        this.head = repository.resolve("HEAD");
        this.rev = this.head != null ? this.head.getName() : GitUtil.NO_COMMIT;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public String getRev() {
        return this.rev;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp.get();
    }

    public String getBranch() {
        return this.branch.get();
    }

    public void setBranch(String branch) {
        this.branch = () -> branch;
    }

    public boolean isDetached() {
        return this.branch.get() == null;
    }

    public List<String> getTags() {
        return this.tags.get();
    }

    public void setTags(List<String> tags) {
        this.tags = () -> Objects.requireNonNull(tags);
    }

    public boolean isClean() {
        return this.clean.get();
    }

    public void setDescribeTagPattern(Pattern describeTagPattern) {
        this.describeTagPattern = Objects.requireNonNull(describeTagPattern);
        this.description = Lazy.by(this::describe);
    }

    public Pattern getDescribeTagPattern() {
        return this.describeTagPattern;
    }

    public GitDescription getDescription() {
        return this.description.get();
    }

    private ZonedDateTime timestamp() throws IOException {
        return this.head != null ? GitUtil.revTimestamp(this.repository, this.head) : ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
    }

    private String branch() throws IOException {
        return GitUtil.branch(this.repository);
    }

    private List<String> tags() {
        return this.head != null ? GitUtil.tagsPointAt(this.repository, this.head, this.reverseTagRefMap.get()) : Collections.emptyList();
    }

    private boolean clean() {
        return GitUtil.status(this.repository).isClean();
    }

    private GitDescription describe() throws IOException {
        return GitUtil.describe(this.repository, this.head, this.describeTagPattern, this.reverseTagRefMap.get());
    }

    private Map<ObjectId, List<Ref>> reverseTagRefMap() throws IOException {
        return GitUtil.reverseTagRefMap(this.repository);
    }
}

