/*
 * Decompiled with CFR 0.152.
 */
package com.qoomon.maven.extension.gitversioning;

import com.qoomon.maven.BuildProperties;
import com.qoomon.maven.GAV;
import com.qoomon.maven.ModelUtil;
import com.qoomon.maven.extension.gitversioning.SessionScopeUtil;
import com.qoomon.maven.extension.gitversioning.VersioningPomReplacementMojo;
import com.qoomon.maven.extension.gitversioning.config.VersioningConfiguration;
import com.qoomon.maven.extension.gitversioning.config.VersioningConfigurationProvider;
import com.qoomon.maven.extension.gitversioning.config.model.VersionFormatDescription;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Component(role=ModelProcessor.class)
public class VersioningModelProcessor
extends DefaultModelProcessor {
    private Logger logger;
    private SessionScope sessionScope;
    private VersioningConfigurationProvider configurationProvider;
    private static final String GIT_VERSIONING_PROPERTY_KEY = "gitVersioning";
    private static final String PROJECT_BRANCH_PROPERTY_KEY = "project.branch";
    private static final String PROJECT_BRANCH_ENVIRONMENT_VARIABLE_NAME = "MAVEN_PROJECT_BRANCH";
    private static final String PROJECT_TAG_PROPERTY_KEY = "project.tag";
    private static final String PROJECT_TAG_ENVIRONMENT_VARIABLE_NAME = "MAVEN_PROJECT_TAG";
    private MavenSession mavenSession;
    private VersioningConfiguration configuration;
    private boolean initialized = false;
    private boolean disabled = false;

    @Inject
    public VersioningModelProcessor(Logger logger, SessionScope sessionScope, VersioningConfigurationProvider configurationProvider) {
        this.logger = logger;
        this.sessionScope = sessionScope;
        this.configurationProvider = configurationProvider;
    }

    public Model read(File input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    private Model provisionModel(Model model, Map<String, ?> options) throws IOException {
        try {
            if (!this.initialized) {
                this.initialize();
                this.initialized = true;
            }
            if (this.disabled) {
                return model;
            }
            Source pomSource = (Source)options.get("org.apache.maven.model.building.source");
            File pomFile = new File(pomSource != null ? pomSource.getLocation() : "");
            if (!this.isProjectPom(pomFile)) {
                this.logger.debug("skip unrelated model - source" + pomFile);
                return model;
            }
            GAV projectGav = GAV.of(model);
            ProjectVersion projectVersion = this.deduceProjectVersion(projectGav, pomFile.getParentFile());
            if (projectVersion.getBranch() != null) {
                model.addProperty(PROJECT_BRANCH_PROPERTY_KEY, projectVersion.getBranch());
            }
            if (projectVersion.getTag() != null) {
                model.addProperty(PROJECT_TAG_PROPERTY_KEY, projectVersion.getTag());
            }
            model.addProperty("project.commit", projectVersion.getCommit());
            if (model.getParent() != null) {
                Model parentModel;
                GAV parentProjectGav;
                File parentPomFile = new File(pomFile.getParentFile(), model.getParent().getRelativePath());
                GAV parentGav = GAV.of(model.getParent());
                if (parentPomFile.exists() && this.isProjectPom(parentPomFile) && (parentProjectGav = GAV.of(parentModel = ModelUtil.readModel(parentPomFile))).equals(parentGav)) {
                    ProjectVersion parentProjectVersion = this.deduceProjectVersion(parentGav, parentPomFile.getParentFile());
                    this.logger.debug(projectGav + " adjust project parent version to " + parentProjectVersion);
                    model.getParent().setVersion(parentProjectVersion.getVersion());
                }
            }
            if (model.getParent() == null || !model.getParent().getVersion().equals(projectVersion.getVersion())) {
                this.logger.debug(projectGav + " adjust project version to " + projectVersion);
                model.setVersion(projectVersion.getVersion());
            }
            this.addBuildPlugin(model);
            return model;
        }
        catch (Exception e) {
            throw new IOException("Branch Versioning Model Processor", e);
        }
    }

    private void initialize() {
        this.logger.info("--- " + BuildProperties.projectArtifactId() + ":" + BuildProperties.projectVersion() + " ---");
        Optional<MavenSession> mavenSessionOptional = SessionScopeUtil.get(this.sessionScope, MavenSession.class);
        if (!mavenSessionOptional.isPresent()) {
            this.logger.warn("Skip provisioning. No MavenSession present.");
            this.disabled = true;
        } else {
            this.mavenSession = mavenSessionOptional.get();
            String gitVersioning = this.mavenSession.getUserProperties().getProperty(GIT_VERSIONING_PROPERTY_KEY);
            if ("false".equals(gitVersioning)) {
                this.logger.info("Disabled.");
                this.disabled = true;
            }
            if (!this.disabled) {
                this.configuration = this.configurationProvider.get();
            }
        }
    }

    private boolean isProjectPom(File pomFile) {
        return pomFile.isFile() && pomFile.getName().endsWith(".xml");
    }

    private void addBuildPlugin(Model model) {
        GAV projectGav = GAV.of(model);
        this.logger.debug(projectGav + " temporary add build plugin");
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        Plugin projectPlugin = VersioningPomReplacementMojo.asPlugin();
        PluginExecution execution = new PluginExecution();
        execution.setId("pom-replacement");
        execution.getGoals().add("pom-replacement");
        projectPlugin.getExecutions().add(execution);
        model.getBuild().getPlugins().add(projectPlugin);
    }

    private ProjectVersion deduceProjectVersion(GAV gav, File gitDir) throws IOException {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(gitDir);
        this.logger.debug(gav + "git directory " + repositoryBuilder.getGitDir());
        try (Repository repository = repositoryBuilder.build();){
            List<String> headTags;
            Status status = this.getStatus(repository);
            String headCommit = this.getHeadCommit(repository);
            String projectBranchName = null;
            String projectTagName = null;
            VersionFormatDescription projectVersionFormatDescription = null;
            Map<String, String> projectVersionDataMap = VersioningModelProcessor.buildCommonVersionDataMap(headCommit, gav);
            if (status.isClean() && !this.configuration.getTagVersionDescriptions().isEmpty() && !(headTags = this.getHeadTags(repository)).isEmpty()) {
                for (VersionFormatDescription versionFormatDescription2 : this.configuration.getTagVersionDescriptions()) {
                    String tagName = ((Stream)headTags.stream().sequential()).filter(tag -> tag.matches(versionFormatDescription.pattern)).sorted((versionLeft, versionRight) -> {
                        DefaultArtifactVersion tagVersionLeft = new DefaultArtifactVersion(VersioningModelProcessor.removePrefix(versionLeft, versionFormatDescription.prefix));
                        DefaultArtifactVersion tagVersionRight = new DefaultArtifactVersion(VersioningModelProcessor.removePrefix(versionRight, versionFormatDescription.prefix));
                        return tagVersionLeft.compareTo((ArtifactVersion)tagVersionRight) * -1;
                    }).findFirst().orElse(null);
                    if (tagName == null) continue;
                    projectTagName = tagName;
                    projectVersionFormatDescription = versionFormatDescription2;
                    projectVersionDataMap.put("tag", VersioningModelProcessor.removePrefix(projectTagName, projectVersionFormatDescription.prefix));
                    projectVersionDataMap.putAll(this.getRegexGroupValueMap(projectVersionFormatDescription.pattern, projectTagName));
                    break;
                }
            }
            if (projectTagName == null) {
                String branchName;
                projectBranchName = branchName = this.getHeadBranch(repository).orElseThrow(() -> new ModelParseException(gitDir + ": No Branch Name provided in Detached HEAD state. See documentation.", 0, 0));
                projectVersionFormatDescription = this.configuration.getBranchVersionDescriptions().stream().filter(versionFormatDescription -> branchName.matches(versionFormatDescription.pattern)).findFirst().orElseThrow(() -> new ModelParseException(gitDir + ": No version format for branch '" + branchName + "' found.", 0, 0));
                projectVersionDataMap.put("branch", VersioningModelProcessor.removePrefix(projectBranchName, projectVersionFormatDescription.prefix));
                projectVersionDataMap.putAll(this.getRegexGroupValueMap(projectVersionFormatDescription.pattern, projectBranchName));
            }
            String version = StrSubstitutor.replace((Object)projectVersionFormatDescription.versionFormat, projectVersionDataMap);
            ProjectVersion projectVersion = new ProjectVersion(VersioningModelProcessor.escapeVersion(version), headCommit, projectBranchName, projectTagName);
            this.logger.info(gav.getArtifactId() + ":" + gav.getVersion() + (projectVersion.getTag() != null ? " - tag: " + projectVersion.getTag() : "") + (projectVersion.getTag() != null ? " - branch: " + projectVersion.getBranch() : "") + " -> version: " + projectVersion.getVersion());
            ProjectVersion projectVersion2 = projectVersion;
            return projectVersion2;
        }
    }

    private static Map<String, String> buildCommonVersionDataMap(String commit, GAV gav) {
        HashMap<String, String> versionDataMap = new HashMap<String, String>();
        versionDataMap.put("commit", commit);
        versionDataMap.put("commit.short", commit.substring(0, 7));
        versionDataMap.put("version", gav.getVersion());
        versionDataMap.put("version.release", gav.getVersion().replaceFirst("-SNAPSHOT$", ""));
        return versionDataMap;
    }

    private Status getStatus(Repository repository) {
        try {
            return Git.wrap((Repository)repository).status().call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<String> getHeadBranch(Repository repository) throws IOException {
        Optional<String> branchOverwrite = ((Stream)Stream.of(this.mavenSession.getUserProperties().getProperty(PROJECT_BRANCH_PROPERTY_KEY), System.getenv(PROJECT_BRANCH_ENVIRONMENT_VARIABLE_NAME)).sequential()).filter(Objects::nonNull).findFirst();
        if (branchOverwrite.isPresent()) {
            return branchOverwrite;
        }
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return Optional.of("master");
        }
        boolean detachedHead = ObjectId.isId((String)repository.getFullBranch());
        if (detachedHead) {
            return Optional.empty();
        }
        return Optional.of(repository.getBranch());
    }

    private List<String> getHeadTags(Repository repository) throws IOException {
        Optional<String> tagOverwrite = ((Stream)Stream.of(this.mavenSession.getUserProperties().getProperty(PROJECT_TAG_PROPERTY_KEY), System.getenv(PROJECT_TAG_ENVIRONMENT_VARIABLE_NAME)).sequential()).filter(Objects::nonNull).findFirst();
        if (tagOverwrite.isPresent()) {
            return Collections.singletonList(tagOverwrite.get());
        }
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return Collections.emptyList();
        }
        return repository.getTags().values().stream().map(arg_0 -> ((Repository)repository).peel(arg_0)).filter(ref -> {
            ObjectId objectId = ref.getPeeledObjectId() != null ? ref.getPeeledObjectId() : ref.getObjectId();
            return objectId.equals((AnyObjectId)head);
        }).map(ref -> ref.getName().replaceFirst("^refs/tags/", "")).collect(Collectors.toList());
    }

    private String getHeadCommit(Repository repository) throws IOException {
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return "0000000000000000000000000000000000000000";
        }
        return head.getName();
    }

    private Map<String, String> getRegexGroupValueMap(String regex, String text) {
        HashMap<String, String> result = new HashMap<String, String>();
        Pattern groupPattern = Pattern.compile(regex);
        Matcher groupMatcher = groupPattern.matcher(text);
        if (groupMatcher.find()) {
            for (int i = 0; i <= groupMatcher.groupCount(); ++i) {
                result.put(String.valueOf(i), groupMatcher.group(i));
            }
            Pattern groupNamePattern = Pattern.compile("\\(\\?<(?<name>[a-zA-Z][a-zA-Z0-9]*)>");
            Matcher groupNameMatcher = groupNamePattern.matcher(groupPattern.toString());
            while (groupNameMatcher.find()) {
                String groupName = groupNameMatcher.group("name");
                result.put(groupName, groupMatcher.group(groupName));
            }
        }
        return result;
    }

    private static String removePrefix(String string, String prefix) {
        return string.replaceFirst(Pattern.quote(prefix), "");
    }

    private static String escapeVersion(String version) {
        return version.replace("/", "-");
    }

    class ProjectVersion {
        final String version;
        final String commit;
        final String branch;
        final String tag;

        ProjectVersion(String version, String commit, String branch, String tag) {
            this.version = version;
            this.commit = commit;
            this.branch = branch;
            this.tag = tag;
        }

        String getVersion() {
            return this.version;
        }

        String getCommit() {
            return this.commit;
        }

        String getBranch() {
            return this.branch;
        }

        String getTag() {
            return this.tag;
        }

        public String toString() {
            return this.version;
        }
    }
}

