/*
 * Decompiled with CFR 0.152.
 */
package com.qoomon.maven.extension.gitversioning;

import com.qoomon.maven.BuildProperties;
import com.qoomon.maven.GAV;
import com.qoomon.maven.ModelUtil;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.InstantiationStrategy;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.logging.Logger;

@Mojo(name="pom-replacement", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, instantiationStrategy=InstantiationStrategy.SINGLETON, threadSafe=true)
public class VersioningPomReplacementMojo
extends AbstractMojo {
    static final String GOAL = "pom-replacement";
    private MavenSession mavenSession;
    private Logger logger;

    @Inject
    public VersioningPomReplacementMojo(Logger logger, MavenSession mavenSession) {
        this.mavenSession = mavenSession;
        this.logger = logger;
    }

    public synchronized void execute() throws MojoExecutionException, MojoFailureException {
        try {
            MavenProject currentProject = this.mavenSession.getCurrentProject();
            GAV gav = GAV.of(currentProject);
            this.logger.debug(gav + "remove plugin");
            currentProject.getOriginalModel().getBuild().removePlugin(VersioningPomReplacementMojo.asPlugin());
            this.temporaryOverridePomFileFromModel(currentProject);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Git Versioning Pom Replacement Mojo", e);
        }
    }

    static Plugin asPlugin() {
        Plugin plugin = new Plugin();
        plugin.setGroupId(BuildProperties.projectGroupId());
        plugin.setArtifactId(BuildProperties.projectArtifactId());
        plugin.setVersion(BuildProperties.projectVersion());
        return plugin;
    }

    public void temporaryOverridePomFileFromModel(MavenProject project) throws IOException {
        File tmpPomFile = new File(project.getBuild().getDirectory(), "git_pom.xml");
        tmpPomFile.getParentFile().mkdirs();
        ModelUtil.writeModel(project.getOriginalModel(), tmpPomFile);
        this.logger.debug(project.getArtifact() + " temporary override pom file with " + tmpPomFile);
        project.setPomFile(tmpPomFile);
    }
}

