/*
 * Decompiled with CFR 0.152.
 */
package com.qoomon.maven.extension.gitversioning;

import com.qoomon.maven.BuildProperties;
import com.qoomon.maven.GAV;
import com.qoomon.maven.ModelUtil;
import com.qoomon.maven.extension.gitversioning.SessionScopeUtil;
import com.qoomon.maven.extension.gitversioning.VersioningPomReplacementMojo;
import com.qoomon.maven.extension.gitversioning.config.VersioningConfiguration;
import com.qoomon.maven.extension.gitversioning.config.VersioningConfigurationProvider;
import com.qoomon.maven.extension.gitversioning.config.model.VersionFormatDescription;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.io.ModelParseException;
import org.apache.maven.session.scope.internal.SessionScope;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Component(role=ModelProcessor.class)
public class VersioningModelProcessor
extends DefaultModelProcessor {
    private Logger logger;
    private SessionScope sessionScope;
    private VersioningConfigurationProvider configurationProvider;
    private static final String GIT_VERSIONING_PROPERTY_KEY = "gitVersioning";
    private static final String PROJECT_BRANCH_PROPERTY_KEY = "project.branch";
    private static final String PROJECT_BRANCH_ENVIRONMENT_VARIABLE_NAME = "MAVEN_PROJECT_BRANCH";
    private static final String PROJECT_TAG_PROPERTY_KEY = "project.tag";
    private static final String PROJECT_TAG_ENVIRONMENT_VARIABLE_NAME = "MAVEN_PROJECT_TAG";
    private MavenSession mavenSession;
    private VersioningConfiguration configuration;
    private boolean initialized = false;
    private boolean disabled = false;

    @Inject
    public VersioningModelProcessor(Logger logger, SessionScope sessionScope, VersioningConfigurationProvider configurationProvider) {
        this.logger = logger;
        this.sessionScope = sessionScope;
        this.configurationProvider = configurationProvider;
    }

    public Model read(File input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        return this.provisionModel(super.read(input, options), options);
    }

    private Model provisionModel(Model model, Map<String, ?> options) throws IOException {
        try {
            if (!this.initialized) {
                this.initialize();
                this.initialized = true;
            }
            if (this.disabled) {
                return model;
            }
            Source pomSource = (Source)options.get("org.apache.maven.model.building.source");
            File pomFile = new File(pomSource != null ? pomSource.getLocation() : "");
            if (!this.isProjectPom(pomFile)) {
                this.logger.debug("skip unrelated model - source" + pomFile);
                return model;
            }
            GAV projectGav = GAV.of(model);
            ProjectVersion projectVersion = this.deduceProjectVersion(projectGav, pomFile.getParentFile());
            model.addProperty(PROJECT_BRANCH_PROPERTY_KEY, projectVersion.getBranch());
            model.addProperty(PROJECT_TAG_PROPERTY_KEY, projectVersion.getTag());
            model.addProperty("project.commit", projectVersion.getCommit());
            if (model.getVersion() != null) {
                this.logger.debug(projectGav + " temporary override getVersion with " + projectVersion);
                model.setVersion(projectVersion.getVersion());
            }
            if (model.getParent() != null) {
                Model parentModel;
                GAV parentProjectGav;
                File parentPomFile = new File(pomFile.getParentFile(), model.getParent().getRelativePath());
                GAV parentGav = GAV.of(model.getParent());
                if (parentPomFile.exists() && this.isProjectPom(parentPomFile) && (parentProjectGav = GAV.of(parentModel = ModelUtil.readModel(parentPomFile))).equals(parentGav)) {
                    ProjectVersion parentProjectVersion = this.deduceProjectVersion(parentGav, parentPomFile.getParentFile());
                    this.logger.debug(projectGav + " adjust parent getVersion to " + parentProjectVersion);
                    model.getParent().setVersion(parentProjectVersion.getVersion());
                }
            }
            this.addBuildPlugin(model);
            return model;
        }
        catch (Exception e) {
            throw new IOException("Branch Versioning Model Processor", e);
        }
    }

    private void initialize() throws Exception {
        this.logger.info("--- " + BuildProperties.projectArtifactId() + ":" + BuildProperties.projectVersion() + " ---");
        Optional<MavenSession> mavenSessionOptional = SessionScopeUtil.get(this.sessionScope, MavenSession.class);
        if (!mavenSessionOptional.isPresent()) {
            this.logger.warn("Skip provisioning. No MavenSession present.");
            this.disabled = true;
        } else {
            this.mavenSession = mavenSessionOptional.get();
            String gitVersioning = this.mavenSession.getUserProperties().getProperty(GIT_VERSIONING_PROPERTY_KEY);
            if ("false".equals(gitVersioning)) {
                this.logger.info("Disabled.");
                this.disabled = true;
            }
            if (!this.disabled) {
                this.configuration = this.configurationProvider.get();
            }
        }
    }

    private boolean isProjectPom(File pomFile) {
        return pomFile.isFile() && pomFile.getName().endsWith(".xml");
    }

    private void addBuildPlugin(Model model) {
        GAV projectGav = GAV.of(model);
        this.logger.debug(projectGav + " temporary add build plugin");
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        Plugin projectPlugin = VersioningPomReplacementMojo.asPlugin();
        PluginExecution execution = new PluginExecution();
        execution.setId("pom-replacement");
        execution.getGoals().add("pom-replacement");
        projectPlugin.getExecutions().add(execution);
        model.getBuild().getPlugins().add(projectPlugin);
    }

    private ProjectVersion deduceProjectVersion(GAV gav, File gitDir) throws IOException {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(gitDir);
        this.logger.debug(gav + "git directory " + repositoryBuilder.getGitDir());
        Optional<Object> projectVersion = Optional.empty();
        try (Repository repository = repositoryBuilder.build();){
            String headCommit = this.getHeadCommit(repository);
            List<String> headTags = this.getHeadTags(repository);
            if (!this.configuration.getTagVersionDescriptions().isEmpty()) {
                Optional<Object> versionTag = Optional.empty();
                VersionFormatDescription tagVersionFormatDescription = null;
                for (VersionFormatDescription versionFormatDescription2 : this.configuration.getTagVersionDescriptions()) {
                    versionTag = ((Stream)headTags.stream().sequential()).filter(tagName -> tagName.matches(versionFormatDescription.pattern)).sorted((tagLeft, tagRight) -> {
                        DefaultArtifactVersion tagVersionLeft = new DefaultArtifactVersion(tagLeft.replaceFirst(versionFormatDescription.prefix, ""));
                        DefaultArtifactVersion tagVersionRight = new DefaultArtifactVersion(tagRight.replaceFirst(versionFormatDescription.prefix, ""));
                        return tagVersionLeft.compareTo((ArtifactVersion)tagVersionRight) * -1;
                    }).findFirst();
                    if (!versionTag.isPresent()) continue;
                    tagVersionFormatDescription = versionFormatDescription2;
                    break;
                }
                if (versionTag.isPresent()) {
                    Map<String, String> tagVersionDataMap = VersioningModelProcessor.buildCommonVersionDataMap(headCommit, gav);
                    tagVersionDataMap.put("tag", ((String)versionTag.get()).replaceFirst(tagVersionFormatDescription.prefix, "").replace("/", "-"));
                    String tagVersion = StrSubstitutor.replace((Object)tagVersionFormatDescription.versionFormat, tagVersionDataMap);
                    projectVersion = Optional.of(new ProjectVersion(tagVersion, headCommit, "", (String)versionTag.get()));
                }
            }
            if (!projectVersion.isPresent()) {
                String headBranch = this.getHeadBranch(repository).orElseThrow(() -> new ModelParseException(gitDir + ": No Branch Name provided in Detached HEAD state. See documentation.", 0, 0));
                VersionFormatDescription branchVersionFormatDescription = this.configuration.getBranchVersionDescriptions().stream().filter(versionFormatDescription -> headBranch.matches(versionFormatDescription.pattern)).findFirst().orElseThrow(() -> new ModelParseException(gitDir + ": No version format for branch '" + headBranch + "' found.", 0, 0));
                Map<String, String> branchVersionDataMap = VersioningModelProcessor.buildCommonVersionDataMap(headCommit, gav);
                branchVersionDataMap.put("branch", headBranch.replaceFirst(branchVersionFormatDescription.prefix, "").replace("/", "-"));
                String branchVersion = StrSubstitutor.replace((Object)branchVersionFormatDescription.versionFormat, branchVersionDataMap);
                projectVersion = Optional.of(new ProjectVersion(branchVersion, headCommit, headBranch, ""));
            }
            this.logger.info(gav.getArtifactId() + ":" + gav.getVersion() + (!((ProjectVersion)projectVersion.get()).getTag().isEmpty() ? " - tag: " + ((ProjectVersion)projectVersion.get()).getTag() : " - branch: " + ((ProjectVersion)projectVersion.get()).getBranch()) + " -> version: " + ((ProjectVersion)projectVersion.get()).getVersion());
            ProjectVersion projectVersion2 = (ProjectVersion)projectVersion.get();
            return projectVersion2;
        }
    }

    private static Map<String, String> buildCommonVersionDataMap(String commit, GAV gav) {
        HashMap<String, String> versionDataMap = new HashMap<String, String>();
        versionDataMap.put("commit", commit);
        versionDataMap.put("commit.short", commit.substring(0, 7));
        versionDataMap.put("version", gav.getVersion());
        versionDataMap.put("version.release", gav.getVersion().replaceFirst("-SNAPSHOT$", ""));
        return versionDataMap;
    }

    private Optional<String> getHeadBranch(Repository repository) throws IOException {
        Optional<String> branchOverwrite = ((Stream)Stream.of(this.mavenSession.getUserProperties().getProperty(PROJECT_BRANCH_PROPERTY_KEY), System.getenv(PROJECT_BRANCH_ENVIRONMENT_VARIABLE_NAME)).sequential()).filter(Objects::nonNull).findFirst();
        if (branchOverwrite.isPresent()) {
            return branchOverwrite;
        }
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return Optional.of("master");
        }
        boolean detachedHead = ObjectId.isId((String)repository.getFullBranch());
        if (detachedHead) {
            return Optional.empty();
        }
        return Optional.of(repository.getBranch());
    }

    private List<String> getHeadTags(Repository repository) throws IOException {
        Optional<String> tagOverwrite = ((Stream)Stream.of(this.mavenSession.getUserProperties().getProperty(PROJECT_TAG_PROPERTY_KEY), System.getenv(PROJECT_TAG_ENVIRONMENT_VARIABLE_NAME)).sequential()).filter(Objects::nonNull).findFirst();
        if (tagOverwrite.isPresent()) {
            return Collections.singletonList(tagOverwrite.get());
        }
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return Collections.emptyList();
        }
        return repository.getTags().values().stream().map(arg_0 -> ((Repository)repository).peel(arg_0)).filter(ref -> {
            ObjectId objectId = ref.getPeeledObjectId() != null ? ref.getPeeledObjectId() : ref.getObjectId();
            return objectId.equals((AnyObjectId)head);
        }).map(ref -> ref.getName().replaceFirst("^refs/tags/", "")).collect(Collectors.toList());
    }

    private String getHeadCommit(Repository repository) throws IOException {
        ObjectId head = repository.resolve("HEAD");
        if (head == null) {
            return "0000000000000000000000000000000000000000";
        }
        return head.getName();
    }

    class ProjectVersion {
        final String value;
        final String commit;
        final String branch;
        final String tag;

        ProjectVersion(String version, String commit, String branch, String tag) {
            this.value = version;
            this.commit = commit;
            this.branch = branch;
            this.tag = tag;
        }

        String getVersion() {
            return this.value;
        }

        String getCommit() {
            return this.commit;
        }

        String getBranch() {
            return this.branch;
        }

        String getTag() {
            return this.tag;
        }
    }
}

