/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.tab;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.tab.QMUITab;

public class QMUITabIndicator {
    private int mIndicatorHeight;
    private boolean mIndicatorTop = false;
    @Nullable
    private Drawable mIndicatorDrawable;
    private boolean mIsIndicatorWidthFollowContent = true;
    private Rect mIndicatorRect = null;
    private Paint mIndicatorPaint = null;
    private int mFixedColorAttr = 0;
    private boolean mShouldReGetFixedColor = true;
    private int mFixedColor = 0;

    public QMUITabIndicator(int indicatorHeight, boolean indicatorTop, boolean isIndicatorWidthFollowContent) {
        this(indicatorHeight, indicatorTop, isIndicatorWidthFollowContent, 0);
    }

    public QMUITabIndicator(int indicatorHeight, boolean indicatorTop, boolean isIndicatorWidthFollowContent, int fixedColorAttr) {
        this.mIndicatorHeight = indicatorHeight;
        this.mIndicatorTop = indicatorTop;
        this.mIsIndicatorWidthFollowContent = isIndicatorWidthFollowContent;
        this.mFixedColorAttr = fixedColorAttr;
    }

    public QMUITabIndicator(@NonNull Drawable drawable2, boolean indicatorTop, boolean isIndicatorWidthFollowContent) {
        this(drawable2, indicatorTop, isIndicatorWidthFollowContent, 0);
    }

    public QMUITabIndicator(@NonNull Drawable drawable2, boolean indicatorTop, boolean isIndicatorWidthFollowContent, int fixedColorAttr) {
        this.mIndicatorDrawable = drawable2;
        this.mIndicatorHeight = drawable2.getIntrinsicHeight();
        this.mIndicatorTop = indicatorTop;
        this.mIsIndicatorWidthFollowContent = isIndicatorWidthFollowContent;
        this.mFixedColorAttr = fixedColorAttr;
    }

    public boolean isIndicatorWidthFollowContent() {
        return this.mIsIndicatorWidthFollowContent;
    }

    public boolean isIndicatorTop() {
        return this.mIndicatorTop;
    }

    @Deprecated
    protected void updateInfo(int left, int width, int color2) {
        if (this.mIndicatorRect == null) {
            this.mIndicatorRect = new Rect(left, 0, left + width, 0);
        } else {
            this.mIndicatorRect.left = left;
            this.mIndicatorRect.right = left + width;
        }
        if (this.mFixedColorAttr == 0) {
            this.updateColor(color2);
        }
    }

    protected void updateInfo(int left, int width, int color2, float offsetPercent) {
        this.updateInfo(left, width, color2);
    }

    protected void updateColor(int color2) {
        if (this.mIndicatorDrawable != null) {
            DrawableCompat.setTint((Drawable)this.mIndicatorDrawable, (int)color2);
        } else {
            if (this.mIndicatorPaint == null) {
                this.mIndicatorPaint = new Paint();
                this.mIndicatorPaint.setStyle(Paint.Style.FILL);
            }
            this.mIndicatorPaint.setColor(color2);
        }
    }

    protected void draw(@NonNull View hostView, @NonNull Canvas canvas, int viewTop, int viewBottom) {
        if (this.mIndicatorRect != null) {
            if (this.mFixedColorAttr != 0 && this.mShouldReGetFixedColor) {
                this.mShouldReGetFixedColor = false;
                this.mFixedColor = QMUISkinHelper.getSkinColor(hostView, this.mFixedColorAttr);
                this.updateColor(this.mFixedColor);
            }
            if (this.mIndicatorTop) {
                this.mIndicatorRect.top = viewTop;
                this.mIndicatorRect.bottom = this.mIndicatorRect.top + this.mIndicatorHeight;
            } else {
                this.mIndicatorRect.bottom = viewBottom;
                this.mIndicatorRect.top = this.mIndicatorRect.bottom - this.mIndicatorHeight;
            }
            if (this.mIndicatorDrawable != null) {
                this.mIndicatorDrawable.setBounds(this.mIndicatorRect);
                this.mIndicatorDrawable.draw(canvas);
            } else {
                canvas.drawRect(this.mIndicatorRect, this.mIndicatorPaint);
            }
        }
    }

    protected void handleSkinChange(@NonNull QMUISkinManager manager, int skinIndex, @NonNull Resources.Theme theme, @Nullable QMUITab selectedTab) {
        this.mShouldReGetFixedColor = true;
        if (selectedTab != null && this.mFixedColorAttr == 0) {
            this.updateColor(selectedTab.selectedColorAttr == 0 ? selectedTab.selectColor : QMUIResHelper.getAttrColor(theme, selectedTab.selectedColorAttr));
        }
    }
}

