/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.section;

import android.graphics.Canvas;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionAdapter;
import java.lang.ref.WeakReference;

public class QMUIStickySectionItemDecoration<VH extends QMUIStickySectionAdapter.ViewHolder>
extends RecyclerView.ItemDecoration {
    private Callback<VH> mCallback;
    private VH mStickyHeaderViewHolder;
    private int mStickyHeaderViewPosition = -1;
    private WeakReference<ViewGroup> mWeakSectionContainer;
    private int mTargetTop = 0;

    public QMUIStickySectionItemDecoration(ViewGroup sectionContainer, @NonNull Callback<VH> callback) {
        this.mCallback = callback;
        this.mWeakSectionContainer = new WeakReference<ViewGroup>(sectionContainer);
        this.mCallback.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                super.onChanged();
                QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition = -1;
                QMUIStickySectionItemDecoration.this.mCallback.invalidate();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                super.onItemRangeInserted(positionStart, itemCount);
                if (positionStart <= QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition) {
                    QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition = -1;
                    QMUIStickySectionItemDecoration.this.mCallback.invalidate();
                }
            }

            public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
                super.onItemRangeMoved(fromPosition, toPosition, itemCount);
                if (fromPosition == QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition || toPosition == QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition) {
                    QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition = -1;
                    QMUIStickySectionItemDecoration.this.mCallback.invalidate();
                }
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                if (QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition >= positionStart && QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition < positionStart + itemCount && QMUIStickySectionItemDecoration.this.mStickyHeaderViewHolder != null && QMUIStickySectionItemDecoration.this.mWeakSectionContainer.get() != null) {
                    QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition = -1;
                    QMUIStickySectionItemDecoration.this.mCallback.invalidate();
                }
            }

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                if (QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition >= positionStart && QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition < positionStart + itemCount) {
                    QMUIStickySectionItemDecoration.this.mStickyHeaderViewPosition = -1;
                    QMUIStickySectionItemDecoration.this.setHeaderVisibility(false);
                }
            }
        });
    }

    private void setHeaderVisibility(boolean visibility) {
        ViewGroup sectionContainer = (ViewGroup)this.mWeakSectionContainer.get();
        if (sectionContainer == null) {
            return;
        }
        sectionContainer.setVisibility(visibility ? 0 : 8);
        this.mCallback.onHeaderVisibilityChanged(visibility);
    }

    public int getStickyHeaderViewPosition() {
        return this.mStickyHeaderViewPosition;
    }

    public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.Adapter adapter;
        ViewGroup sectionContainer = (ViewGroup)this.mWeakSectionContainer.get();
        if (sectionContainer == null) {
            return;
        }
        if (parent.getChildCount() == 0) {
            this.setHeaderVisibility(false);
        }
        if ((adapter = parent.getAdapter()) == null) {
            this.setHeaderVisibility(false);
            return;
        }
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            this.setHeaderVisibility(false);
            return;
        }
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
        int firstVisibleItemPosition = linearLayoutManager.findFirstVisibleItemPosition();
        if (firstVisibleItemPosition == -1) {
            this.setHeaderVisibility(false);
            return;
        }
        int headerPos = this.mCallback.getRelativeStickyItemPosition(firstVisibleItemPosition);
        if (headerPos == -1) {
            this.setHeaderVisibility(false);
            return;
        }
        int itemType = this.mCallback.getItemViewType(headerPos);
        if (itemType == -1) {
            this.setHeaderVisibility(false);
            return;
        }
        if (this.mStickyHeaderViewHolder == null || this.mStickyHeaderViewHolder.getItemViewType() != itemType) {
            this.mStickyHeaderViewHolder = this.createStickyViewHolder(parent, headerPos, itemType);
        }
        if (this.mStickyHeaderViewPosition != headerPos) {
            this.mStickyHeaderViewPosition = headerPos;
            this.bindStickyViewHolder(sectionContainer, this.mStickyHeaderViewHolder, headerPos);
        }
        this.setHeaderVisibility(true);
        int contactPoint = sectionContainer.getHeight() - 1;
        View childInContact = parent.findChildViewUnder((float)(parent.getWidth() / 2), (float)contactPoint);
        if (childInContact == null) {
            this.mTargetTop = parent.getTop();
            ViewCompat.offsetTopAndBottom((View)sectionContainer, (int)(this.mTargetTop - sectionContainer.getTop()));
            return;
        }
        if (this.mCallback.isHeaderItem(parent.getChildAdapterPosition(childInContact))) {
            this.mTargetTop = childInContact.getTop() + parent.getTop() - sectionContainer.getHeight();
            ViewCompat.offsetTopAndBottom((View)sectionContainer, (int)(this.mTargetTop - sectionContainer.getTop()));
            return;
        }
        this.mTargetTop = parent.getTop();
        ViewCompat.offsetTopAndBottom((View)sectionContainer, (int)(this.mTargetTop - sectionContainer.getTop()));
    }

    public int getTargetTop() {
        return this.mTargetTop;
    }

    private VH createStickyViewHolder(RecyclerView recyclerView, int position, int itemType) {
        VH vh = this.mCallback.createViewHolder((ViewGroup)recyclerView, itemType);
        ((QMUIStickySectionAdapter.ViewHolder)((Object)vh)).isForStickyHeader = true;
        return vh;
    }

    private void bindStickyViewHolder(ViewGroup sectionContainer, VH viewHolder, int position) {
        this.mCallback.bindViewHolder(viewHolder, position);
        sectionContainer.removeAllViews();
        sectionContainer.addView(((QMUIStickySectionAdapter.ViewHolder)((Object)viewHolder)).itemView);
    }

    public static interface Callback<ViewHolder extends QMUIStickySectionAdapter.ViewHolder> {
        public int getRelativeStickyItemPosition(int var1);

        public boolean isHeaderItem(int var1);

        public ViewHolder createViewHolder(ViewGroup var1, int var2);

        public void bindViewHolder(ViewHolder var1, int var2);

        public int getItemViewType(int var1);

        public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver var1);

        public void onHeaderVisibilityChanged(boolean var1);

        public void invalidate();
    }
}

