/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.section;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import com.qmuiteam.qmui.widget.section.QMUISection;
import java.util.ArrayList;
import java.util.List;

public class QMUISectionDiffCallback<H extends QMUISection.Model<H>, T extends QMUISection.Model<T>>
extends DiffUtil.Callback {
    private ArrayList<QMUISection<H, T>> mOldList = new ArrayList();
    private ArrayList<QMUISection<H, T>> mNewList = new ArrayList();
    private ArrayList<Integer> mOldSectionIndex = new ArrayList();
    private ArrayList<Integer> mOldItemIndex = new ArrayList();
    private ArrayList<Integer> mNewSectionIndex = new ArrayList();
    private ArrayList<Integer> mNewItemIndex = new ArrayList();
    private boolean mRemoveSectionTitleIfOnlyOnceSection;

    public QMUISectionDiffCallback(@Nullable List<QMUISection<H, T>> oldList, @Nullable List<QMUISection<H, T>> newList) {
        if (oldList != null) {
            this.mOldList.addAll(oldList);
        }
        if (newList != null) {
            this.mNewList.addAll(newList);
        }
    }

    void generateIndex(boolean removeSectionTitleIfOnlyOnceSection) {
        this.mRemoveSectionTitleIfOnlyOnceSection = removeSectionTitleIfOnlyOnceSection;
        this.generateIndex(this.mOldList, this.mOldSectionIndex, this.mOldItemIndex, removeSectionTitleIfOnlyOnceSection);
        this.generateIndex(this.mNewList, this.mNewSectionIndex, this.mNewItemIndex, removeSectionTitleIfOnlyOnceSection);
    }

    public void cloneNewIndexTo(@NonNull ArrayList<Integer> sectionIndex, @NonNull ArrayList<Integer> itemIndex) {
        int i;
        sectionIndex.clear();
        itemIndex.clear();
        sectionIndex.ensureCapacity(this.mNewSectionIndex.size());
        itemIndex.ensureCapacity(this.mNewItemIndex.size());
        for (i = 0; i < this.mNewSectionIndex.size(); ++i) {
            sectionIndex.add(i, this.mNewSectionIndex.get(i));
        }
        for (i = 0; i < this.mNewItemIndex.size(); ++i) {
            itemIndex.add(i, this.mNewItemIndex.get(i));
        }
    }

    private void generateIndex(List<QMUISection<H, T>> list, ArrayList<Integer> sectionIndex, ArrayList<Integer> itemIndex, boolean removeSectionTitleIfOnlyOnceSection) {
        sectionIndex.clear();
        itemIndex.clear();
        IndexGenerationInfo generationInfo = new IndexGenerationInfo(sectionIndex, itemIndex);
        if (list.isEmpty() || !list.get(0).isLocked()) {
            this.onGenerateCustomIndexBeforeSectionList(generationInfo, list);
        }
        for (int i = 0; i < list.size(); ++i) {
            QMUISection<H, T> section = list.get(i);
            if (section.isLocked()) continue;
            if (!removeSectionTitleIfOnlyOnceSection || list.size() > 1) {
                generationInfo.appendIndex(i, -2);
            }
            if (section.isFold()) continue;
            this.onGenerateCustomIndexBeforeItemList(generationInfo, section, i);
            if (section.isExistBeforeDataToLoad()) {
                generationInfo.appendIndex(i, -3);
            }
            for (int j = 0; j < section.getItemCount(); ++j) {
                generationInfo.appendIndex(i, j);
            }
            if (section.isExistAfterDataToLoad()) {
                generationInfo.appendIndex(i, -4);
            }
            this.onGenerateCustomIndexAfterItemList(generationInfo, section, i);
        }
        if (list.isEmpty()) {
            this.onGenerateCustomIndexAfterSectionList(generationInfo, list);
        } else {
            QMUISection<H, T> lastSection = list.get(list.size() - 1);
            if (!(lastSection.isLocked() || !lastSection.isFold() && lastSection.isExistAfterDataToLoad())) {
                this.onGenerateCustomIndexAfterSectionList(generationInfo, list);
            }
        }
    }

    protected void onGenerateCustomIndexBeforeSectionList(IndexGenerationInfo generationInfo, List<QMUISection<H, T>> list) {
    }

    protected void onGenerateCustomIndexAfterSectionList(IndexGenerationInfo generationInfo, List<QMUISection<H, T>> list) {
    }

    protected void onGenerateCustomIndexBeforeItemList(IndexGenerationInfo generationInfo, QMUISection<H, T> section, int sectionIndex) {
    }

    protected void onGenerateCustomIndexAfterItemList(IndexGenerationInfo generationInfo, QMUISection<H, T> section, int sectionIndex) {
    }

    protected boolean areCustomContentsTheSame(@Nullable QMUISection<H, T> oldSection, int oldItemIndex, @Nullable QMUISection<H, T> newSection, int newItemIndex) {
        return false;
    }

    public int getOldListSize() {
        return this.mOldSectionIndex.size();
    }

    public int getNewListSize() {
        return this.mNewSectionIndex.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        int oldSectionIndex = this.mOldSectionIndex.get(oldItemPosition);
        int oldItemIndex = this.mOldItemIndex.get(oldItemPosition);
        int newSectionIndex = this.mNewSectionIndex.get(newItemPosition);
        int newItemIndex = this.mNewItemIndex.get(newItemPosition);
        if (oldSectionIndex < 0 || newSectionIndex < 0) {
            return oldSectionIndex == newSectionIndex && oldItemIndex == newItemIndex;
        }
        QMUISection<H, T> oldModel = this.mOldList.get(oldSectionIndex);
        QMUISection<H, T> newModel = this.mNewList.get(newSectionIndex);
        if (!oldModel.getHeader().isSameItem(newModel.getHeader())) {
            return false;
        }
        if (oldItemIndex < 0 && oldItemIndex == newItemIndex) {
            return true;
        }
        if (oldItemIndex < 0 || newItemIndex < 0) {
            return false;
        }
        T oldItem = oldModel.getItemAt(oldItemIndex);
        T newItem = newModel.getItemAt(newItemIndex);
        return oldItem == null && newItem == null || oldItem != null && newItem != null && oldItem.isSameItem(newItem);
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        int oldSectionIndex = this.mOldSectionIndex.get(oldItemPosition);
        int oldItemIndex = this.mOldItemIndex.get(oldItemPosition);
        int newSectionIndex = this.mNewSectionIndex.get(newItemPosition);
        int newItemIndex = this.mNewItemIndex.get(newItemPosition);
        if (newSectionIndex < 0) {
            return this.areCustomContentsTheSame(null, oldItemIndex, null, newItemIndex);
        }
        if (this.mRemoveSectionTitleIfOnlyOnceSection) {
            if (this.mOldList.size() == 1 && this.mNewList.size() != 1) {
                return false;
            }
            if (this.mOldList.size() != 1 && this.mNewList.size() == 1) {
                return false;
            }
        }
        QMUISection<H, T> oldModel = this.mOldList.get(oldSectionIndex);
        QMUISection<H, T> newModel = this.mNewList.get(newSectionIndex);
        if (oldItemIndex == -2) {
            return oldModel.isFold() == newModel.isFold() && oldModel.getHeader().isSameContent(newModel.getHeader());
        }
        if (oldItemIndex == -3 || oldItemIndex == -4) {
            return false;
        }
        if (QMUISection.isCustomItemIndex(oldItemIndex)) {
            return this.areCustomContentsTheSame(oldModel, oldItemIndex, newModel, newItemIndex);
        }
        T oldItem = oldModel.getItemAt(oldItemIndex);
        T newItem = newModel.getItemAt(newItemIndex);
        return oldItem == null && newItem == null || oldItem != null && newItem != null && oldItem.isSameContent(newItem);
    }

    public static class IndexGenerationInfo {
        private ArrayList<Integer> sectionIndexArray;
        private ArrayList<Integer> itemIndexArray;

        private IndexGenerationInfo(ArrayList<Integer> sectionIndex, ArrayList<Integer> itemIndex) {
            this.sectionIndexArray = sectionIndex;
            this.itemIndexArray = itemIndex;
        }

        public final void appendCustomIndex(int sectionIndex, int itemIndex) {
            int offset = -1000 + itemIndex;
            if (!QMUISection.isCustomItemIndex(offset)) {
                throw new IllegalArgumentException("Index conflicts with index used internally, please use negative number for custom item");
            }
            this.appendIndex(sectionIndex, offset);
        }

        private void appendIndex(int sectionIndex, int itemIndex) {
            if (sectionIndex < 0) {
                throw new IllegalArgumentException("use appendWholeListCustomIndex for whole list");
            }
            this.sectionIndexArray.add(sectionIndex);
            this.itemIndexArray.add(itemIndex);
        }

        public final void appendWholeListCustomIndex(int itemIndex) {
            int offset = -1000 + itemIndex;
            if (!QMUISection.isCustomItemIndex(offset)) {
                throw new IllegalArgumentException("Index conflicts with index used internally, please use negative number for custom item");
            }
            this.appendWholeListIndex(offset);
        }

        private void appendWholeListIndex(int itemIndex) {
            this.sectionIndexArray.add(-1);
            this.itemIndexArray.add(itemIndex);
        }
    }
}

