/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.pullLayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.NestedScrollingParent3;
import androidx.core.view.NestedScrollingParentHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.QMUIInterpolatorStaticHolder;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIViewOffsetHelper;
import com.qmuiteam.qmui.widget.pullLayout.QMUIAlwaysFollowOffsetCalculator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class QMUIPullLayout
extends FrameLayout
implements NestedScrollingParent3 {
    public static final float DEFAULT_PULL_RATE = 0.45f;
    public static final float DEFAULT_FLING_FRACTION = 0.002f;
    public static final float DEFAULT_SCROLL_SPEED_PER_PIXEL = 1.5f;
    public static final int DEFAULT_MIN_SCROLL_DURATION = 300;
    public static final int PULL_EDGE_LEFT = 1;
    public static final int PULL_EDGE_TOP = 2;
    public static final int PULL_EDGE_RIGHT = 4;
    public static final int PULL_EDGE_BOTTOM = 8;
    public static final int PUL_EDGE_ALL = 15;
    private static final int STATE_IDLE = 0;
    private static final int STATE_PULLING = 1;
    private static final int STATE_SETTLING_TO_TRIGGER_OFFSET = 2;
    private static final int STATE_TRIGGERING = 3;
    private static final int STATE_SETTLING_TO_INIT_OFFSET = 4;
    private static final int STATE_SETTLING_DELIVER = 5;
    private static final int STATE_SETTLING_FLING = 6;
    private int mEnabledEdges;
    private View mTargetView;
    private QMUIViewOffsetHelper mTargetOffsetHelper;
    private PullAction mLeftPullAction = null;
    private PullAction mTopPullAction = null;
    private PullAction mRightPullAction = null;
    private PullAction mBottomPullAction = null;
    private ActionListener mActionListener;
    private final int[] mNestedScrollingV2ConsumedCompat = new int[2];
    private StopTargetViewFlingImpl mStopTargetViewFlingImpl = DefaultStopTargetViewFlingImpl.getInstance();
    private Runnable mStopTargetFlingRunnable = null;
    private OverScroller mScroller;
    private float mNestedPreFlingVelocityScaleDown = 10.0f;
    private int mMinScrollDuration = 300;
    private int mState = 0;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper;

    public QMUIPullLayout(@NonNull Context context) {
        this(context, null);
    }

    public QMUIPullLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.QMUIPullLayoutStyle);
    }

    public QMUIPullLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUIPullLayout, defStyleAttr, 0);
        this.mEnabledEdges = array.getInt(R.styleable.QMUIPullLayout_qmui_pull_enable_edge, 15);
        array.recycle();
        this.mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.mScroller = new OverScroller(context, QMUIInterpolatorStaticHolder.QUNITIC_INTERPOLATOR);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        boolean isTargetSet = false;
        int edgesSet = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (lp.isTarget) {
                if (isTargetSet) {
                    throw new RuntimeException("More than one view in xml are marked by qmui_is_target = true.");
                }
                isTargetSet = true;
                this.setTargetView(view);
                continue;
            }
            if ((edgesSet & lp.edge) != 0) {
                String text = "";
                if (lp.edge == 1) {
                    text = "left";
                } else if (lp.edge == 2) {
                    text = "top";
                } else if (lp.edge == 4) {
                    text = "right";
                } else if (lp.edge == 8) {
                    text = "bottom";
                }
                throw new RuntimeException("More than one view in xml marked by qmui_layout_edge = " + text);
            }
            edgesSet |= lp.edge;
            this.setActionView(view, lp);
        }
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            if (this.mScroller.isFinished()) {
                if (this.mState == 4) {
                    this.mState = 0;
                    return;
                }
                if (this.mState == 3) {
                    return;
                }
                if (this.mState == 6) {
                    this.checkScrollToTargetOffsetOrInitOffset(false);
                    return;
                }
                if (this.mState == 2) {
                    this.mState = 3;
                    if (this.mLeftPullAction != null && this.isEdgeEnabled(1) && this.mScroller.getFinalX() == this.mLeftPullAction.getTargetTriggerOffset()) {
                        this.onActionTriggered(this.mLeftPullAction);
                    }
                    if (this.mRightPullAction != null && this.isEdgeEnabled(4) && this.mScroller.getFinalX() == -this.mRightPullAction.getTargetTriggerOffset()) {
                        this.onActionTriggered(this.mRightPullAction);
                    }
                    if (this.mTopPullAction != null && this.isEdgeEnabled(2) && this.mScroller.getFinalY() == this.mTopPullAction.getTargetTriggerOffset()) {
                        this.onActionTriggered(this.mTopPullAction);
                    }
                    if (this.mBottomPullAction != null && this.isEdgeEnabled(8) && this.mScroller.getFinalY() == -this.mBottomPullAction.getTargetTriggerOffset()) {
                        this.onActionTriggered(this.mBottomPullAction);
                    }
                    this.setHorOffsetToTargetOffsetHelper(this.mScroller.getCurrX());
                    this.setVerOffsetToTargetOffsetHelper(this.mScroller.getCurrY());
                }
            } else {
                this.setHorOffsetToTargetOffsetHelper(this.mScroller.getCurrX());
                this.setVerOffsetToTargetOffsetHelper(this.mScroller.getCurrY());
                this.postInvalidateOnAnimation();
            }
        }
    }

    public void setStopTargetViewFlingImpl(@NonNull StopTargetViewFlingImpl stopTargetViewFlingImpl) {
        this.mStopTargetViewFlingImpl = stopTargetViewFlingImpl;
    }

    public void setMinScrollDuration(int minScrollDuration) {
        this.mMinScrollDuration = minScrollDuration;
    }

    public void setTargetView(@NonNull View view) {
        if (view.getParent() != this) {
            throw new RuntimeException("Target already exists other parent view.");
        }
        if (view.getParent() == null) {
            LayoutParams lp = new LayoutParams(-1, -1);
            this.addView(view, (ViewGroup.LayoutParams)lp);
        }
        this.innerSetTargetView(view);
    }

    private void innerSetTargetView(@NonNull View view) {
        this.mTargetView = view;
        this.mTargetOffsetHelper = new QMUIViewOffsetHelper(view);
    }

    public void setActionView(View view, LayoutParams lp) {
        PullActionBuilder builder = new PullActionBuilder(view, lp.edge).canOverPull(lp.canOverPull).pullRate(lp.pullRate).needReceiveFlingFromTargetView(lp.needReceiveFlingFromTarget).receivedFlingFraction(lp.receivedFlingFraction).scrollSpeedPerPixel(lp.scrollSpeedPerPixel).targetTriggerOffset(lp.targetTriggerOffset).triggerUntilScrollToTriggerOffset(lp.triggerUntilScrollToTriggerOffset).scrollToTriggerOffsetAfterTouchUp(lp.scrollToTriggerOffsetAfterTouchUp).actionInitOffset(lp.actionInitOffset);
        view.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.setActionView(builder);
    }

    public void setActionView(@NonNull PullActionBuilder builder) {
        if (builder.mActionView.getParent() != this) {
            throw new RuntimeException("Action view already exists other parent view.");
        }
        if (builder.mActionView.getParent() == null) {
            ViewGroup.LayoutParams lp = builder.mActionView.getLayoutParams();
            if (lp == null) {
                lp = new ViewGroup.LayoutParams(-2, -2);
            }
            this.addView(builder.mActionView, lp);
        }
        if (builder.mPullEdge == 1) {
            this.mLeftPullAction = builder.build();
        } else if (builder.mPullEdge == 2) {
            this.mTopPullAction = builder.build();
        } else if (builder.mPullEdge == 4) {
            this.mRightPullAction = builder.build();
        } else if (builder.mPullEdge == 8) {
            this.mBottomPullAction = builder.build();
        }
    }

    public void setActionListener(ActionListener actionListener) {
        this.mActionListener = actionListener;
    }

    public void setEnabledEdges(int enabledEdges) {
        this.mEnabledEdges = enabledEdges;
    }

    public boolean isEdgeEnabled(int edge) {
        return (this.mEnabledEdges & edge) == edge && this.getPullAction(edge) != null;
    }

    @Nullable
    private PullAction getPullAction(int edge) {
        if (edge == 1) {
            return this.mLeftPullAction;
        }
        if (edge == 2) {
            return this.mTopPullAction;
        }
        if (edge == 4) {
            return this.mRightPullAction;
        }
        if (edge == 8) {
            return this.mBottomPullAction;
        }
        return null;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int vc;
        int vh;
        int vw;
        View view;
        int w = r - l;
        int h = b - t;
        if (this.mTargetView != null) {
            this.mTargetView.layout(0, 0, w, h);
            this.mTargetOffsetHelper.onViewLayout();
        }
        if (this.mLeftPullAction != null) {
            view = this.mLeftPullAction.mActionView;
            vw = view.getMeasuredWidth();
            vh = view.getMeasuredHeight();
            vc = (h - vh) / 2;
            view.layout(-vw, vc, 0, vc + vh);
            this.mLeftPullAction.mViewOffsetHelper.onViewLayout();
        }
        if (this.mTopPullAction != null) {
            view = this.mTopPullAction.mActionView;
            vw = view.getMeasuredWidth();
            vh = view.getMeasuredHeight();
            vc = (w - vw) / 2;
            view.layout(vc, -vh, vc + vw, 0);
            this.mTopPullAction.mViewOffsetHelper.onViewLayout();
        }
        if (this.mRightPullAction != null) {
            view = this.mRightPullAction.mActionView;
            vw = view.getMeasuredWidth();
            vh = view.getMeasuredHeight();
            vc = (h - vh) / 2;
            view.layout(w, vc, w + vw, vc + vh);
            this.mRightPullAction.mViewOffsetHelper.onViewLayout();
        }
        if (this.mBottomPullAction != null) {
            view = this.mBottomPullAction.mActionView;
            vw = view.getMeasuredWidth();
            vh = view.getMeasuredHeight();
            vc = (w - vw) / 2;
            view.layout(vc, h, vc + vw, h + vh);
            this.mBottomPullAction.mViewOffsetHelper.onViewLayout();
        }
    }

    public void setNestedPreFlingVelocityScaleDown(float nestedPreFlingVelocityScaleDown) {
        this.mNestedPreFlingVelocityScaleDown = nestedPreFlingVelocityScaleDown;
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int axes, int type) {
        return this.mTargetView == target && axes == 1 && (this.isEdgeEnabled(1) || this.isEdgeEnabled(4)) || axes == 2 && (this.isEdgeEnabled(2) || this.isEdgeEnabled(8));
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.onStartNestedScroll(child, target, nestedScrollAxes, 0);
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes, int type) {
        if (type == 0) {
            this.removeStopTargetFlingRunnable();
            this.mScroller.abortAnimation();
            this.mState = 1;
        }
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, axes);
    }

    public void onNestedScrollAccepted(View child, View target, int axes) {
        this.onNestedScrollAccepted(child, target, axes, 0);
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        int originDx = dx;
        int originDy = dy;
        dy = this.checkEdgeTopScrollDown(dy, consumed, type);
        dy = this.checkEdgeBottomScrollDown(dy, consumed, type);
        dy = this.checkEdgeTopScrollUp(dy, consumed, type);
        dy = this.checkEdgeBottomScrollUp(dy, consumed, type);
        dx = this.checkEdgeLeftScrollRight(dx, consumed, type);
        dx = this.checkEdgeRightScrollRight(dx, consumed, type);
        dx = this.checkEdgeLeftScrollLeft(dx, consumed, type);
        if (originDx == (dx = this.checkEdgeRightScrollLeft(dx, consumed, type)) && originDy == dy && this.mState == 5) {
            this.checkStopTargetFling(target, dx, dy, type);
        }
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        this.onNestedPreScroll(target, dx, dy, consumed, 0);
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NonNull int[] consumed) {
        int originDxUnconsumed = dxUnconsumed;
        int originDyUnconsumed = dyUnconsumed;
        dyUnconsumed = this.checkEdgeTopScrollDown(dyUnconsumed, consumed, type);
        dyUnconsumed = this.checkEdgeBottomScrollDown(dyUnconsumed, consumed, type);
        dyUnconsumed = this.checkEdgeTopScrollUp(dyUnconsumed, consumed, type);
        dyUnconsumed = this.checkEdgeBottomScrollUp(dyUnconsumed, consumed, type);
        dxUnconsumed = this.checkEdgeLeftScrollRight(dxUnconsumed, consumed, type);
        dxUnconsumed = this.checkEdgeRightScrollRight(dxUnconsumed, consumed, type);
        dxUnconsumed = this.checkEdgeLeftScrollLeft(dxUnconsumed, consumed, type);
        dxUnconsumed = this.checkEdgeRightScrollLeft(dxUnconsumed, consumed, type);
        if (dyUnconsumed == originDyUnconsumed && dxUnconsumed == originDxUnconsumed && this.mState == 5) {
            this.checkStopTargetFling(target, dxUnconsumed, dyUnconsumed, type);
        }
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        this.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type, this.mNestedScrollingV2ConsumedCompat);
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, 0);
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        int hOffset = this.mTargetOffsetHelper.getLeftAndRightOffset();
        int vOffset = this.mTargetOffsetHelper.getTopAndBottomOffset();
        if (this.mLeftPullAction != null && this.isEdgeEnabled(1)) {
            if (velocityX < 0.0f && !this.mTargetView.canScrollHorizontally(-1)) {
                this.mState = 6;
                int maxX = this.mLeftPullAction.isCanOverPull() ? Integer.MAX_VALUE : this.mLeftPullAction.getTargetTriggerOffset();
                this.mScroller.fling(hOffset, vOffset, (int)(-(velocityX /= this.mNestedPreFlingVelocityScaleDown)), 0, 0, maxX, vOffset, vOffset);
                this.postInvalidateOnAnimation();
                return true;
            }
            if (velocityX > 0.0f && hOffset > 0) {
                this.mState = 4;
                this.mScroller.startScroll(hOffset, vOffset, -hOffset, 0, this.scrollDuration(this.mLeftPullAction, hOffset));
                this.postInvalidateOnAnimation();
                return true;
            }
        }
        if (this.mRightPullAction != null && this.isEdgeEnabled(4)) {
            if (velocityX > 0.0f && !this.mTargetView.canScrollHorizontally(1)) {
                this.mState = 6;
                int minX = this.mRightPullAction.isCanOverPull() ? Integer.MIN_VALUE : -this.mRightPullAction.getTargetTriggerOffset();
                this.mScroller.fling(hOffset, vOffset, (int)(-(velocityX /= this.mNestedPreFlingVelocityScaleDown)), 0, minX, 0, vOffset, vOffset);
                this.postInvalidateOnAnimation();
                return true;
            }
            if (velocityX < 0.0f && hOffset < 0) {
                this.mState = 4;
                this.mScroller.startScroll(hOffset, vOffset, -hOffset, 0, this.scrollDuration(this.mRightPullAction, hOffset));
                this.postInvalidateOnAnimation();
                return true;
            }
        }
        if (this.mTopPullAction != null && this.isEdgeEnabled(2)) {
            if (velocityY < 0.0f && !this.mTargetView.canScrollVertically(-1)) {
                this.mState = 6;
                int maxY = this.mTopPullAction.isCanOverPull() ? Integer.MAX_VALUE : this.mTopPullAction.getTargetTriggerOffset();
                this.mScroller.fling(hOffset, vOffset, 0, (int)(-(velocityY /= this.mNestedPreFlingVelocityScaleDown)), hOffset, hOffset, 0, maxY);
                this.postInvalidateOnAnimation();
                return true;
            }
            if (velocityY > 0.0f && vOffset > 0) {
                this.mState = 4;
                this.mScroller.startScroll(hOffset, vOffset, 0, -vOffset, this.scrollDuration(this.mTopPullAction, vOffset));
                this.postInvalidateOnAnimation();
                return true;
            }
        }
        if (this.mBottomPullAction != null && this.isEdgeEnabled(8)) {
            if (velocityY > 0.0f && !this.mTargetView.canScrollVertically(1)) {
                this.mState = 6;
                int minY = this.mBottomPullAction.isCanOverPull() ? Integer.MIN_VALUE : -this.mBottomPullAction.getTargetTriggerOffset();
                this.mScroller.fling(hOffset, vOffset, 0, (int)(-(velocityY /= this.mNestedPreFlingVelocityScaleDown)), hOffset, hOffset, minY, 0);
                this.postInvalidateOnAnimation();
                return true;
            }
            if (velocityY < 0.0f && vOffset < 0) {
                this.mState = 4;
                this.mScroller.startScroll(hOffset, vOffset, 0, -vOffset, this.scrollDuration(this.mBottomPullAction, vOffset));
                this.postInvalidateOnAnimation();
                return true;
            }
        }
        this.mState = 5;
        return super.onNestedPreFling(target, velocityX, velocityY);
    }

    public void onStopNestedScroll(@NonNull View target, int type) {
        if (this.mState == 1) {
            this.checkScrollToTargetOffsetOrInitOffset(false);
        } else if (this.mState == 5 && type != 0) {
            this.removeStopTargetFlingRunnable();
            this.checkScrollToTargetOffsetOrInitOffset(false);
        }
    }

    private int scrollDuration(PullAction pullAction, int delta) {
        return Math.max(this.mMinScrollDuration, Math.abs((int)(pullAction.mScrollSpeedPerPixel * (float)delta)));
    }

    private void onActionTriggered(PullAction pullAction) {
        if (pullAction.mIsActionRunning) {
            return;
        }
        pullAction.mIsActionRunning = true;
        if (this.mActionListener != null) {
            this.mActionListener.onActionTriggered(pullAction);
        }
        if (pullAction.mActionView instanceof ActionPullWatcherView) {
            ((ActionPullWatcherView)pullAction.mActionView).onActionTriggered();
        }
    }

    public void finishActionRun(@NonNull PullAction pullAction) {
        this.finishActionRun(pullAction, true);
    }

    public void finishActionRun(@NonNull PullAction pullAction, boolean animate) {
        if (pullAction != this.getPullAction(pullAction.mPullEdge)) {
            return;
        }
        pullAction.mIsActionRunning = false;
        if (pullAction.mActionView instanceof ActionPullWatcherView) {
            ((ActionPullWatcherView)pullAction.mActionView).onActionFinished();
        }
        if (this.mState == 1) {
            return;
        }
        if (!animate) {
            this.mState = 0;
            this.setVerOffsetToTargetOffsetHelper(0);
            this.setHorOffsetToTargetOffsetHelper(0);
            return;
        }
        this.mState = 4;
        int pullEdge = pullAction.getPullEdge();
        int vOffset = this.mTargetOffsetHelper.getTopAndBottomOffset();
        int hOffset = this.mTargetOffsetHelper.getLeftAndRightOffset();
        if (pullEdge == 2 && this.mTopPullAction != null && vOffset > 0) {
            this.mScroller.startScroll(hOffset, vOffset, 0, -vOffset, this.scrollDuration(this.mTopPullAction, vOffset));
            this.postInvalidateOnAnimation();
        } else if (pullEdge == 8 && this.mBottomPullAction != null && vOffset < 0) {
            this.mScroller.startScroll(hOffset, vOffset, 0, -vOffset, this.scrollDuration(this.mBottomPullAction, vOffset));
            this.postInvalidateOnAnimation();
        } else if (pullEdge == 1 && this.mLeftPullAction != null && hOffset > 0) {
            this.mScroller.startScroll(hOffset, vOffset, -hOffset, 0, this.scrollDuration(this.mLeftPullAction, hOffset));
            this.postInvalidateOnAnimation();
        } else if (pullEdge == 4 && this.mRightPullAction != null && hOffset < 0) {
            this.mScroller.startScroll(hOffset, vOffset, -hOffset, 0, this.scrollDuration(this.mRightPullAction, hOffset));
            this.postInvalidateOnAnimation();
        }
    }

    private void checkScrollToTargetOffsetOrInitOffset(boolean forceInit) {
        if (this.mTargetView == null) {
            return;
        }
        this.mScroller.abortAnimation();
        int hOffset = this.mTargetOffsetHelper.getLeftAndRightOffset();
        int vOffset = this.mTargetOffsetHelper.getTopAndBottomOffset();
        int hTarget = 0;
        int vTarget = 0;
        if (this.mLeftPullAction != null && this.isEdgeEnabled(1) && hOffset > 0) {
            this.mState = 4;
            if (!forceInit) {
                int targetOffset = this.mLeftPullAction.getTargetTriggerOffset();
                if (hOffset == targetOffset) {
                    this.onActionTriggered(this.mLeftPullAction);
                    return;
                }
                if (hOffset > targetOffset) {
                    if (!this.mLeftPullAction.mScrollToTriggerOffsetAfterTouchUp) {
                        this.mState = 3;
                        this.onActionTriggered(this.mLeftPullAction);
                        return;
                    }
                    if (!this.mLeftPullAction.mTriggerUntilScrollToTriggerOffset) {
                        this.mState = 3;
                        this.onActionTriggered(this.mLeftPullAction);
                    } else {
                        this.mState = 2;
                    }
                    hTarget = targetOffset;
                }
            }
            int dx = hTarget - hOffset;
            this.mScroller.startScroll(hOffset, vOffset, dx, 0, this.scrollDuration(this.mLeftPullAction, dx));
            this.postInvalidateOnAnimation();
            return;
        }
        if (this.mRightPullAction != null && this.isEdgeEnabled(4) && hOffset < 0) {
            this.mState = 4;
            if (!forceInit) {
                int targetOffset = this.mRightPullAction.getTargetTriggerOffset();
                if (hOffset == -targetOffset) {
                    this.mState = 3;
                    this.onActionTriggered(this.mRightPullAction);
                    return;
                }
                if (hOffset < -targetOffset) {
                    if (!this.mRightPullAction.mScrollToTriggerOffsetAfterTouchUp) {
                        this.mState = 3;
                        this.onActionTriggered(this.mRightPullAction);
                        return;
                    }
                    if (!this.mRightPullAction.mTriggerUntilScrollToTriggerOffset) {
                        this.mState = 3;
                        this.onActionTriggered(this.mRightPullAction);
                    } else {
                        this.mState = 2;
                    }
                    hTarget = -targetOffset;
                }
            }
            int dx = hTarget - hOffset;
            this.mScroller.startScroll(hOffset, vOffset, dx, 0, this.scrollDuration(this.mRightPullAction, dx));
            this.postInvalidateOnAnimation();
            return;
        }
        if (this.mTopPullAction != null && this.isEdgeEnabled(2) && vOffset > 0) {
            this.mState = 4;
            if (!forceInit) {
                int targetOffset = this.mTopPullAction.getTargetTriggerOffset();
                if (vOffset == targetOffset) {
                    this.mState = 3;
                    this.onActionTriggered(this.mTopPullAction);
                    return;
                }
                if (vOffset > targetOffset) {
                    if (!this.mTopPullAction.mScrollToTriggerOffsetAfterTouchUp) {
                        this.mState = 3;
                        this.onActionTriggered(this.mTopPullAction);
                        return;
                    }
                    if (!this.mTopPullAction.mTriggerUntilScrollToTriggerOffset) {
                        this.mState = 3;
                        this.onActionTriggered(this.mTopPullAction);
                    } else {
                        this.mState = 2;
                    }
                    vTarget = targetOffset;
                }
            }
            int dy = vTarget - vOffset;
            this.mScroller.startScroll(hOffset, vOffset, hOffset, dy, this.scrollDuration(this.mTopPullAction, dy));
            this.postInvalidateOnAnimation();
            return;
        }
        if (this.mBottomPullAction != null && this.isEdgeEnabled(8) && vOffset < 0) {
            this.mState = 4;
            if (!forceInit) {
                int targetOffset = this.mBottomPullAction.getTargetTriggerOffset();
                if (vOffset == -targetOffset) {
                    this.onActionTriggered(this.mBottomPullAction);
                    return;
                }
                if (vOffset < -targetOffset) {
                    if (!this.mBottomPullAction.mScrollToTriggerOffsetAfterTouchUp) {
                        this.mState = 3;
                        this.onActionTriggered(this.mBottomPullAction);
                        return;
                    }
                    if (!this.mBottomPullAction.mTriggerUntilScrollToTriggerOffset) {
                        this.mState = 3;
                        this.onActionTriggered(this.mBottomPullAction);
                    } else {
                        this.mState = 2;
                    }
                    vTarget = -targetOffset;
                }
            }
            int dy = vTarget - vOffset;
            this.mScroller.startScroll(hOffset, vOffset, hOffset, dy, this.scrollDuration(this.mBottomPullAction, dy));
            this.postInvalidateOnAnimation();
            return;
        }
        this.mState = 0;
    }

    private void removeStopTargetFlingRunnable() {
        if (this.mStopTargetFlingRunnable != null) {
            this.removeCallbacks(this.mStopTargetFlingRunnable);
            this.mStopTargetFlingRunnable = null;
        }
    }

    private void checkStopTargetFling(final View targetView, int dx, int dy, int type) {
        if (this.mStopTargetFlingRunnable != null || type == 0) {
            return;
        }
        if (dy < 0 && !this.mTargetView.canScrollVertically(-1) || dy > 0 && !this.mTargetView.canScrollVertically(1) || dx < 0 && !this.mTargetView.canScrollHorizontally(-1) || dx > 0 && !this.mTargetView.canScrollHorizontally(1)) {
            this.mStopTargetFlingRunnable = new Runnable(){

                @Override
                public void run() {
                    QMUIPullLayout.this.mStopTargetViewFlingImpl.stopFling(targetView);
                    QMUIPullLayout.this.mStopTargetFlingRunnable = null;
                    QMUIPullLayout.this.checkScrollToTargetOffsetOrInitOffset(false);
                }
            };
            this.post(this.mStopTargetFlingRunnable);
        }
    }

    private void setHorOffsetToTargetOffsetHelper(int hOffset) {
        this.mTargetOffsetHelper.setLeftAndRightOffset(hOffset);
        this.onTargetViewLeftAndRightOffsetChanged(hOffset);
        if (this.mLeftPullAction != null) {
            this.mLeftPullAction.onTargetMoved(hOffset);
            if (this.mLeftPullAction.mActionView instanceof ActionPullWatcherView) {
                ((ActionPullWatcherView)this.mLeftPullAction.mActionView).onPull(this.mLeftPullAction, hOffset);
            }
        }
        if (this.mRightPullAction != null) {
            this.mRightPullAction.onTargetMoved(-hOffset);
            if (this.mRightPullAction.mActionView instanceof ActionPullWatcherView) {
                ((ActionPullWatcherView)this.mRightPullAction.mActionView).onPull(this.mRightPullAction, -hOffset);
            }
        }
    }

    private void setVerOffsetToTargetOffsetHelper(int vOffset) {
        this.mTargetOffsetHelper.setTopAndBottomOffset(vOffset);
        this.onTargetViewTopAndBottomOffsetChanged(vOffset);
        if (this.mTopPullAction != null) {
            this.mTopPullAction.onTargetMoved(vOffset);
            if (this.mTopPullAction.mActionView instanceof ActionPullWatcherView) {
                ((ActionPullWatcherView)this.mTopPullAction.mActionView).onPull(this.mTopPullAction, vOffset);
            }
        }
        if (this.mBottomPullAction != null) {
            this.mBottomPullAction.onTargetMoved(-vOffset);
            if (this.mBottomPullAction.mActionView instanceof ActionPullWatcherView) {
                ((ActionPullWatcherView)this.mBottomPullAction.mActionView).onPull(this.mBottomPullAction, -vOffset);
            }
        }
    }

    protected void onTargetViewTopAndBottomOffsetChanged(int vOffset) {
    }

    protected void onTargetViewLeftAndRightOffsetChanged(int hOffset) {
    }

    private int checkEdgeTopScrollDown(int dy, int[] consumed, int type) {
        int vOffset = this.mTargetOffsetHelper.getTopAndBottomOffset();
        if (dy > 0 && this.isEdgeEnabled(2) && vOffset > 0) {
            float pullRate = type == 0 ? this.mTopPullAction.getPullRate() : 1.0f;
            int ry = (int)((float)dy * pullRate);
            if (ry == 0) {
                return dy;
            }
            if (vOffset >= ry) {
                consumed[1] = consumed[1] + dy;
                vOffset -= ry;
                dy = 0;
            } else {
                int yConsumed = (int)((float)vOffset / pullRate);
                consumed[1] = consumed[1] + yConsumed;
                dy -= yConsumed;
                vOffset = 0;
            }
            this.setVerOffsetToTargetOffsetHelper(vOffset);
        }
        return dy;
    }

    private int checkEdgeTopScrollUp(int dy, int[] consumed, int type) {
        if (dy < 0 && this.isEdgeEnabled(2) && !this.mTargetView.canScrollVertically(-1) && (type == 0 || this.mTopPullAction.mNeedReceiveFlingFromTargetView)) {
            int vOffset = this.mTargetOffsetHelper.getTopAndBottomOffset();
            float pullRate = type == 0 ? this.mTopPullAction.getPullRate() : this.mTopPullAction.getFlingRate(vOffset);
            int ry = (int)((float)dy * pullRate);
            if (ry == 0) {
                return dy;
            }
            if (this.mTopPullAction.mCanOverPull || -ry <= this.mTopPullAction.getTargetTriggerOffset() - vOffset) {
                vOffset -= ry;
                consumed[1] = consumed[1] + dy;
                dy = 0;
            } else {
                int yConsumed = (int)((float)(vOffset - this.mTopPullAction.getTargetTriggerOffset()) / pullRate);
                consumed[1] = consumed[1] + yConsumed;
                dy -= yConsumed;
                vOffset = this.mBottomPullAction.getTargetTriggerOffset();
            }
            this.setVerOffsetToTargetOffsetHelper(vOffset);
        }
        return dy;
    }

    private int checkEdgeBottomScrollDown(int dy, int[] consumed, int type) {
        if (dy > 0 && this.isEdgeEnabled(8) && !this.mTargetView.canScrollVertically(1) && (type == 0 || this.mBottomPullAction.mNeedReceiveFlingFromTargetView)) {
            int vOffset = this.mTargetOffsetHelper.getTopAndBottomOffset();
            float pullRate = type == 0 ? this.mBottomPullAction.getPullRate() : this.mBottomPullAction.getFlingRate(-vOffset);
            int ry = (int)((float)dy * pullRate);
            if (ry == 0) {
                return dy;
            }
            if (this.mBottomPullAction.mCanOverPull || vOffset - ry >= -this.mBottomPullAction.getTargetTriggerOffset()) {
                vOffset -= ry;
                consumed[1] = consumed[1] + dy;
                dy = 0;
            } else {
                int yConsumed = (int)((float)(-this.mBottomPullAction.getTargetTriggerOffset() - vOffset) / pullRate);
                consumed[1] = consumed[1] + yConsumed;
                dy -= yConsumed;
                vOffset = -this.mBottomPullAction.getTargetTriggerOffset();
            }
            this.setVerOffsetToTargetOffsetHelper(vOffset);
        }
        return dy;
    }

    private int checkEdgeBottomScrollUp(int dy, int[] consumed, int type) {
        int vOffset = this.mTargetOffsetHelper.getTopAndBottomOffset();
        if (dy < 0 && this.isEdgeEnabled(8) && vOffset < 0) {
            float pullRate = type == 0 ? this.mBottomPullAction.getPullRate() : 1.0f;
            int ry = (int)((float)dy * pullRate);
            if (ry == 0) {
                return dy;
            }
            if (vOffset <= ry) {
                consumed[1] = consumed[1] + dy;
                vOffset -= ry;
                dy = 0;
            } else {
                int yConsumed = (int)((float)vOffset / pullRate);
                consumed[1] = consumed[1] + yConsumed;
                dy -= yConsumed;
                vOffset = 0;
            }
            this.setVerOffsetToTargetOffsetHelper(vOffset);
        }
        return dy;
    }

    private int checkEdgeLeftScrollRight(int dx, int[] consumed, int type) {
        int hOffset = this.mTargetOffsetHelper.getLeftAndRightOffset();
        if (dx > 0 && this.isEdgeEnabled(1) && hOffset > 0) {
            float pullRate = type == 0 ? this.mLeftPullAction.getPullRate() : 1.0f;
            int rx = (int)((float)dx * pullRate);
            if (rx == 0) {
                return dx;
            }
            if (hOffset >= rx) {
                consumed[0] = consumed[0] + dx;
                hOffset -= rx;
                dx = 0;
            } else {
                int xConsumed = (int)((float)hOffset / pullRate);
                consumed[0] = consumed[0] + xConsumed;
                dx -= xConsumed;
                hOffset = 0;
            }
            this.setHorOffsetToTargetOffsetHelper(hOffset);
        }
        return dx;
    }

    private int checkEdgeLeftScrollLeft(int dx, int[] consumed, int type) {
        int hOffset = this.mTargetOffsetHelper.getLeftAndRightOffset();
        if (dx < 0 && this.isEdgeEnabled(1) && !this.mTargetView.canScrollHorizontally(-1) && (type == 0 || this.mLeftPullAction.mNeedReceiveFlingFromTargetView)) {
            float pullRate = type == 0 ? this.mLeftPullAction.getPullRate() : this.mLeftPullAction.getFlingRate(hOffset);
            int rx = (int)((float)dx * pullRate);
            if (rx == 0) {
                return dx;
            }
            if (this.mLeftPullAction.mCanOverPull || -rx <= this.mLeftPullAction.getTargetTriggerOffset() - hOffset) {
                hOffset -= rx;
                consumed[0] = consumed[0] + dx;
                dx = 0;
            } else {
                int xConsumed = (int)((float)(hOffset - this.mLeftPullAction.getTargetTriggerOffset()) / pullRate);
                consumed[0] = consumed[0] + xConsumed;
                dx -= xConsumed;
                hOffset = this.mLeftPullAction.getTargetTriggerOffset();
            }
            this.setHorOffsetToTargetOffsetHelper(hOffset);
        }
        return dx;
    }

    private int checkEdgeRightScrollRight(int dx, int[] consumed, int type) {
        if (dx > 0 && this.isEdgeEnabled(4) && !this.mTargetView.canScrollHorizontally(1) && (type == 0 || this.mRightPullAction.mNeedReceiveFlingFromTargetView)) {
            int hOffset = this.mTargetOffsetHelper.getLeftAndRightOffset();
            float pullRate = type == 0 ? this.mRightPullAction.getPullRate() : this.mRightPullAction.getFlingRate(-hOffset);
            int rx = (int)((float)dx * pullRate);
            if (rx == 0) {
                return dx;
            }
            if (this.mRightPullAction.mCanOverPull || hOffset - rx >= -this.mRightPullAction.getTargetTriggerOffset()) {
                hOffset -= rx;
                consumed[0] = consumed[0] + dx;
                dx = 0;
            } else {
                int xConsumed = (int)((float)(-this.mRightPullAction.getTargetTriggerOffset() - hOffset) / pullRate);
                consumed[0] = consumed[0] + xConsumed;
                dx -= xConsumed;
                hOffset = -this.mRightPullAction.getTargetTriggerOffset();
            }
            this.setHorOffsetToTargetOffsetHelper(hOffset);
        }
        return dx;
    }

    private int checkEdgeRightScrollLeft(int dx, int[] consumed, int type) {
        int hOffset = this.mTargetOffsetHelper.getLeftAndRightOffset();
        if (dx < 0 && this.isEdgeEnabled(4) && hOffset < 0) {
            float pullRate = type == 0 ? this.mRightPullAction.getPullRate() : 1.0f;
            int rx = (int)((float)dx * pullRate);
            if (rx == 0) {
                return dx;
            }
            if (hOffset <= dx) {
                consumed[0] = consumed[0] + dx;
                hOffset -= rx;
                dx = 0;
            } else {
                int xConsumed = (int)((float)hOffset / pullRate);
                consumed[0] = consumed[0] + xConsumed;
                dx -= xConsumed;
                hOffset = 0;
            }
            this.setHorOffsetToTargetOffsetHelper(hOffset);
        }
        return dx;
    }

    protected FrameLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        return new LayoutParams(lp);
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public static interface ActionListener {
        public void onActionTriggered(@NonNull PullAction var1);
    }

    public static class DefaultStopTargetViewFlingImpl
    implements StopTargetViewFlingImpl {
        private static DefaultStopTargetViewFlingImpl sInstance;

        public static DefaultStopTargetViewFlingImpl getInstance() {
            if (sInstance == null) {
                sInstance = new DefaultStopTargetViewFlingImpl();
            }
            return sInstance;
        }

        private DefaultStopTargetViewFlingImpl() {
        }

        @Override
        public void stopFling(View view) {
            if (view instanceof RecyclerView) {
                ((RecyclerView)view).stopScroll();
            }
        }
    }

    public static interface StopTargetViewFlingImpl {
        public void stopFling(View var1);
    }

    public static interface ActionPullWatcherView {
        public void onPull(PullAction var1, int var2);

        public void onActionTriggered();

        public void onActionFinished();
    }

    public static interface ActionViewOffsetCalculator {
        public int calculateOffset(PullAction var1, int var2);
    }

    public static class PullActionBuilder {
        @NonNull
        private final View mActionView;
        private int mTargetTriggerOffset = -2;
        private boolean mCanOverPull;
        private float mPullRate = 0.45f;
        private boolean mNeedReceiveFlingFromTargetView = true;
        private float mReceivedFlingFraction = 0.002f;
        private int mActionInitOffset;
        private float mScrollSpeedPerPixel = 1.5f;
        private int mPullEdge;
        private ActionViewOffsetCalculator mActionViewOffsetCalculator;
        private boolean mTriggerUntilScrollToTriggerOffset = false;
        private boolean mScrollToTriggerOffsetAfterTouchUp = true;

        public PullActionBuilder(@NonNull View actionView, int pullEdge) {
            this.mActionView = actionView;
            this.mPullEdge = pullEdge;
        }

        public PullActionBuilder triggerUntilScrollToTriggerOffset(boolean triggerUntilScrollToTriggerOffset) {
            this.mTriggerUntilScrollToTriggerOffset = triggerUntilScrollToTriggerOffset;
            return this;
        }

        public PullActionBuilder scrollToTriggerOffsetAfterTouchUp(boolean scrollToTriggerOffsetAfterTouchUp) {
            this.mScrollToTriggerOffsetAfterTouchUp = scrollToTriggerOffsetAfterTouchUp;
            return this;
        }

        public PullActionBuilder targetTriggerOffset(int offset) {
            this.mTargetTriggerOffset = offset;
            return this;
        }

        public PullActionBuilder canOverPull(boolean canOverPull) {
            this.mCanOverPull = canOverPull;
            return this;
        }

        public PullActionBuilder receivedFlingFraction(float fraction) {
            this.mReceivedFlingFraction = fraction;
            return this;
        }

        public PullActionBuilder needReceiveFlingFromTargetView(boolean needReceive) {
            this.mNeedReceiveFlingFromTargetView = needReceive;
            return this;
        }

        public PullActionBuilder pullRate(float rate) {
            this.mPullRate = rate;
            return this;
        }

        public PullActionBuilder scrollSpeedPerPixel(float scrollSpeedPerPixel) {
            this.mScrollSpeedPerPixel = scrollSpeedPerPixel;
            return this;
        }

        public PullActionBuilder actionInitOffset(int initOffset) {
            this.mActionInitOffset = initOffset;
            return this;
        }

        public PullActionBuilder actionViewOffsetCalculator(ActionViewOffsetCalculator calculator) {
            this.mActionViewOffsetCalculator = calculator;
            return this;
        }

        PullAction build() {
            if (this.mActionViewOffsetCalculator == null) {
                this.mActionViewOffsetCalculator = new QMUIAlwaysFollowOffsetCalculator();
            }
            return new PullAction(this.mActionView, this.mTargetTriggerOffset, this.mCanOverPull, this.mPullRate, this.mActionInitOffset, this.mPullEdge, this.mScrollSpeedPerPixel, this.mNeedReceiveFlingFromTargetView, this.mReceivedFlingFraction, this.mTriggerUntilScrollToTriggerOffset, this.mScrollToTriggerOffsetAfterTouchUp, this.mActionViewOffsetCalculator);
        }
    }

    public static final class PullAction {
        @NonNull
        private final View mActionView;
        private final int mTargetTriggerOffset;
        private final boolean mCanOverPull;
        private final float mPullRate;
        private final float mReceivedFlingFraction;
        private final int mActionInitOffset;
        private final int mPullEdge;
        private final float mScrollSpeedPerPixel;
        private final boolean mNeedReceiveFlingFromTargetView;
        private final boolean mTriggerUntilScrollToTriggerOffset;
        private final boolean mScrollToTriggerOffsetAfterTouchUp;
        private final QMUIViewOffsetHelper mViewOffsetHelper;
        private final ActionViewOffsetCalculator mActionViewOffsetCalculator;
        private boolean mIsActionRunning = false;

        PullAction(@NonNull View actionView, int targetOffset, boolean isTargetCanOverPull, float targetPullRate, int actionInitOffset, int pullEdge, float scrollSpeedPerPixel, boolean needReceiveFlingFromTargetView, float receivedFlingFraction, boolean triggerUntilScrollToTriggerOffset, boolean scrollToTriggerOffsetAfterTouchUp, ActionViewOffsetCalculator calculator) {
            this.mActionView = actionView;
            this.mTargetTriggerOffset = targetOffset;
            this.mCanOverPull = isTargetCanOverPull;
            this.mPullRate = targetPullRate;
            this.mNeedReceiveFlingFromTargetView = needReceiveFlingFromTargetView;
            this.mReceivedFlingFraction = receivedFlingFraction;
            this.mActionInitOffset = actionInitOffset;
            this.mScrollSpeedPerPixel = scrollSpeedPerPixel;
            this.mPullEdge = pullEdge;
            this.mTriggerUntilScrollToTriggerOffset = triggerUntilScrollToTriggerOffset;
            this.mScrollToTriggerOffsetAfterTouchUp = scrollToTriggerOffsetAfterTouchUp;
            this.mActionViewOffsetCalculator = calculator;
            this.mViewOffsetHelper = new QMUIViewOffsetHelper(actionView);
            this.updateOffset(actionInitOffset);
        }

        public int getActionPullSize() {
            if (this.mPullEdge == 2 || this.mPullEdge == 8) {
                return this.mActionView.getHeight();
            }
            return this.mActionView.getWidth();
        }

        public int getActionInitOffset() {
            return this.mActionInitOffset;
        }

        public int getTargetTriggerOffset() {
            if (this.mTargetTriggerOffset == -2) {
                return this.getActionPullSize() - this.getActionInitOffset() * 2;
            }
            return this.mTargetTriggerOffset;
        }

        public float getScrollSpeedPerPixel() {
            return this.mScrollSpeedPerPixel;
        }

        public float getPullRate() {
            return this.mPullRate;
        }

        public boolean isNeedReceiveFlingFromTargetView() {
            return this.mNeedReceiveFlingFromTargetView;
        }

        public boolean isScrollToTriggerOffsetAfterTouchUp() {
            return this.mScrollToTriggerOffsetAfterTouchUp;
        }

        public boolean isTriggerUntilScrollToTriggerOffset() {
            return this.mTriggerUntilScrollToTriggerOffset;
        }

        public float getFlingRate(int currentTargetOffset) {
            return Math.min(this.mPullRate, Math.max(this.mPullRate - (float)(currentTargetOffset - this.getTargetTriggerOffset()) * this.mReceivedFlingFraction, 0.0f));
        }

        public boolean isCanOverPull() {
            return this.mCanOverPull;
        }

        public int getPullEdge() {
            return this.mPullEdge;
        }

        void updateOffset(int offset) {
            if (this.mPullEdge == 1) {
                this.mViewOffsetHelper.setLeftAndRightOffset(offset);
            } else if (this.mPullEdge == 2) {
                this.mViewOffsetHelper.setTopAndBottomOffset(offset);
            } else if (this.mPullEdge == 4) {
                this.mViewOffsetHelper.setLeftAndRightOffset(-offset);
            } else {
                this.mViewOffsetHelper.setTopAndBottomOffset(-offset);
            }
        }

        void onTargetMoved(int targetOffset) {
            this.updateOffset(this.mActionViewOffsetCalculator.calculateOffset(this, targetOffset));
        }
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        public boolean isTarget = false;
        public int edge = 2;
        public int targetTriggerOffset = -2;
        public boolean canOverPull = false;
        public float pullRate = 0.45f;
        public boolean needReceiveFlingFromTarget = true;
        public float receivedFlingFraction = 0.002f;
        public int actionInitOffset = 0;
        public float scrollSpeedPerPixel = 1.5f;
        public boolean triggerUntilScrollToTriggerOffset = false;
        public boolean scrollToTriggerOffsetAfterTouchUp = true;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.QMUIPullLayout_Layout);
            this.isTarget = a.getBoolean(R.styleable.QMUIPullLayout_Layout_qmui_is_target, false);
            if (!this.isTarget) {
                block3: {
                    this.edge = a.getInteger(R.styleable.QMUIPullLayout_Layout_qmui_pull_edge, 2);
                    try {
                        this.targetTriggerOffset = a.getDimensionPixelSize(R.styleable.QMUIPullLayout_Layout_qmui_target_view_trigger_offset, -2);
                    }
                    catch (Exception ignore) {
                        int intValue = a.getInt(R.styleable.QMUIPullLayout_Layout_qmui_target_view_trigger_offset, -2);
                        if (intValue != -2) break block3;
                        this.targetTriggerOffset = -2;
                    }
                }
                this.canOverPull = a.getBoolean(R.styleable.QMUIPullLayout_Layout_qmui_can_over_pull, false);
                this.pullRate = a.getFloat(R.styleable.QMUIPullLayout_Layout_qmui_pull_rate, this.pullRate);
                this.needReceiveFlingFromTarget = a.getBoolean(R.styleable.QMUIPullLayout_Layout_qmui_need_receive_fling_from_target_view, true);
                this.receivedFlingFraction = a.getFloat(R.styleable.QMUIPullLayout_Layout_qmui_received_fling_fraction, this.receivedFlingFraction);
                this.actionInitOffset = a.getDimensionPixelSize(R.styleable.QMUIPullLayout_Layout_qmui_action_view_init_offset, 0);
                this.scrollSpeedPerPixel = a.getFloat(R.styleable.QMUIPullLayout_Layout_qmui_scroll_speed_per_pixel, this.scrollSpeedPerPixel);
                this.triggerUntilScrollToTriggerOffset = a.getBoolean(R.styleable.QMUIPullLayout_Layout_qmui_trigger_until_scroll_to_trigger_offset, false);
                this.scrollToTriggerOffsetAfterTouchUp = a.getBoolean(R.styleable.QMUIPullLayout_Layout_qmui_scroll_to_trigger_offset_after_touch_up, true);
            }
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface PullEdge {
    }
}

