/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.popup;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.util.QMUIResHelper;
import java.lang.ref.WeakReference;

public abstract class QMUIBasePopup<T extends QMUIBasePopup> {
    public static final float DIM_AMOUNT_NOT_EXIST = -1.0f;
    public static final int NOT_SET = -1;
    protected final PopupWindow mWindow;
    protected WindowManager mWindowManager;
    protected Context mContext;
    protected WeakReference<View> mAttachedViewRf;
    private float mDimAmount = -1.0f;
    private int mDimAmountAttr = 0;
    private PopupWindow.OnDismissListener mDismissListener;
    private QMUISkinManager mSkinManager;
    private QMUISkinManager.OnSkinChangeListener mOnSkinChangeListener = new QMUISkinManager.OnSkinChangeListener(){

        @Override
        public void onSkinChange(QMUISkinManager skinManager, int oldSkin, int newSkin) {
            if (QMUIBasePopup.this.mDimAmountAttr != 0) {
                Resources.Theme theme = skinManager.getTheme(newSkin);
                QMUIBasePopup.this.mDimAmount = QMUIResHelper.getAttrFloatValue(theme, QMUIBasePopup.this.mDimAmountAttr);
                QMUIBasePopup.this.updateDimAmount(QMUIBasePopup.this.mDimAmount);
                QMUIBasePopup.this.onSkinChange(oldSkin, newSkin);
            }
        }
    };
    private View.OnAttachStateChangeListener mOnAttachStateChangeListener = new View.OnAttachStateChangeListener(){

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            QMUIBasePopup.this.dismiss();
        }
    };
    private View.OnTouchListener mOutsideTouchDismissListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 4) {
                QMUIBasePopup.this.mWindow.dismiss();
                return true;
            }
            return false;
        }
    };

    public QMUIBasePopup(Context context) {
        this.mContext = context;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mWindow = new PopupWindow(context);
        this.mWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mWindow.setFocusable(true);
        this.mWindow.setTouchable(true);
        this.mWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                QMUIBasePopup.this.removeOldAttachStateChangeListener();
                QMUIBasePopup.this.mAttachedViewRf = null;
                if (QMUIBasePopup.this.mSkinManager != null) {
                    QMUIBasePopup.this.mSkinManager.unRegister(QMUIBasePopup.this.mWindow);
                    QMUIBasePopup.this.mSkinManager.removeSkinChangeListener(QMUIBasePopup.this.mOnSkinChangeListener);
                }
                QMUIBasePopup.this.onDismiss();
                if (QMUIBasePopup.this.mDismissListener != null) {
                    QMUIBasePopup.this.mDismissListener.onDismiss();
                }
            }
        });
        this.dismissIfOutsideTouch(true);
    }

    protected void onSkinChange(int oldSkin, int newSkin) {
    }

    public QMUISkinManager getSkinManager() {
        return this.mSkinManager;
    }

    public T dimAmount(float dimAmount) {
        this.mDimAmount = dimAmount;
        return (T)this;
    }

    public T dimAmountAttr(int dimAmountAttr) {
        this.mDimAmountAttr = dimAmountAttr;
        return (T)this;
    }

    public T skinManager(@Nullable QMUISkinManager skinManager) {
        this.mSkinManager = skinManager;
        return (T)this;
    }

    public T setTouchable(boolean touchable) {
        this.mWindow.setTouchable(true);
        return (T)this;
    }

    public T setFocusable(boolean focusable) {
        this.mWindow.setFocusable(focusable);
        return (T)this;
    }

    public T dismissIfOutsideTouch(boolean dismissIfOutsideTouch) {
        this.mWindow.setOutsideTouchable(dismissIfOutsideTouch);
        if (dismissIfOutsideTouch) {
            this.mWindow.setTouchInterceptor(this.mOutsideTouchDismissListener);
        } else {
            this.mWindow.setTouchInterceptor(null);
        }
        return (T)this;
    }

    public T onDismiss(PopupWindow.OnDismissListener listener) {
        this.mDismissListener = listener;
        return (T)this;
    }

    private void removeOldAttachStateChangeListener() {
        View oldAttachedView;
        if (this.mAttachedViewRf != null && (oldAttachedView = (View)this.mAttachedViewRf.get()) != null) {
            oldAttachedView.removeOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        }
    }

    public View getDecorView() {
        View decorView = null;
        try {
            decorView = this.mWindow.getBackground() == null ? (Build.VERSION.SDK_INT >= 23 ? (View)this.mWindow.getContentView().getParent() : this.mWindow.getContentView()) : (Build.VERSION.SDK_INT >= 23 ? (View)this.mWindow.getContentView().getParent().getParent() : (View)this.mWindow.getContentView().getParent());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return decorView;
    }

    protected void showAtLocation(@NonNull View parent, int x, int y) {
        if (!ViewCompat.isAttachedToWindow((View)parent)) {
            return;
        }
        this.removeOldAttachStateChangeListener();
        parent.addOnAttachStateChangeListener(this.mOnAttachStateChangeListener);
        this.mAttachedViewRf = new WeakReference<View>(parent);
        this.mWindow.showAtLocation(parent, 0, x, y);
        if (this.mSkinManager != null) {
            this.mSkinManager.register(this.mWindow);
            this.mSkinManager.addSkinChangeListener(this.mOnSkinChangeListener);
            if (this.mDimAmountAttr != 0) {
                Resources.Theme currentTheme = this.mSkinManager.getCurrentTheme();
                currentTheme = currentTheme == null ? parent.getContext().getTheme() : currentTheme;
                this.mDimAmount = QMUIResHelper.getAttrFloatValue(currentTheme, this.mDimAmountAttr);
            }
        }
        if (this.mDimAmount != -1.0f) {
            this.updateDimAmount(this.mDimAmount);
        }
    }

    private void updateDimAmount(float dimAmount) {
        View decorView = this.getDecorView();
        if (decorView != null) {
            WindowManager.LayoutParams p = (WindowManager.LayoutParams)decorView.getLayoutParams();
            p.flags |= 2;
            p.dimAmount = dimAmount;
            this.modifyWindowLayoutParams(p);
            this.mWindowManager.updateViewLayout(decorView, (ViewGroup.LayoutParams)p);
        }
    }

    protected void modifyWindowLayoutParams(WindowManager.LayoutParams lp) {
    }

    protected void onDismiss() {
    }

    public final void dismiss() {
        this.mWindow.dismiss();
    }
}

