/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.grouplist;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIConstraintLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class QMUICommonListItemView
extends QMUIConstraintLayout {
    public static final int ACCESSORY_TYPE_NONE = 0;
    public static final int ACCESSORY_TYPE_CHEVRON = 1;
    public static final int ACCESSORY_TYPE_SWITCH = 2;
    public static final int ACCESSORY_TYPE_CUSTOM = 3;
    private static final int TIP_SHOW_NOTHING = 0;
    private static final int TIP_SHOW_RED_POINT = 1;
    private static final int TIP_SHOW_NEW = 2;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int TIP_POSITION_LEFT = 0;
    public static final int TIP_POSITION_RIGHT = 1;
    private int mAccessoryType;
    private int mOrientation = 1;
    private int mTipPosition = 0;
    protected ImageView mImageView;
    private ViewGroup mAccessoryView;
    protected TextView mTextView;
    protected TextView mDetailTextView;
    protected CheckBox mSwitch;
    private ImageView mRedDot;
    private ImageView mNewTipView;
    private boolean mDisableSwitchSelf = false;
    private int mTipShown = 0;

    public QMUICommonListItemView(Context context) {
        this(context, null);
    }

    public QMUICommonListItemView(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.QMUICommonListItemViewStyle);
    }

    public QMUICommonListItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    protected void init(Context context, AttributeSet attrs, int defStyleAttr) {
        LayoutInflater.from((Context)context).inflate(R.layout.qmui_common_list_item, (ViewGroup)this, true);
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.QMUICommonListItemView, defStyleAttr, 0);
        int orientation = array.getInt(R.styleable.QMUICommonListItemView_qmui_orientation, 1);
        int accessoryType = array.getInt(R.styleable.QMUICommonListItemView_qmui_accessory_type, 0);
        int initTitleColor = array.getColor(R.styleable.QMUICommonListItemView_qmui_common_list_title_color, 0);
        int initDetailColor = array.getColor(R.styleable.QMUICommonListItemView_qmui_common_list_detail_color, 0);
        array.recycle();
        this.mImageView = (ImageView)this.findViewById(R.id.group_list_item_imageView);
        this.mTextView = (TextView)this.findViewById(R.id.group_list_item_textView);
        this.mRedDot = (ImageView)this.findViewById(R.id.group_list_item_tips_dot);
        this.mNewTipView = (ImageView)this.findViewById(R.id.group_list_item_tips_new);
        this.mDetailTextView = (TextView)this.findViewById(R.id.group_list_item_detailTextView);
        this.mTextView.setTextColor(initTitleColor);
        this.mDetailTextView.setTextColor(initDetailColor);
        this.mAccessoryView = (ViewGroup)this.findViewById(R.id.group_list_item_accessoryView);
        this.setOrientation(orientation);
        this.setAccessoryType(accessoryType);
    }

    public void updateImageViewLp(LayoutParamConfig lpConfig) {
        if (lpConfig != null) {
            ConstraintLayout.LayoutParams lp = (ConstraintLayout.LayoutParams)this.mImageView.getLayoutParams();
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)lpConfig.onConfig(lp));
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            this.mImageView.setVisibility(8);
        } else {
            this.mImageView.setImageDrawable(drawable2);
            this.mImageView.setVisibility(0);
        }
    }

    public void setTipPosition(int tipPosition) {
        if (this.mTipPosition != tipPosition) {
            this.mTipPosition = tipPosition;
            this.updateLayoutParams();
        }
    }

    public CharSequence getText() {
        return this.mTextView.getText();
    }

    public void setText(CharSequence text) {
        this.mTextView.setText(text);
        if (QMUILangHelper.isNullOrEmpty(text)) {
            this.mTextView.setVisibility(8);
        } else {
            this.mTextView.setVisibility(0);
        }
    }

    public void showRedDot(boolean isShow) {
        int oldTipShown = this.mTipShown;
        if (isShow) {
            this.mTipShown = 1;
        } else if (this.mTipShown == 1) {
            this.mTipShown = 0;
        }
        if (oldTipShown != this.mTipShown) {
            this.updateLayoutParams();
        }
    }

    public void showNewTip(boolean isShow) {
        int oldTipShown = this.mTipShown;
        if (isShow) {
            this.mTipShown = 2;
        } else if (this.mTipShown == 2) {
            this.mTipShown = 0;
        }
        if (oldTipShown != this.mTipShown) {
            this.updateLayoutParams();
        }
    }

    public CharSequence getDetailText() {
        return this.mDetailTextView.getText();
    }

    public void setDetailText(CharSequence text) {
        this.mDetailTextView.setText(text);
        if (QMUILangHelper.isNullOrEmpty(text)) {
            this.mDetailTextView.setVisibility(8);
        } else {
            this.mDetailTextView.setVisibility(0);
        }
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.updateLayoutParams();
    }

    private void updateLayoutParams() {
        this.mNewTipView.setVisibility(this.mTipShown == 2 ? 0 : 8);
        this.mRedDot.setVisibility(this.mTipShown == 1 ? 0 : 8);
        ConstraintLayout.LayoutParams titleLp = (ConstraintLayout.LayoutParams)this.mTextView.getLayoutParams();
        ConstraintLayout.LayoutParams detailLp = (ConstraintLayout.LayoutParams)this.mDetailTextView.getLayoutParams();
        ConstraintLayout.LayoutParams newTipLp = (ConstraintLayout.LayoutParams)this.mNewTipView.getLayoutParams();
        ConstraintLayout.LayoutParams redDotLp = (ConstraintLayout.LayoutParams)this.mRedDot.getLayoutParams();
        if (this.mOrientation == 0) {
            this.mTextView.setTextSize(0, (float)QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_title_v_text_size));
            this.mDetailTextView.setTextSize(0, (float)QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_detail_v_text_size));
            titleLp.verticalChainStyle = 2;
            titleLp.bottomToBottom = -1;
            titleLp.bottomToTop = this.mDetailTextView.getId();
            detailLp.horizontalChainStyle = -1;
            detailLp.verticalChainStyle = 2;
            detailLp.leftToLeft = this.mTextView.getId();
            detailLp.leftToRight = -1;
            detailLp.horizontalBias = 0.0f;
            detailLp.topToTop = -1;
            detailLp.topToBottom = this.mTextView.getId();
            detailLp.leftMargin = 0;
            detailLp.topMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_detail_v_margin_with_title);
            if (this.mTipShown == 2) {
                if (this.mTipPosition == 0) {
                    this.updateTipLeftVerRelatedLayoutParam((View)this.mNewTipView, newTipLp, titleLp, detailLp);
                } else {
                    this.updateTipRightVerRelatedLayoutParam((View)this.mNewTipView, newTipLp, titleLp, detailLp);
                }
            } else if (this.mTipShown == 1) {
                if (this.mTipPosition == 0) {
                    this.updateTipLeftVerRelatedLayoutParam((View)this.mRedDot, redDotLp, titleLp, detailLp);
                } else {
                    this.updateTipRightVerRelatedLayoutParam((View)this.mRedDot, redDotLp, titleLp, detailLp);
                }
            } else {
                int accessoryLeftMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_accessory_margin_left);
                titleLp.horizontalChainStyle = -1;
                titleLp.rightToLeft = this.mAccessoryView.getId();
                titleLp.rightMargin = accessoryLeftMargin;
                titleLp.goneRightMargin = 0;
                detailLp.leftToRight = this.mAccessoryView.getId();
                detailLp.rightMargin = accessoryLeftMargin;
                detailLp.goneRightMargin = 0;
            }
        } else {
            this.mTextView.setTextSize(0, (float)QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_title_h_text_size));
            this.mDetailTextView.setTextSize(0, (float)QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_detail_h_text_size));
            titleLp.verticalChainStyle = -1;
            titleLp.bottomToBottom = 0;
            titleLp.bottomToTop = -1;
            detailLp.verticalChainStyle = -1;
            detailLp.leftToLeft = -1;
            detailLp.topToTop = 0;
            detailLp.topToBottom = -1;
            detailLp.topMargin = 0;
            detailLp.leftMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_detail_h_margin_with_title);
            if (this.mTipShown == 2) {
                if (this.mTipPosition == 0) {
                    this.updateTipLeftHorRelatedLayoutParam((View)this.mNewTipView, newTipLp, titleLp, detailLp);
                } else {
                    this.updateTipRightHorRelatedLayoutParam((View)this.mNewTipView, newTipLp, titleLp, detailLp);
                }
            } else if (this.mTipShown == 1) {
                if (this.mTipPosition == 0) {
                    this.updateTipLeftHorRelatedLayoutParam((View)this.mRedDot, redDotLp, titleLp, detailLp);
                } else {
                    this.updateTipRightHorRelatedLayoutParam((View)this.mRedDot, redDotLp, titleLp, detailLp);
                }
            } else {
                int accessoryLeftMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_accessory_margin_left);
                titleLp.horizontalChainStyle = -1;
                titleLp.rightToLeft = this.mAccessoryView.getId();
                titleLp.rightMargin = accessoryLeftMargin;
                titleLp.goneRightMargin = 0;
                detailLp.leftToRight = this.mTextView.getId();
                detailLp.rightToLeft = this.mAccessoryView.getId();
                detailLp.rightMargin = accessoryLeftMargin;
                detailLp.goneRightMargin = 0;
            }
        }
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)titleLp);
        this.mDetailTextView.setLayoutParams((ViewGroup.LayoutParams)detailLp);
        this.mNewTipView.setLayoutParams((ViewGroup.LayoutParams)newTipLp);
        this.mRedDot.setLayoutParams((ViewGroup.LayoutParams)redDotLp);
    }

    private void updateTipLeftVerRelatedLayoutParam(View tipView, ConstraintLayout.LayoutParams tipLp, ConstraintLayout.LayoutParams titleLp, ConstraintLayout.LayoutParams detailLp) {
        int titleRightMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_holder_margin_with_title);
        int accessoryLeftMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_accessory_margin_left);
        titleLp.horizontalChainStyle = 2;
        titleLp.horizontalBias = 0.0f;
        titleLp.rightToLeft = tipView.getId();
        titleLp.rightMargin = titleRightMargin;
        tipLp.leftToRight = this.mTextView.getId();
        tipLp.rightToLeft = this.mAccessoryView.getId();
        tipLp.rightMargin = accessoryLeftMargin;
        tipLp.topToTop = this.mTextView.getId();
        tipLp.bottomToBottom = this.mTextView.getId();
        tipLp.goneRightMargin = 0;
        detailLp.rightToLeft = this.mAccessoryView.getId();
        detailLp.rightMargin = accessoryLeftMargin;
        detailLp.goneRightMargin = 0;
    }

    private void updateTipRightVerRelatedLayoutParam(View tipView, ConstraintLayout.LayoutParams tipLp, ConstraintLayout.LayoutParams titleLp, ConstraintLayout.LayoutParams detailLp) {
        int accessoryLeftMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_accessory_margin_left);
        tipLp.leftToRight = -1;
        tipLp.rightToLeft = this.mAccessoryView.getId();
        tipLp.rightMargin = accessoryLeftMargin;
        tipLp.goneRightMargin = 0;
        tipLp.topToTop = 0;
        tipLp.bottomToBottom = 0;
        titleLp.horizontalChainStyle = -1;
        titleLp.rightToLeft = tipView.getId();
        titleLp.rightMargin = accessoryLeftMargin;
        detailLp.rightToLeft = tipView.getId();
        detailLp.rightMargin = accessoryLeftMargin;
    }

    private void updateTipLeftHorRelatedLayoutParam(View tipView, ConstraintLayout.LayoutParams tipLp, ConstraintLayout.LayoutParams titleLp, ConstraintLayout.LayoutParams detailLp) {
        int titleRightMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_holder_margin_with_title);
        int accessoryLeftMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_accessory_margin_left);
        titleLp.horizontalChainStyle = 2;
        titleLp.horizontalBias = 0.0f;
        titleLp.rightToLeft = tipView.getId();
        titleLp.rightMargin = titleRightMargin;
        tipLp.leftToRight = this.mTextView.getId();
        tipLp.rightToLeft = this.mAccessoryView.getId();
        tipLp.rightMargin = accessoryLeftMargin;
        tipLp.topToTop = this.mTextView.getId();
        tipLp.bottomToBottom = this.mTextView.getId();
        tipLp.goneRightMargin = 0;
        detailLp.leftToRight = tipView.getId();
        detailLp.rightToLeft = this.mAccessoryView.getId();
        detailLp.rightMargin = accessoryLeftMargin;
        detailLp.goneRightMargin = 0;
    }

    private void updateTipRightHorRelatedLayoutParam(View tipView, ConstraintLayout.LayoutParams tipLp, ConstraintLayout.LayoutParams titleLp, ConstraintLayout.LayoutParams detailLp) {
        int accessoryLeftMargin = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_common_list_item_accessory_margin_left);
        tipLp.leftToRight = -1;
        tipLp.rightToLeft = this.mAccessoryView.getId();
        tipLp.rightMargin = accessoryLeftMargin;
        tipLp.goneRightMargin = 0;
        tipLp.topToTop = 0;
        tipLp.bottomToBottom = 0;
        titleLp.horizontalChainStyle = -1;
        titleLp.rightToLeft = tipView.getId();
        titleLp.rightMargin = accessoryLeftMargin;
        titleLp.horizontalBias = 0.0f;
        detailLp.leftToRight = this.mTextView.getId();
        detailLp.rightToLeft = tipView.getId();
        detailLp.rightMargin = accessoryLeftMargin;
    }

    public int getAccessoryType() {
        return this.mAccessoryType;
    }

    public void setAccessoryType(int type) {
        this.mAccessoryView.removeAllViews();
        this.mAccessoryType = type;
        switch (type) {
            case 1: {
                ImageView tempImageView = this.getAccessoryImageView();
                tempImageView.setImageDrawable(QMUIResHelper.getAttrDrawable(this.getContext(), R.attr.qmui_common_list_item_chevron));
                this.mAccessoryView.addView((View)tempImageView);
                this.mAccessoryView.setVisibility(0);
                break;
            }
            case 2: {
                if (this.mSwitch == null) {
                    this.mSwitch = new AppCompatCheckBox(this.getContext());
                    this.mSwitch.setBackground(null);
                    this.mSwitch.setButtonDrawable(QMUIResHelper.getAttrDrawable(this.getContext(), R.attr.qmui_common_list_item_switch));
                    this.mSwitch.setLayoutParams(this.getAccessoryLayoutParams());
                    if (this.mDisableSwitchSelf) {
                        this.mSwitch.setClickable(false);
                        this.mSwitch.setEnabled(false);
                    }
                }
                this.mAccessoryView.addView((View)this.mSwitch);
                this.mAccessoryView.setVisibility(0);
                break;
            }
            case 3: {
                this.mAccessoryView.setVisibility(0);
                break;
            }
            case 0: {
                this.mAccessoryView.setVisibility(8);
            }
        }
        ConstraintLayout.LayoutParams titleLp = (ConstraintLayout.LayoutParams)this.mTextView.getLayoutParams();
        ConstraintLayout.LayoutParams detailLp = (ConstraintLayout.LayoutParams)this.mDetailTextView.getLayoutParams();
        if (this.mAccessoryView.getVisibility() != 8) {
            detailLp.goneRightMargin = detailLp.rightMargin;
            titleLp.goneRightMargin = titleLp.rightMargin;
        } else {
            detailLp.goneRightMargin = 0;
            titleLp.goneRightMargin = 0;
        }
    }

    private ViewGroup.LayoutParams getAccessoryLayoutParams() {
        return new ViewGroup.LayoutParams(-2, -2);
    }

    private ImageView getAccessoryImageView() {
        AppCompatImageView resultImageView = new AppCompatImageView(this.getContext());
        resultImageView.setLayoutParams(this.getAccessoryLayoutParams());
        resultImageView.setScaleType(ImageView.ScaleType.CENTER);
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        builder.tintColor(R.attr.qmui_skin_support_common_list_chevron_color);
        QMUISkinHelper.setSkinValue((View)resultImageView, builder);
        QMUISkinValueBuilder.release(builder);
        return resultImageView;
    }

    public TextView getTextView() {
        return this.mTextView;
    }

    public TextView getDetailTextView() {
        return this.mDetailTextView;
    }

    public CheckBox getSwitch() {
        return this.mSwitch;
    }

    public ViewGroup getAccessoryContainerView() {
        return this.mAccessoryView;
    }

    public void addAccessoryCustomView(View view) {
        if (this.mAccessoryType == 3) {
            this.mAccessoryView.addView(view);
        }
    }

    public void setDisableSwitchSelf(boolean disableSwitchSelf) {
        this.mDisableSwitchSelf = disableSwitchSelf;
        if (this.mSwitch != null) {
            this.mSwitch.setClickable(!disableSwitchSelf);
            this.mSwitch.setEnabled(!disableSwitchSelf);
        }
    }

    public void setSkinConfig(SkinConfig skinConfig) {
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        if (skinConfig.iconTintColorRes != 0) {
            builder.tintColor(skinConfig.iconTintColorRes);
        }
        if (skinConfig.iconSrcRes != 0) {
            builder.src(skinConfig.iconSrcRes);
        }
        QMUISkinHelper.setSkinValue((View)this.mImageView, builder);
        builder.clear();
        if (skinConfig.titleTextColorRes != 0) {
            builder.textColor(skinConfig.titleTextColorRes);
        }
        QMUISkinHelper.setSkinValue((View)this.mTextView, builder);
        builder.clear();
        if (skinConfig.detailTextColorRes != 0) {
            builder.textColor(skinConfig.detailTextColorRes);
        }
        QMUISkinHelper.setSkinValue((View)this.mDetailTextView, builder);
        builder.clear();
        if (skinConfig.newTipSrcRes != 0) {
            builder.src(skinConfig.newTipSrcRes);
        }
        QMUISkinHelper.setSkinValue((View)this.mNewTipView, builder);
        builder.clear();
        if (skinConfig.tipDotColorRes != 0) {
            builder.bgTintColor(skinConfig.tipDotColorRes);
        }
        QMUISkinHelper.setSkinValue((View)this.mRedDot, builder);
        builder.release();
    }

    public static class SkinConfig {
        public int iconTintColorRes = R.attr.qmui_skin_support_common_list_icon_tint_color;
        public int iconSrcRes = 0;
        public int titleTextColorRes = R.attr.qmui_skin_support_common_list_title_color;
        public int detailTextColorRes = R.attr.qmui_skin_support_common_list_detail_color;
        public int newTipSrcRes = R.attr.qmui_skin_support_common_list_new_drawable;
        public int tipDotColorRes = R.attr.qmui_skin_support_common_list_red_point_tint_color;
    }

    public static interface LayoutParamConfig {
        public ConstraintLayout.LayoutParams onConfig(ConstraintLayout.LayoutParams var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QMUICommonListItemTipPosition {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QMUICommonListItemOrientation {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface QMUICommonListItemAccessoryType {
    }
}

