/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIConstraintLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;

public class QMUIDialogMenuItemView
extends QMUIConstraintLayout {
    private int index = -1;
    private MenuItemViewListener mListener;
    private boolean mIsChecked = false;

    public QMUIDialogMenuItemView(Context context) {
        super(context, null, R.attr.qmui_dialog_menu_item_style);
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        builder.background(R.attr.qmui_skin_support_s_dialog_menu_item_bg);
        QMUISkinHelper.setSkinValue((View)this, builder);
        QMUISkinValueBuilder.release(builder);
    }

    @SuppressLint(value={"CustomViewStyleable"})
    public static TextView createItemTextView(Context context) {
        QMUISpanTouchFixTextView tv = new QMUISpanTouchFixTextView(context);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMenuTextStyleDef, R.attr.qmui_dialog_menu_item_style, 0);
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.QMUIDialogMenuTextStyleDef_android_gravity) {
                tv.setGravity(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogMenuTextStyleDef_android_textColor) {
                tv.setTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 != R.styleable.QMUIDialogMenuTextStyleDef_android_textSize) continue;
            tv.setTextSize(0, a.getDimensionPixelSize(attr2, 0));
        }
        a.recycle();
        tv.setId(View.generateViewId());
        tv.setSingleLine(true);
        tv.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        tv.setDuplicateParentStateEnabled(false);
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        builder.textColor(R.attr.qmui_skin_support_dialog_menu_item_text_color);
        QMUISkinHelper.setSkinValue((View)tv, builder);
        QMUISkinValueBuilder.release(builder);
        return tv;
    }

    public int getMenuIndex() {
        return this.index;
    }

    public void setMenuIndex(int index) {
        this.index = index;
    }

    protected void notifyCheckChange(boolean isChecked) {
    }

    public boolean isChecked() {
        return this.mIsChecked;
    }

    public void setChecked(boolean checked) {
        this.mIsChecked = checked;
        this.notifyCheckChange(this.mIsChecked);
    }

    public void setListener(MenuItemViewListener listener) {
        if (!this.isClickable()) {
            this.setClickable(true);
        }
        this.mListener = listener;
    }

    public boolean performClick() {
        if (this.mListener != null) {
            this.mListener.onClick(this.index);
        }
        return super.performClick();
    }

    @SuppressLint(value={"ViewConstructor", "CustomViewStyleable"})
    public static class CheckItemView
    extends QMUIDialogMenuItemView {
        private Context mContext;
        private TextView mTextView;
        private AppCompatImageView mCheckedView;

        public CheckItemView(Context context, boolean right) {
            super(context);
            this.mContext = context;
            this.mCheckedView = new AppCompatImageView(this.mContext);
            this.mCheckedView.setId(View.generateViewId());
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMenuCheckDef, R.attr.qmui_dialog_menu_item_style, 0);
            int markMarginHor = 0;
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.QMUIDialogMenuCheckDef_qmui_dialog_menu_item_check_mark_margin_hor) {
                    markMarginHor = a.getDimensionPixelSize(attr2, 0);
                    continue;
                }
                if (attr2 != R.styleable.QMUIDialogMenuCheckDef_qmui_dialog_menu_item_check_drawable) continue;
                this.mCheckedView.setImageDrawable(QMUIResHelper.getAttrDrawable(context, a, attr2));
            }
            a.recycle();
            ConstraintLayout.LayoutParams checkLp = new ConstraintLayout.LayoutParams(-2, -2);
            checkLp.topToTop = 0;
            checkLp.bottomToBottom = 0;
            if (right) {
                checkLp.rightToRight = 0;
            } else {
                checkLp.leftToLeft = 0;
            }
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
            builder.src(R.attr.qmui_skin_support_s_dialog_check_drawable);
            QMUISkinHelper.setSkinValue((View)this.mCheckedView, builder);
            QMUISkinValueBuilder.release(builder);
            this.addView((View)this.mCheckedView, (ViewGroup.LayoutParams)checkLp);
            this.mTextView = CheckItemView.createItemTextView(this.mContext);
            ConstraintLayout.LayoutParams tvLp = new ConstraintLayout.LayoutParams(0, 0);
            if (right) {
                tvLp.leftToLeft = 0;
                tvLp.rightToLeft = this.mCheckedView.getId();
                tvLp.rightMargin = markMarginHor;
            } else {
                tvLp.rightToRight = 0;
                tvLp.leftToRight = this.mCheckedView.getId();
                tvLp.leftMargin = markMarginHor;
            }
            tvLp.topToTop = 0;
            tvLp.bottomToBottom = 0;
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)tvLp);
        }

        public CheckItemView(Context context, boolean right, CharSequence text) {
            this(context, right);
            this.setText(text);
        }

        public void setText(CharSequence text) {
            this.mTextView.setText(text);
        }

        public CharSequence getText() {
            return this.mTextView.getText();
        }

        @Override
        protected void notifyCheckChange(boolean isChecked) {
            QMUIViewHelper.safeSetImageViewSelected((ImageView)this.mCheckedView, isChecked);
        }
    }

    public static class MarkItemView
    extends QMUIDialogMenuItemView {
        private Context mContext;
        private TextView mTextView;
        private AppCompatImageView mCheckedView;

        @SuppressLint(value={"CustomViewStyleable"})
        public MarkItemView(Context context) {
            super(context);
            this.mContext = context;
            this.mCheckedView = new AppCompatImageView(this.mContext);
            this.mCheckedView.setId(View.generateViewId());
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMenuMarkDef, R.attr.qmui_dialog_menu_item_style, 0);
            int markMarginHor = 0;
            int count = a.getIndexCount();
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.QMUIDialogMenuMarkDef_qmui_dialog_menu_item_check_mark_margin_hor) {
                    markMarginHor = a.getDimensionPixelSize(attr2, 0);
                    continue;
                }
                if (attr2 != R.styleable.QMUIDialogMenuMarkDef_qmui_dialog_menu_item_mark_drawable) continue;
                this.mCheckedView.setImageDrawable(QMUIResHelper.getAttrDrawable(context, a, attr2));
            }
            a.recycle();
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
            builder.src(R.attr.qmui_skin_support_dialog_mark_drawable);
            QMUISkinHelper.setSkinValue((View)this.mCheckedView, builder);
            QMUISkinValueBuilder.release(builder);
            ConstraintLayout.LayoutParams checkLp = new ConstraintLayout.LayoutParams(-2, -2);
            checkLp.rightToRight = 0;
            checkLp.topToTop = 0;
            checkLp.bottomToBottom = 0;
            this.addView((View)this.mCheckedView, (ViewGroup.LayoutParams)checkLp);
            this.mTextView = MarkItemView.createItemTextView(this.mContext);
            ConstraintLayout.LayoutParams tvLp = new ConstraintLayout.LayoutParams(0, 0);
            tvLp.leftToLeft = 0;
            tvLp.topToTop = 0;
            tvLp.bottomToBottom = 0;
            tvLp.rightToLeft = this.mCheckedView.getId();
            tvLp.rightMargin = markMarginHor;
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)tvLp);
            this.mCheckedView.setVisibility(4);
        }

        public MarkItemView(Context context, CharSequence text) {
            this(context);
            this.setText(text);
        }

        public void setText(CharSequence text) {
            this.mTextView.setText(text);
        }

        @Override
        protected void notifyCheckChange(boolean isChecked) {
            this.mCheckedView.setVisibility(isChecked ? 0 : 4);
        }
    }

    public static class TextItemView
    extends QMUIDialogMenuItemView {
        protected TextView mTextView;

        public TextItemView(Context context) {
            super(context);
            this.init();
        }

        public TextItemView(Context context, CharSequence text) {
            super(context);
            this.init();
            this.setText(text);
        }

        private void init() {
            this.mTextView = TextItemView.createItemTextView(this.getContext());
            ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(0, 0);
            lp.leftToLeft = 0;
            lp.rightToRight = 0;
            lp.bottomToBottom = 0;
            lp.topToTop = 0;
            this.addView((View)this.mTextView, (ViewGroup.LayoutParams)lp);
        }

        public void setText(CharSequence text) {
            this.mTextView.setText(text);
        }

        @Deprecated
        public void setTextColor(int color2) {
            this.mTextView.setTextColor(color2);
        }

        public void setTextColorAttr(int colorAttr) {
            int color2 = QMUISkinHelper.getSkinColor((View)this, colorAttr);
            this.mTextView.setTextColor(color2);
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
            builder.textColor(colorAttr);
            QMUISkinHelper.setSkinValue((View)this.mTextView, builder);
            QMUISkinValueBuilder.release(builder);
        }
    }

    public static interface MenuItemViewListener {
        public void onClick(int var1);
    }
}

