/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIConstraintLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.skin.defaultAttr.QMUISkinSimpleDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetGridItemModel;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;

public class QMUIBottomSheetGridItemView
extends QMUIConstraintLayout {
    protected AppCompatImageView mIconIv;
    protected AppCompatImageView mSubscriptIv;
    protected TextView mTitleTv;
    protected Object mModelTag;

    public QMUIBottomSheetGridItemView(Context context) {
        this(context, null);
    }

    public QMUIBottomSheetGridItemView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUIBottomSheetGridItemView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setChangeAlphaWhenPress(true);
        int paddingTop = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_grid_item_padding_top);
        int paddingBottom = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_grid_item_padding_bottom);
        this.setPadding(0, paddingTop, 0, paddingBottom);
        this.mIconIv = this.onCreateIconView(context);
        this.mIconIv.setId(View.generateViewId());
        this.mIconIv.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        int iconSize = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_grid_item_icon_size);
        ConstraintLayout.LayoutParams iconLp = new ConstraintLayout.LayoutParams(iconSize, iconSize);
        iconLp.leftToLeft = 0;
        iconLp.rightToRight = 0;
        iconLp.topToTop = 0;
        this.addView((View)this.mIconIv, (ViewGroup.LayoutParams)iconLp);
        this.mTitleTv = this.onCreateTitleView(context);
        this.mTitleTv.setId(View.generateViewId());
        QMUISkinSimpleDefaultAttrProvider provider = new QMUISkinSimpleDefaultAttrProvider();
        provider.setDefaultSkinAttr("textColor", R.attr.qmui_skin_support_bottom_sheet_grid_item_text_color);
        QMUIResHelper.assignTextViewWithAttr(this.mTitleTv, R.attr.qmui_bottom_sheet_grid_item_text_style);
        QMUISkinHelper.setSkinDefaultProvider((View)this.mTitleTv, provider);
        ConstraintLayout.LayoutParams titleLp = new ConstraintLayout.LayoutParams(-2, -2);
        titleLp.leftToLeft = 0;
        titleLp.rightToRight = 0;
        titleLp.topToBottom = this.mIconIv.getId();
        titleLp.topMargin = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_grid_item_text_margin_top);
        this.addView((View)this.mTitleTv, (ViewGroup.LayoutParams)titleLp);
    }

    protected AppCompatImageView onCreateIconView(Context context) {
        return new AppCompatImageView(context);
    }

    protected TextView onCreateTitleView(Context context) {
        return new QMUISpanTouchFixTextView(context);
    }

    public void render(@NonNull QMUIBottomSheetGridItemModel model) {
        this.mModelTag = model.tag;
        this.setTag(model.tag);
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        this.renderIcon(model, builder);
        builder.clear();
        this.renderTitle(model, builder);
        builder.clear();
        this.renderSubScript(model, builder);
        builder.release();
    }

    public Object getModelTag() {
        return this.mModelTag;
    }

    protected void renderIcon(@NonNull QMUIBottomSheetGridItemModel model, @NonNull QMUISkinValueBuilder builder) {
        if (model.imageSkinSrcAttr != 0) {
            builder.src(model.imageSkinSrcAttr);
            QMUISkinHelper.setSkinValue((View)this.mIconIv, builder);
            Drawable drawable2 = QMUISkinHelper.getSkinDrawable((View)this.mIconIv, model.imageSkinSrcAttr);
            this.mIconIv.setImageDrawable(drawable2);
        } else {
            Drawable drawable3 = model.image;
            if (drawable3 == null && model.imageRes != 0) {
                drawable3 = ContextCompat.getDrawable((Context)this.getContext(), (int)model.imageRes);
            }
            if (drawable3 != null) {
                drawable3.mutate();
            }
            this.mIconIv.setImageDrawable(drawable3);
            if (model.imageSkinTintColorAttr != 0) {
                builder.tintColor(model.imageSkinTintColorAttr);
                QMUISkinHelper.setSkinValue((View)this.mIconIv, builder);
            } else {
                QMUISkinHelper.setSkinValue((View)this.mIconIv, "");
            }
        }
    }

    protected void renderTitle(@NonNull QMUIBottomSheetGridItemModel model, @NonNull QMUISkinValueBuilder builder) {
        this.mTitleTv.setText(model.text);
        if (model.textSkinColorAttr != 0) {
            builder.textColor(model.textSkinColorAttr);
        }
        QMUISkinHelper.setSkinValue((View)this.mTitleTv, builder);
        if (model.typeface != null) {
            this.mTitleTv.setTypeface(model.typeface);
        }
    }

    protected void renderSubScript(@NonNull QMUIBottomSheetGridItemModel model, @NonNull QMUISkinValueBuilder builder) {
        if (model.subscriptRes != 0 || model.subscript != null || model.subscriptSkinSrcAttr != 0) {
            Drawable drawable2;
            if (this.mSubscriptIv == null) {
                this.mSubscriptIv = new AppCompatImageView(this.getContext());
                this.mSubscriptIv.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
                ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(-2, -2);
                lp.rightToRight = this.mIconIv.getId();
                lp.topToTop = this.mIconIv.getId();
                this.addView((View)this.mSubscriptIv, (ViewGroup.LayoutParams)lp);
            }
            this.mSubscriptIv.setVisibility(0);
            if (model.subscriptSkinSrcAttr != 0) {
                builder.src(model.subscriptSkinSrcAttr);
                QMUISkinHelper.setSkinValue((View)this.mSubscriptIv, builder);
                drawable2 = QMUISkinHelper.getSkinDrawable((View)this.mSubscriptIv, model.subscriptSkinSrcAttr);
                this.mIconIv.setImageDrawable(drawable2);
            } else {
                drawable2 = model.subscript;
                if (drawable2 == null && model.subscriptRes != 0) {
                    drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)model.subscriptRes);
                }
                if (drawable2 != null) {
                    drawable2.mutate();
                }
                this.mSubscriptIv.setImageDrawable(drawable2);
                if (model.subscriptSkinTintColorAttr != 0) {
                    builder.tintColor(model.subscriptSkinTintColorAttr);
                    QMUISkinHelper.setSkinValue((View)this.mSubscriptIv, builder);
                } else {
                    QMUISkinHelper.setSkinValue((View)this.mSubscriptIv, "");
                }
            }
        } else if (this.mSubscriptIv != null) {
            this.mSubscriptIv.setVisibility(8);
        }
    }
}

