/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.view.View;
import android.view.ViewGroup;
import androidx.core.util.Pools;
import com.qmuiteam.qmui.R;
import java.util.ArrayList;
import java.util.List;

public abstract class QMUIItemViewsAdapter<T, V extends View> {
    private Pools.Pool<V> mCachePool;
    private List<T> mItemData = new ArrayList<T>();
    private List<V> mViews = new ArrayList<V>();
    private ViewGroup mParentView;

    public QMUIItemViewsAdapter(ViewGroup parentView) {
        this.mParentView = parentView;
    }

    public void detach(int count) {
        for (int childCount = this.mViews.size(); childCount > 0 && count > 0; --childCount, --count) {
            Object notCacheTag;
            View view = (View)this.mViews.remove(childCount - 1);
            if (this.mCachePool == null) {
                this.mCachePool = new Pools.SimplePool(12);
            }
            if ((notCacheTag = view.getTag(R.id.qmui_view_can_not_cache_tag)) == null || !((Boolean)notCacheTag).booleanValue()) {
                try {
                    this.onViewRecycled(view);
                    this.mCachePool.release((Object)view);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mParentView.removeView(view);
        }
    }

    public void clear() {
        this.mItemData.clear();
        this.detach(this.mViews.size());
    }

    private V getView() {
        Object v;
        View view = v = this.mCachePool != null ? (View)this.mCachePool.acquire() : null;
        if (v == null) {
            v = this.createView(this.mParentView);
        }
        return (V)v;
    }

    protected abstract V createView(ViewGroup var1);

    protected void onViewRecycled(V v) {
    }

    public QMUIItemViewsAdapter<T, V> addItem(T item) {
        this.mItemData.add(item);
        return this;
    }

    public void setup() {
        Object view;
        int i;
        int itemCount = this.mItemData.size();
        int childCount = this.mViews.size();
        if (childCount > itemCount) {
            this.detach(childCount - itemCount);
        } else if (childCount < itemCount) {
            for (i = 0; i < itemCount - childCount; ++i) {
                view = this.getView();
                this.mParentView.addView(view);
                this.mViews.add(view);
            }
        }
        for (i = 0; i < itemCount; ++i) {
            view = (View)this.mViews.get(i);
            T item = this.mItemData.get(i);
            this.bind(item, view, i);
        }
        this.mParentView.invalidate();
        this.mParentView.requestLayout();
    }

    public T getItem(int position) {
        if (this.mItemData == null) {
            return null;
        }
        if (position < 0 || position >= this.mItemData.size()) {
            return null;
        }
        return this.mItemData.get(position);
    }

    public void replaceItem(int position, T data) throws IllegalAccessException {
        if (position >= this.mItemData.size() || position < 0) {
            throw new IllegalAccessException("\u66ff\u6362\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.mItemData.set(position, data);
    }

    protected abstract void bind(T var1, V var2, int var3);

    public List<V> getViews() {
        return this.mViews;
    }

    public int getSize() {
        if (this.mItemData == null) {
            return 0;
        }
        return this.mItemData.size();
    }
}

