/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.qmuiteam.qmui.util.QMUIReflectHelper;

public class QMUIToastHelper {
    private static final String TAG = "QMUIToastHelper";

    public static void show(Toast toast) {
        if (Build.VERSION.SDK_INT == 25) {
            QMUIToastHelper.fixToastForAndroidN(toast).show();
        } else {
            toast.show();
        }
    }

    private static Toast fixToastForAndroidN(Toast toast) {
        Object tn = QMUIReflectHelper.getFieldValue((Object)toast, "mTN");
        if (tn == null) {
            Log.w((String)TAG, (String)("The value of field mTN of " + toast + " is null"));
            return toast;
        }
        Object handler = QMUIReflectHelper.getFieldValue(tn, "mHandler");
        if (handler instanceof Handler && QMUIReflectHelper.setFieldValue(handler, "mCallback", new FixCallback((Handler)handler))) {
            return toast;
        }
        Object show = QMUIReflectHelper.getFieldValue(tn, "mShow");
        if (show instanceof Runnable && QMUIReflectHelper.setFieldValue(tn, "mShow", new FixRunnable((Runnable)show))) {
            return toast;
        }
        Log.w((String)TAG, (String)("Neither field mHandler nor mShow of " + tn + " is accessible"));
        return toast;
    }

    public static class FixRunnable
    implements Runnable {
        private final Runnable mRunnable;

        public FixRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.mRunnable.run();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public static class FixCallback
    implements Handler.Callback {
        private final Handler mHandler;

        public FixCallback(Handler handler) {
            this.mHandler = handler;
        }

        public boolean handleMessage(@NonNull Message msg) {
            try {
                this.mHandler.handleMessage(msg);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return true;
        }
    }
}

