/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.graphics.drawable.Drawable;
import android.text.SpannableStringBuilder;
import android.view.View;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.span.QMUIMarginImageSpan;

public class QMUISpanHelper {
    public static CharSequence generateSideIconText(boolean left, int iconPadding, CharSequence text, Drawable icon) {
        return QMUISpanHelper.generateSideIconText(left, iconPadding, text, icon, 0);
    }

    public static CharSequence generateSideIconText(boolean left, int iconPadding, CharSequence text, Drawable icon, int iconOffsetY) {
        return QMUISpanHelper.generateSideIconText(left, iconPadding, text, icon, iconOffsetY, 0, null);
    }

    public static CharSequence generateSideIconText(boolean left, int iconPadding, CharSequence text, Drawable icon, int iconTintAttr, @Nullable View skinFollowView) {
        return QMUISpanHelper.generateSideIconText(left, iconPadding, text, icon, 0, iconTintAttr, skinFollowView);
    }

    public static CharSequence generateSideIconText(boolean left, int iconPadding, CharSequence text, Drawable icon, int iconOffsetY, int iconTintAttr, @Nullable View skinFollowView) {
        return QMUISpanHelper.generateHorIconText(text, left ? iconPadding : 0, (Drawable)(left ? icon : null), left ? iconTintAttr : 0, left ? 0 : iconPadding, left ? null : icon, left ? 0 : iconTintAttr, iconOffsetY, skinFollowView);
    }

    public static CharSequence generateHorIconText(CharSequence text, int leftPadding, Drawable iconLeft, int rightPadding, Drawable iconRight) {
        return QMUISpanHelper.generateHorIconText(text, leftPadding, iconLeft, rightPadding, iconRight, 0);
    }

    public static CharSequence generateHorIconText(CharSequence text, int leftPadding, Drawable iconLeft, int rightPadding, Drawable iconRight, int iconOffsetY) {
        return QMUISpanHelper.generateHorIconText(text, leftPadding, iconLeft, 0, rightPadding, iconRight, 0, iconOffsetY, null);
    }

    public static CharSequence generateHorIconText(CharSequence text, int leftPadding, Drawable iconLeft, int iconLeftTintAttr, int rightPadding, Drawable iconRight, int iconRightTintAttr, @Nullable View skinFollowView) {
        return QMUISpanHelper.generateHorIconText(text, leftPadding, iconLeft, iconLeftTintAttr, rightPadding, iconRight, iconRightTintAttr, 0, skinFollowView);
    }

    public static CharSequence generateHorIconText(CharSequence text, int leftPadding, Drawable iconLeft, int iconLeftTintAttr, int rightPadding, Drawable iconRight, int iconRightTintAttr, int iconOffsetY, @Nullable View skinFollowView) {
        QMUIMarginImageSpan imageSpan;
        int end;
        int start;
        if (iconLeft == null && iconRight == null) {
            return text;
        }
        String iconTag = "[icon]";
        SpannableStringBuilder builder = new SpannableStringBuilder();
        if (iconLeft != null) {
            iconLeft.setBounds(0, 0, iconLeft.getIntrinsicWidth(), iconLeft.getIntrinsicHeight());
            start = 0;
            builder.append((CharSequence)iconTag);
            end = builder.length();
            imageSpan = new QMUIMarginImageSpan(iconLeft, -100, 0, leftPadding, iconOffsetY);
            imageSpan.setSkinSupportWithTintColor(skinFollowView, iconLeftTintAttr);
            imageSpan.setAvoidSuperChangeFontMetrics(true);
            builder.setSpan((Object)imageSpan, start, end, 17);
        }
        builder.append(text);
        if (iconRight != null) {
            iconRight.setBounds(0, 0, iconRight.getIntrinsicWidth(), iconRight.getIntrinsicHeight());
            start = builder.length();
            builder.append((CharSequence)iconTag);
            end = builder.length();
            imageSpan = new QMUIMarginImageSpan(iconRight, -100, rightPadding, 0, iconOffsetY);
            imageSpan.setSkinSupportWithTintColor(skinFollowView, iconRightTintAttr);
            imageSpan.setAvoidSuperChangeFontMetrics(true);
            builder.setSpan((Object)imageSpan, start, end, 17);
        }
        return builder;
    }
}

