/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import androidx.annotation.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import java.util.Objects;

public class QMUILangHelper {
    public static int getNumberDigits(int number) {
        if (number <= 0) {
            return 0;
        }
        return (int)(Math.log10(number) + 1.0);
    }

    public static int getNumberDigits(long number) {
        if (number <= 0L) {
            return 0;
        }
        return (int)(Math.log10(number) + 1.0);
    }

    public static String formatNumberToLimitedDigits(int number, int maxDigits) {
        if (QMUILangHelper.getNumberDigits(number) > maxDigits) {
            StringBuilder result = new StringBuilder();
            for (int digit = 1; digit <= maxDigits; ++digit) {
                result.append("9");
            }
            result.append("+");
            return result.toString();
        }
        return String.valueOf(number);
    }

    public static String regularizePrice(float price) {
        return String.format(Locale.CHINESE, "%.2f", Float.valueOf(price));
    }

    public static String regularizePrice(double price) {
        return String.format(Locale.CHINESE, "%.2f", price);
    }

    public static boolean isNullOrEmpty(@Nullable CharSequence string) {
        return string == null || string.length() == 0;
    }

    public static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Deprecated
    public static boolean objectEquals(Object a, Object b) {
        return Objects.equals(a, b);
    }

    public static int constrain(int amount, int low, int high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    public static float constrain(float amount, float low, float high) {
        return amount < low ? low : (amount > high ? high : amount);
    }
}

