/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.skin.handler;

import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.TextView;
import androidx.core.widget.TintableCompoundDrawablesView;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.handler.QMUISkinRuleColorStateListHandler;
import com.qmuiteam.qmui.util.QMUIDrawableHelper;
import org.jetbrains.annotations.NotNull;

public class QMUISkinRuleTextCompoundTintColorHandler
extends QMUISkinRuleColorStateListHandler {
    @Override
    protected void handle(@NotNull View view, @NotNull String name, ColorStateList colorStateList) {
        if (colorStateList == null) {
            return;
        }
        if (view instanceof TextView) {
            TextView tv = (TextView)view;
            if (Build.VERSION.SDK_INT >= 23) {
                tv.setCompoundDrawableTintList(colorStateList);
            } else if (tv instanceof TintableCompoundDrawablesView) {
                ((TintableCompoundDrawablesView)tv).setSupportCompoundDrawablesTintList(colorStateList);
            } else {
                Drawable[] drawables = tv.getCompoundDrawables();
                for (int i = 0; i < drawables.length; ++i) {
                    Drawable drawable2 = drawables[i];
                    if (drawable2 == null) continue;
                    drawable2 = drawable2.mutate();
                    QMUIDrawableHelper.setDrawableTintColor(drawable2, colorStateList.getDefaultColor());
                    drawables[i] = drawable2;
                }
                tv.setCompoundDrawables(drawables[0], drawables[1], drawables[2], drawables[3]);
            }
        } else {
            QMUISkinHelper.warnRuleNotSupport(view, name);
        }
    }
}

