/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedScrollCommon;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedTopView;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.webview.QMUIWebView;

public class QMUIContinuousNestedTopWebView
extends QMUIWebView
implements IQMUIContinuousNestedTopView {
    public static final String KEY_SCROLL_INFO = "@qmui_scroll_info_top_webview";
    private IQMUIContinuousNestedScrollCommon.OnScrollNotifier mScrollNotifier;

    public QMUIContinuousNestedTopWebView(Context context) {
        super(context);
        this.init();
    }

    public QMUIContinuousNestedTopWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public QMUIContinuousNestedTopWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
    }

    @Override
    public int consumeScroll(int yUnconsumed) {
        int scrollY = this.getScrollY();
        int maxScrollY = this.getScrollOffsetRange();
        scrollY = Math.max(0, Math.min(scrollY, maxScrollY));
        int dy = 0;
        if (yUnconsumed < 0) {
            dy = Math.max(yUnconsumed, -scrollY);
        } else if (yUnconsumed > 0) {
            dy = Math.min(yUnconsumed, maxScrollY - scrollY);
        }
        this.scrollBy(0, dy);
        return yUnconsumed - dy;
    }

    @Override
    public int getCurrentScroll() {
        int scrollY = this.getScrollY();
        int scrollRange = this.getScrollOffsetRange();
        return Math.max(0, Math.min(scrollY, scrollRange));
    }

    @Override
    public int getScrollOffsetRange() {
        return this.computeVerticalScrollRange() - this.getHeight();
    }

    @Override
    public void injectScrollNotifier(IQMUIContinuousNestedScrollCommon.OnScrollNotifier notifier) {
        this.mScrollNotifier = notifier;
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mScrollNotifier != null) {
            this.mScrollNotifier.notify(this.getCurrentScroll(), this.getScrollOffsetRange());
        }
    }

    @Override
    public void saveScrollInfo(@NonNull Bundle bundle) {
        bundle.putInt(KEY_SCROLL_INFO, this.getScrollY());
    }

    @Override
    public void restoreScrollInfo(@NonNull Bundle bundle) {
        int scrollY = QMUIDisplayHelper.px2dp(this.getContext(), bundle.getInt(KEY_SCROLL_INFO, 0));
        this.exec("javascript:scrollTo(0, " + scrollY + ")");
    }

    private void exec(String jsCode) {
        this.evaluateJavascript(jsCode, null);
    }
}

