/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.link;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.qmuiteam.qmui.link.ITouchableSpan;
import com.qmuiteam.qmui.widget.textview.ISpanTouchFix;
import java.lang.ref.WeakReference;

public class QMUILinkTouchDecorHelper {
    private WeakReference<ITouchableSpan> mPressedSpanRf;

    public boolean onTouchEvent(TextView textView, Spannable spannable, MotionEvent event) {
        if (event.getAction() == 0) {
            ITouchableSpan span = this.getPressedSpan(textView, spannable, event);
            if (span != null) {
                span.setPressed(true);
                Selection.setSelection((Spannable)spannable, (int)spannable.getSpanStart((Object)span), (int)spannable.getSpanEnd((Object)span));
                this.mPressedSpanRf = new WeakReference<ITouchableSpan>(span);
            }
            if (textView instanceof ISpanTouchFix) {
                ISpanTouchFix tv = (ISpanTouchFix)textView;
                tv.setTouchSpanHit(span != null);
            }
            return span != null;
        }
        if (event.getAction() == 2) {
            ITouchableSpan touchedSpan = this.getPressedSpan(textView, spannable, event);
            ITouchableSpan recordSpan = null;
            if (this.mPressedSpanRf != null) {
                recordSpan = (ITouchableSpan)this.mPressedSpanRf.get();
            }
            if (recordSpan != null && recordSpan != touchedSpan) {
                recordSpan.setPressed(false);
                this.mPressedSpanRf = null;
                recordSpan = null;
                Selection.removeSelection((Spannable)spannable);
            }
            if (textView instanceof ISpanTouchFix) {
                ISpanTouchFix tv = (ISpanTouchFix)textView;
                tv.setTouchSpanHit(recordSpan != null);
            }
            return recordSpan != null;
        }
        if (event.getAction() == 1) {
            boolean touchSpanHint = false;
            ITouchableSpan recordSpan = null;
            if (this.mPressedSpanRf != null) {
                recordSpan = (ITouchableSpan)this.mPressedSpanRf.get();
            }
            if (recordSpan != null) {
                touchSpanHint = true;
                recordSpan.setPressed(false);
                if (event.getAction() == 1) {
                    recordSpan.onClick((View)textView);
                }
            }
            this.mPressedSpanRf = null;
            Selection.removeSelection((Spannable)spannable);
            if (textView instanceof ISpanTouchFix) {
                ISpanTouchFix tv = (ISpanTouchFix)textView;
                tv.setTouchSpanHit(touchSpanHint);
            }
            return touchSpanHint;
        }
        ITouchableSpan recordSpan = null;
        if (this.mPressedSpanRf != null) {
            recordSpan = (ITouchableSpan)this.mPressedSpanRf.get();
        }
        if (recordSpan != null) {
            recordSpan.setPressed(false);
        }
        if (textView instanceof ISpanTouchFix) {
            ISpanTouchFix tv = (ISpanTouchFix)textView;
            tv.setTouchSpanHit(false);
        }
        this.mPressedSpanRf = null;
        Selection.removeSelection((Spannable)spannable);
        return false;
    }

    public ITouchableSpan getPressedSpan(TextView textView, Spannable spannable, MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        x -= textView.getTotalPaddingLeft();
        y -= textView.getTotalPaddingTop();
        x += textView.getScrollX();
        Layout layout = textView.getLayout();
        int line = layout.getLineForVertical(y += textView.getScrollY());
        try {
            int off = layout.getOffsetForHorizontal(line, (float)x);
            if ((float)x < layout.getLineLeft(line) || (float)x > layout.getLineRight(line)) {
                off = -1;
            }
            ITouchableSpan[] link = (ITouchableSpan[])spannable.getSpans(off, off, ITouchableSpan.class);
            ITouchableSpan touchedSpan = null;
            if (link.length > 0) {
                touchedSpan = link[0];
            }
            return touchedSpan;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }
}

