/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.webview;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewBridgeHandler;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewClient;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public class QMUIBridgeWebViewClient
extends QMUIWebViewClient {
    public static final String QMUI_BRIDGE_HAS_MESSAGE = "qmui://__QUEUE_MESSAGE__";
    public static final String QMUI_BRIDGE_JS = "QMUIWebviewBridge.js";
    private QMUIWebViewBridgeHandler mWebViewBridgeHandler;
    private boolean mNeedInjectLocalBridgeJs;

    public QMUIBridgeWebViewClient(boolean needDispatchSafeAreaInset, boolean disableVideoFullscreenBtnAlways, @NonNull QMUIWebViewBridgeHandler bridgeHandler) {
        this(needDispatchSafeAreaInset, disableVideoFullscreenBtnAlways, true, bridgeHandler);
    }

    public QMUIBridgeWebViewClient(boolean needDispatchSafeAreaInset, boolean disableVideoFullscreenBtnAlways, boolean needInjectLocalBridgeJs, @NonNull QMUIWebViewBridgeHandler bridgeHandler) {
        super(needDispatchSafeAreaInset, disableVideoFullscreenBtnAlways);
        this.mNeedInjectLocalBridgeJs = needInjectLocalBridgeJs;
        this.mWebViewBridgeHandler = bridgeHandler;
    }

    public final boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (url.startsWith(QMUI_BRIDGE_HAS_MESSAGE)) {
            this.mWebViewBridgeHandler.fetchAndMessageFromJs();
            return true;
        }
        return this.onShouldOverrideUrlLoading(view, url);
    }

    protected boolean onShouldOverrideUrlLoading(WebView view, String url) {
        return super.shouldOverrideUrlLoading(view, url);
    }

    public final boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        String url;
        if (Build.VERSION.SDK_INT >= 24 && (url = request.getUrl().toString()).startsWith(QMUI_BRIDGE_HAS_MESSAGE)) {
            this.mWebViewBridgeHandler.fetchAndMessageFromJs();
            return true;
        }
        return this.onShouldOverrideUrlLoading(view, request);
    }

    @TargetApi(value=24)
    protected boolean onShouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        return super.shouldOverrideUrlLoading(view, request);
    }

    @Override
    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (this.mNeedInjectLocalBridgeJs) {
            String bridgeScript = QMUIBridgeWebViewClient.loadBridgeScript(view.getContext());
            if (bridgeScript != null) {
                view.evaluateJavascript(bridgeScript, null);
                this.mWebViewBridgeHandler.onBridgeLoaded();
            }
        } else {
            this.mWebViewBridgeHandler.onBridgeLoaded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static String loadBridgeScript(Context context) {
        String string2;
        InputStream in = null;
        try {
            in = context.getAssets().open(QMUI_BRIDGE_JS);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(in));
            String line = bufferedReader.readLine();
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = bufferedReader.readLine();
            }
            bufferedReader.close();
            in.close();
            string2 = sb.toString();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                QMUILangHelper.close(in);
                throw throwable;
            }
            QMUILangHelper.close(in);
            return null;
        }
        QMUILangHelper.close(in);
        return string2;
    }
}

