/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.textview;

import android.content.Context;
import android.graphics.Canvas;
import android.text.Spannable;
import android.text.method.MovementMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatTextView;
import com.qmuiteam.qmui.layout.IQMUILayout;
import com.qmuiteam.qmui.layout.QMUILayoutHelper;
import com.qmuiteam.qmui.link.QMUILinkTouchMovementMethod;
import com.qmuiteam.qmui.widget.textview.ISpanTouchFix;

public class QMUISpanTouchFixTextView
extends AppCompatTextView
implements ISpanTouchFix,
IQMUILayout {
    private boolean mTouchSpanHit;
    private boolean mIsPressedRecord = false;
    private boolean mNeedForceEventToParent = false;
    private QMUILayoutHelper mLayoutHelper;

    public QMUISpanTouchFixTextView(Context context) {
        this(context, null);
    }

    public QMUISpanTouchFixTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUISpanTouchFixTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setHighlightColor(0);
        this.mLayoutHelper = new QMUILayoutHelper(context, attrs, defStyleAttr, (View)this);
    }

    public void setNeedForceEventToParent(boolean needForceEventToParent) {
        this.mNeedForceEventToParent = needForceEventToParent;
        this.setFocusable(!needForceEventToParent);
        this.setClickable(!needForceEventToParent);
        this.setLongClickable(!needForceEventToParent);
    }

    public void setMovementMethodDefault() {
        this.setMovementMethodCompat(QMUILinkTouchMovementMethod.getInstance());
    }

    public void setMovementMethodCompat(MovementMethod movement) {
        this.setMovementMethod(movement);
        if (this.mNeedForceEventToParent) {
            this.setNeedForceEventToParent(true);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!(this.getText() instanceof Spannable) || !(this.getMovementMethod() instanceof QMUILinkTouchMovementMethod)) {
            this.mTouchSpanHit = false;
            return super.onTouchEvent(event);
        }
        this.mTouchSpanHit = true;
        boolean ret = super.onTouchEvent(event);
        if (this.mNeedForceEventToParent) {
            return this.mTouchSpanHit;
        }
        return ret;
    }

    @Override
    public void setTouchSpanHit(boolean hit) {
        if (this.mTouchSpanHit != hit) {
            this.mTouchSpanHit = hit;
            this.setPressed(this.mIsPressedRecord);
        }
    }

    public boolean performClick() {
        if (!this.mTouchSpanHit && !this.mNeedForceEventToParent) {
            return super.performClick();
        }
        return false;
    }

    public boolean performLongClick() {
        if (!this.mTouchSpanHit && !this.mNeedForceEventToParent) {
            return super.performLongClick();
        }
        return false;
    }

    public final void setPressed(boolean pressed) {
        this.mIsPressedRecord = pressed;
        if (!this.mTouchSpanHit) {
            this.onSetPressed(pressed);
        }
    }

    protected void onSetPressed(boolean pressed) {
        super.setPressed(pressed);
    }

    @Override
    public void updateTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mLayoutHelper.updateTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.invalidate();
    }

    @Override
    public void updateBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mLayoutHelper.updateBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.invalidate();
    }

    @Override
    public void updateLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLayoutHelper.updateLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.invalidate();
    }

    @Override
    public void updateRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mLayoutHelper.updateRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowTopDivider(int topInsetLeft, int topInsetRight, int topDividerHeight, int topDividerColor) {
        this.mLayoutHelper.onlyShowTopDivider(topInsetLeft, topInsetRight, topDividerHeight, topDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowBottomDivider(int bottomInsetLeft, int bottomInsetRight, int bottomDividerHeight, int bottomDividerColor) {
        this.mLayoutHelper.onlyShowBottomDivider(bottomInsetLeft, bottomInsetRight, bottomDividerHeight, bottomDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowLeftDivider(int leftInsetTop, int leftInsetBottom, int leftDividerWidth, int leftDividerColor) {
        this.mLayoutHelper.onlyShowLeftDivider(leftInsetTop, leftInsetBottom, leftDividerWidth, leftDividerColor);
        this.invalidate();
    }

    @Override
    public void onlyShowRightDivider(int rightInsetTop, int rightInsetBottom, int rightDividerWidth, int rightDividerColor) {
        this.mLayoutHelper.onlyShowRightDivider(rightInsetTop, rightInsetBottom, rightDividerWidth, rightDividerColor);
        this.invalidate();
    }

    @Override
    public void setTopDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setTopDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setBottomDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setBottomDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setLeftDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setLeftDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setRightDividerAlpha(int dividerAlpha) {
        this.mLayoutHelper.setRightDividerAlpha(dividerAlpha);
        this.invalidate();
    }

    @Override
    public void setHideRadiusSide(int hideRadiusSide) {
        this.mLayoutHelper.setHideRadiusSide(hideRadiusSide);
        this.invalidate();
    }

    @Override
    public int getHideRadiusSide() {
        return this.mLayoutHelper.getHideRadiusSide();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        widthMeasureSpec = this.mLayoutHelper.getMeasuredWidthSpec(widthMeasureSpec);
        heightMeasureSpec = this.mLayoutHelper.getMeasuredHeightSpec(heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int minW = this.mLayoutHelper.handleMiniWidth(widthMeasureSpec, this.getMeasuredWidth());
        int minH = this.mLayoutHelper.handleMiniHeight(heightMeasureSpec, this.getMeasuredHeight());
        if (widthMeasureSpec != minW || heightMeasureSpec != minH) {
            super.onMeasure(minW, minH);
        }
    }

    @Override
    public void setRadiusAndShadow(int radius, int shadowElevation, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, shadowAlpha);
    }

    @Override
    public void setRadiusAndShadow(int radius, int hideRadiusSide, int shadowElevation, int shadowColor, float shadowAlpha) {
        this.mLayoutHelper.setRadiusAndShadow(radius, hideRadiusSide, shadowElevation, shadowColor, shadowAlpha);
    }

    @Override
    public void setRadius(int radius) {
        this.mLayoutHelper.setRadius(radius);
    }

    @Override
    public void setRadius(int radius, int hideRadiusSide) {
        this.mLayoutHelper.setRadius(radius, hideRadiusSide);
    }

    @Override
    public int getRadius() {
        return this.mLayoutHelper.getRadius();
    }

    @Override
    public void setOutlineInset(int left, int top, int right, int bottom) {
        this.mLayoutHelper.setOutlineInset(left, top, right, bottom);
    }

    @Override
    public void setBorderColor(@ColorInt int borderColor) {
        this.mLayoutHelper.setBorderColor(borderColor);
        this.invalidate();
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.mLayoutHelper.setBorderWidth(borderWidth);
        this.invalidate();
    }

    @Override
    public void setShowBorderOnlyBeforeL(boolean showBorderOnlyBeforeL) {
        this.mLayoutHelper.setShowBorderOnlyBeforeL(showBorderOnlyBeforeL);
        this.invalidate();
    }

    @Override
    public boolean setWidthLimit(int widthLimit) {
        if (this.mLayoutHelper.setWidthLimit(widthLimit)) {
            this.requestLayout();
            this.invalidate();
        }
        return true;
    }

    @Override
    public boolean setHeightLimit(int heightLimit) {
        if (this.mLayoutHelper.setHeightLimit(heightLimit)) {
            this.requestLayout();
            this.invalidate();
        }
        return true;
    }

    @Override
    public void setUseThemeGeneralShadowElevation() {
        this.mLayoutHelper.setUseThemeGeneralShadowElevation();
    }

    @Override
    public void setOutlineExcludePadding(boolean outlineExcludePadding) {
        this.mLayoutHelper.setOutlineExcludePadding(outlineExcludePadding);
    }

    @Override
    public void setShadowElevation(int elevation) {
        this.mLayoutHelper.setShadowElevation(elevation);
    }

    @Override
    public int getShadowElevation() {
        return this.mLayoutHelper.getShadowElevation();
    }

    @Override
    public void setShadowAlpha(float shadowAlpha) {
        this.mLayoutHelper.setShadowAlpha(shadowAlpha);
    }

    @Override
    public float getShadowAlpha() {
        return this.mLayoutHelper.getShadowAlpha();
    }

    @Override
    public void setShadowColor(int shadowColor) {
        this.mLayoutHelper.setShadowColor(shadowColor);
    }

    @Override
    public int getShadowColor() {
        return this.mLayoutHelper.getShadowColor();
    }

    @Override
    public void setOuterNormalColor(int color2) {
        this.mLayoutHelper.setOuterNormalColor(color2);
    }

    @Override
    public void updateBottomSeparatorColor(int color2) {
        this.mLayoutHelper.updateBottomSeparatorColor(color2);
    }

    @Override
    public void updateLeftSeparatorColor(int color2) {
        this.mLayoutHelper.updateLeftSeparatorColor(color2);
    }

    @Override
    public void updateRightSeparatorColor(int color2) {
        this.mLayoutHelper.updateRightSeparatorColor(color2);
    }

    @Override
    public void updateTopSeparatorColor(int color2) {
        this.mLayoutHelper.updateTopSeparatorColor(color2);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        this.mLayoutHelper.drawDividers(canvas, this.getWidth(), this.getHeight());
        this.mLayoutHelper.dispatchRoundBorderDraw(canvas);
    }

    @Override
    public boolean hasBorder() {
        return this.mLayoutHelper.hasBorder();
    }

    @Override
    public boolean hasLeftSeparator() {
        return this.mLayoutHelper.hasLeftSeparator();
    }

    @Override
    public boolean hasTopSeparator() {
        return this.mLayoutHelper.hasTopSeparator();
    }

    @Override
    public boolean hasRightSeparator() {
        return this.mLayoutHelper.hasRightSeparator();
    }

    @Override
    public boolean hasBottomSeparator() {
        return this.mLayoutHelper.hasBottomSeparator();
    }
}

