/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.tab;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.viewpager2.widget.ViewPager2;
import com.qmuiteam.qmui.widget.tab.QMUIBasicTabSegment;
import java.lang.ref.WeakReference;

public class QMUITabSegment2
extends QMUIBasicTabSegment {
    private static final String TAG = "QMUITabSegment";
    private int mViewPagerScrollState = 0;
    private ViewPager2 mViewPager;
    private ViewPager2.OnPageChangeCallback mOnPageChangeListener;
    private QMUIBasicTabSegment.OnTabSelectedListener mViewPagerSelectedListener;

    public QMUITabSegment2(Context context) {
        super(context);
    }

    public QMUITabSegment2(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public QMUITabSegment2(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected boolean needPreventEvent() {
        return this.mViewPagerScrollState != 0;
    }

    public void setupWithViewPager(@Nullable ViewPager2 viewPager) {
        if (this.mViewPager != null && this.mOnPageChangeListener != null) {
            this.mViewPager.unregisterOnPageChangeCallback(this.mOnPageChangeListener);
        }
        if (this.mViewPagerSelectedListener != null) {
            this.removeOnTabSelectedListener(this.mViewPagerSelectedListener);
            this.mViewPagerSelectedListener = null;
        }
        if (viewPager != null) {
            this.mViewPager = viewPager;
            if (this.mOnPageChangeListener == null) {
                this.mOnPageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            viewPager.registerOnPageChangeCallback(this.mOnPageChangeListener);
            this.mViewPagerSelectedListener = new ViewPagerOnTabSelectedListener(viewPager);
            this.addOnTabSelectedListener(this.mViewPagerSelectedListener);
            int curItem = this.mViewPager.getCurrentItem();
            this.selectTab(curItem, true, false);
        } else {
            this.mViewPager = null;
        }
    }

    private void setViewPagerScrollState(int state) {
        this.mViewPagerScrollState = state;
        if (this.mViewPagerScrollState == 0 && this.mPendingSelectedIndex != -1 && this.mSelectAnimator == null) {
            this.selectTab(this.mPendingSelectedIndex, true, false);
            this.mPendingSelectedIndex = -1;
        }
    }

    private static class ViewPagerOnTabSelectedListener
    implements QMUIBasicTabSegment.OnTabSelectedListener {
        private final ViewPager2 mViewPager;

        public ViewPagerOnTabSelectedListener(ViewPager2 viewPager) {
            this.mViewPager = viewPager;
        }

        @Override
        public void onTabSelected(int index) {
            this.mViewPager.setCurrentItem(index, false);
        }

        @Override
        public void onTabUnselected(int index) {
        }

        @Override
        public void onTabReselected(int index) {
        }

        @Override
        public void onDoubleTap(int index) {
        }
    }

    public static class TabLayoutOnPageChangeListener
    extends ViewPager2.OnPageChangeCallback {
        private final WeakReference<QMUITabSegment2> mTabSegmentRef;

        public TabLayoutOnPageChangeListener(QMUITabSegment2 tabSegment) {
            this.mTabSegmentRef = new WeakReference<QMUITabSegment2>(tabSegment);
        }

        public void onPageScrollStateChanged(int state) {
            QMUITabSegment2 tabSegment = (QMUITabSegment2)this.mTabSegmentRef.get();
            if (tabSegment != null) {
                tabSegment.setViewPagerScrollState(state);
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            QMUITabSegment2 tabSegment = (QMUITabSegment2)this.mTabSegmentRef.get();
            if (tabSegment != null) {
                tabSegment.updateIndicatorPosition(position, positionOffset);
            }
        }

        public void onPageSelected(int position) {
            QMUITabSegment2 tabSegment = (QMUITabSegment2)this.mTabSegmentRef.get();
            if (tabSegment != null && tabSegment.mPendingSelectedIndex != -1) {
                tabSegment.mPendingSelectedIndex = position;
                return;
            }
            if (tabSegment != null && tabSegment.getSelectedIndex() != position && position < tabSegment.getTabCount()) {
                tabSegment.selectTab(position, true, false);
            }
        }
    }
}

