/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.tab;

import android.content.Context;
import android.database.DataSetObserver;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.qmuiteam.qmui.widget.tab.QMUIBasicTabSegment;
import java.lang.ref.WeakReference;

public class QMUITabSegment
extends QMUIBasicTabSegment {
    private static final String TAG = "QMUITabSegment";
    private int mViewPagerScrollState = 0;
    private ViewPager mViewPager;
    private PagerAdapter mPagerAdapter;
    private DataSetObserver mPagerAdapterObserver;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private OnTabSelectedListener mViewPagerSelectedListener;
    private AdapterChangeListener mAdapterChangeListener;

    public QMUITabSegment(Context context) {
        super(context);
    }

    public QMUITabSegment(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public QMUITabSegment(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected boolean needPreventEvent() {
        return this.mViewPagerScrollState != 0;
    }

    @Override
    public void notifyDataChanged() {
        super.notifyDataChanged();
        this.populateFromPagerAdapter(false);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager) {
        this.setupWithViewPager(viewPager, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean useAdapterTitle) {
        this.setupWithViewPager(viewPager, useAdapterTitle, true);
    }

    public void setupWithViewPager(@Nullable ViewPager viewPager, boolean useAdapterTitle, boolean autoRefresh) {
        if (this.mViewPager != null) {
            if (this.mOnPageChangeListener != null) {
                this.mViewPager.removeOnPageChangeListener(this.mOnPageChangeListener);
            }
            if (this.mAdapterChangeListener != null) {
                this.mViewPager.removeOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.mAdapterChangeListener);
            }
        }
        if (this.mViewPagerSelectedListener != null) {
            this.removeOnTabSelectedListener(this.mViewPagerSelectedListener);
            this.mViewPagerSelectedListener = null;
        }
        if (viewPager != null) {
            this.mViewPager = viewPager;
            if (this.mOnPageChangeListener == null) {
                this.mOnPageChangeListener = new TabLayoutOnPageChangeListener(this);
            }
            viewPager.addOnPageChangeListener(this.mOnPageChangeListener);
            this.mViewPagerSelectedListener = new ViewPagerOnTabSelectedListener(viewPager);
            this.addOnTabSelectedListener(this.mViewPagerSelectedListener);
            PagerAdapter adapter = viewPager.getAdapter();
            if (adapter != null) {
                this.setPagerAdapter(adapter, useAdapterTitle, autoRefresh);
            }
            if (this.mAdapterChangeListener == null) {
                this.mAdapterChangeListener = new AdapterChangeListener(useAdapterTitle);
            }
            this.mAdapterChangeListener.setAutoRefresh(autoRefresh);
            viewPager.addOnAdapterChangeListener((ViewPager.OnAdapterChangeListener)this.mAdapterChangeListener);
        } else {
            this.mViewPager = null;
            this.setPagerAdapter(null, false, false);
        }
    }

    private void setViewPagerScrollState(int state) {
        this.mViewPagerScrollState = state;
        if (this.mViewPagerScrollState == 0 && this.mPendingSelectedIndex != -1 && this.mSelectAnimator == null) {
            this.selectTab(this.mPendingSelectedIndex, true, false);
            this.mPendingSelectedIndex = -1;
        }
    }

    void populateFromPagerAdapter(boolean useAdapterTitle) {
        if (this.mPagerAdapter == null) {
            if (useAdapterTitle) {
                this.reset();
            }
            return;
        }
        int adapterCount = this.mPagerAdapter.getCount();
        if (useAdapterTitle) {
            this.reset();
            for (int i = 0; i < adapterCount; ++i) {
                this.addTab(this.mTabBuilder.setText(this.mPagerAdapter.getPageTitle(i)).build(this.getContext()));
            }
            super.notifyDataChanged();
        }
        if (this.mViewPager != null && adapterCount > 0) {
            int curItem = this.mViewPager.getCurrentItem();
            this.selectTab(curItem, true, false);
        }
    }

    void setPagerAdapter(@Nullable PagerAdapter adapter, boolean useAdapterTitle, boolean addObserver) {
        if (this.mPagerAdapter != null && this.mPagerAdapterObserver != null) {
            this.mPagerAdapter.unregisterDataSetObserver(this.mPagerAdapterObserver);
        }
        this.mPagerAdapter = adapter;
        if (addObserver && adapter != null) {
            if (this.mPagerAdapterObserver == null) {
                this.mPagerAdapterObserver = new PagerAdapterObserver(useAdapterTitle);
            }
            adapter.registerDataSetObserver(this.mPagerAdapterObserver);
        }
        this.populateFromPagerAdapter(useAdapterTitle);
    }

    @Deprecated
    public static interface OnTabSelectedListener
    extends QMUIBasicTabSegment.OnTabSelectedListener {
    }

    @Deprecated
    public static interface OnTabClickListener
    extends QMUIBasicTabSegment.OnTabClickListener {
    }

    private class PagerAdapterObserver
    extends DataSetObserver {
        private final boolean mUseAdapterTitle;

        PagerAdapterObserver(boolean useAdapterTitle) {
            this.mUseAdapterTitle = useAdapterTitle;
        }

        public void onChanged() {
            QMUITabSegment.this.populateFromPagerAdapter(this.mUseAdapterTitle);
        }

        public void onInvalidated() {
            QMUITabSegment.this.populateFromPagerAdapter(this.mUseAdapterTitle);
        }
    }

    private class AdapterChangeListener
    implements ViewPager.OnAdapterChangeListener {
        private boolean mAutoRefresh;
        private final boolean mUseAdapterTitle;

        AdapterChangeListener(boolean useAdapterTitle) {
            this.mUseAdapterTitle = useAdapterTitle;
        }

        public void onAdapterChanged(@NonNull ViewPager viewPager, @Nullable PagerAdapter oldAdapter, @Nullable PagerAdapter newAdapter) {
            if (QMUITabSegment.this.mViewPager == viewPager) {
                QMUITabSegment.this.setPagerAdapter(newAdapter, this.mUseAdapterTitle, this.mAutoRefresh);
            }
        }

        void setAutoRefresh(boolean autoRefresh) {
            this.mAutoRefresh = autoRefresh;
        }
    }

    private static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager mViewPager;

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        @Override
        public void onTabSelected(int index) {
            this.mViewPager.setCurrentItem(index, false);
        }

        @Override
        public void onTabUnselected(int index) {
        }

        @Override
        public void onTabReselected(int index) {
        }

        @Override
        public void onDoubleTap(int index) {
        }
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<QMUITabSegment> mTabSegmentRef;

        public TabLayoutOnPageChangeListener(QMUITabSegment tabSegment) {
            this.mTabSegmentRef = new WeakReference<QMUITabSegment>(tabSegment);
        }

        public void onPageScrollStateChanged(int state) {
            QMUITabSegment tabSegment = (QMUITabSegment)this.mTabSegmentRef.get();
            if (tabSegment != null) {
                tabSegment.setViewPagerScrollState(state);
            }
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            QMUITabSegment tabSegment = (QMUITabSegment)this.mTabSegmentRef.get();
            if (tabSegment != null) {
                tabSegment.updateIndicatorPosition(position, positionOffset);
            }
        }

        public void onPageSelected(int position) {
            QMUITabSegment tabSegment = (QMUITabSegment)this.mTabSegmentRef.get();
            if (tabSegment != null && tabSegment.mPendingSelectedIndex != -1) {
                tabSegment.mPendingSelectedIndex = position;
                return;
            }
            if (tabSegment != null && tabSegment.getSelectedIndex() != position && position < tabSegment.getTabCount()) {
                tabSegment.selectTab(position, true, false);
            }
        }
    }
}

