/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.tab;

import android.content.Context;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.tab.QMUITab;
import com.qmuiteam.qmui.widget.tab.QMUITabIcon;

public class QMUITabBuilder {
    private int normalDrawableAttr = 0;
    @Nullable
    private Drawable normalDrawable;
    private int selectedDrawableAttr = 0;
    @Nullable
    private Drawable selectedDrawable;
    private boolean dynamicChangeIconColor = false;
    private boolean skinChangeWithTintColor = false;
    private boolean skinChangeNormalWithTintColor = true;
    private boolean skinChangeSelectedWithTintColor = true;
    private int normalTextSize;
    private int selectTextSize;
    private int normalColorAttr = R.attr.qmui_skin_support_tab_normal_color;
    private int selectedColorAttr = R.attr.qmui_skin_support_tab_selected_color;
    private int normalColor = 0;
    private int selectColor = 0;
    private int iconPosition = 1;
    private int gravity = 17;
    private CharSequence text;
    private Typeface normalTypeface;
    private Typeface selectedTypeface;
    private int normalTabIconWidth = -1;
    int normalTabIconHeight = -1;
    float selectedTabIconScale = 1.0f;
    float typefaceUpdateAreaPercent = 0.25f;
    private int signCount = 0;
    private int signCountDigits = 2;
    private int signCountHorizontalOffset;
    private int signCountVerticalOffset;
    private int signCountVerticalAlign = 0;
    private int iconTextGap;
    private boolean allowIconDrawOutside = true;

    QMUITabBuilder(Context context) {
        this.iconTextGap = QMUIDisplayHelper.dp2px(context, 2);
        this.normalTextSize = this.selectTextSize = QMUIDisplayHelper.dp2px(context, 12);
        this.signCountVerticalOffset = this.signCountHorizontalOffset = QMUIDisplayHelper.dp2px(context, 3);
    }

    QMUITabBuilder(QMUITabBuilder other) {
        this.normalDrawableAttr = other.normalDrawableAttr;
        this.selectedDrawableAttr = other.selectedDrawableAttr;
        this.normalDrawable = other.normalDrawable;
        this.selectedDrawable = other.selectedDrawable;
        this.dynamicChangeIconColor = other.dynamicChangeIconColor;
        this.normalTextSize = other.normalTextSize;
        this.selectTextSize = other.selectTextSize;
        this.normalColorAttr = other.normalColorAttr;
        this.selectedColorAttr = other.selectedColorAttr;
        this.iconPosition = other.iconPosition;
        this.gravity = other.gravity;
        this.text = other.text;
        this.signCount = other.signCount;
        this.signCountDigits = other.signCountDigits;
        this.signCountHorizontalOffset = other.signCountHorizontalOffset;
        this.signCountVerticalOffset = other.signCountVerticalOffset;
        this.signCountVerticalAlign = other.signCountVerticalAlign;
        this.normalTypeface = other.normalTypeface;
        this.selectedTypeface = other.selectedTypeface;
        this.normalTabIconWidth = other.normalTabIconWidth;
        this.normalTabIconHeight = other.normalTabIconHeight;
        this.selectedTabIconScale = other.selectedTabIconScale;
        this.iconTextGap = other.iconTextGap;
        this.allowIconDrawOutside = other.allowIconDrawOutside;
        this.typefaceUpdateAreaPercent = other.typefaceUpdateAreaPercent;
        this.skinChangeNormalWithTintColor = other.skinChangeNormalWithTintColor;
        this.skinChangeSelectedWithTintColor = other.skinChangeSelectedWithTintColor;
        this.skinChangeWithTintColor = other.skinChangeWithTintColor;
        this.normalColor = other.normalColor;
        this.selectColor = other.selectColor;
    }

    public QMUITabBuilder setAllowIconDrawOutside(boolean allowIconDrawOutside) {
        this.allowIconDrawOutside = allowIconDrawOutside;
        return this;
    }

    public QMUITabBuilder setTypefaceUpdateAreaPercent(float typefaceUpdateAreaPercent) {
        this.typefaceUpdateAreaPercent = typefaceUpdateAreaPercent;
        return this;
    }

    public QMUITabBuilder setNormalDrawable(Drawable normalDrawable) {
        this.normalDrawable = normalDrawable;
        return this;
    }

    public QMUITabBuilder setNormalDrawableAttr(int normalDrawableAttr) {
        this.normalDrawableAttr = normalDrawableAttr;
        return this;
    }

    public QMUITabBuilder setSelectedDrawable(Drawable selectedDrawable) {
        this.selectedDrawable = selectedDrawable;
        return this;
    }

    public QMUITabBuilder setSelectedDrawableAttr(int selectedDrawableAttr) {
        this.selectedDrawableAttr = selectedDrawableAttr;
        return this;
    }

    @Deprecated
    public QMUITabBuilder skinChangeWithTintColor(boolean skinChangeWithTintColor) {
        this.skinChangeWithTintColor = skinChangeWithTintColor;
        return this;
    }

    public QMUITabBuilder skinChangeNormalWithTintColor(boolean skinChangeNormalWithTintColor) {
        this.skinChangeNormalWithTintColor = skinChangeNormalWithTintColor;
        return this;
    }

    public QMUITabBuilder skinChangeSelectedWithTintColor(boolean skinChangeSelectedWithTintColor) {
        this.skinChangeSelectedWithTintColor = skinChangeSelectedWithTintColor;
        return this;
    }

    public QMUITabBuilder setTextSize(int normalTextSize, int selectedTextSize) {
        this.normalTextSize = normalTextSize;
        this.selectTextSize = selectedTextSize;
        return this;
    }

    public QMUITabBuilder setTypeface(Typeface normalTypeface, Typeface selectedTypeface) {
        this.normalTypeface = normalTypeface;
        this.selectedTypeface = selectedTypeface;
        return this;
    }

    public QMUITabBuilder setNormalIconSizeInfo(int normalWidth, int normalHeight) {
        this.normalTabIconWidth = normalWidth;
        this.normalTabIconHeight = normalHeight;
        return this;
    }

    public QMUITabBuilder setSelectedIconScale(float selectedScale) {
        this.selectedTabIconScale = selectedScale;
        return this;
    }

    public QMUITabBuilder setIconTextGap(int iconTextGap) {
        this.iconTextGap = iconTextGap;
        return this;
    }

    public QMUITabBuilder setSignCount(int signCount) {
        this.signCount = signCount;
        return this;
    }

    public QMUITabBuilder setSignCountMarginInfo(int digit, int horizontalOffset, int verticalOffset) {
        return this.setSignCountMarginInfo(digit, horizontalOffset, 0, verticalOffset);
    }

    public QMUITabBuilder setSignCountMarginInfo(int digit, int horizontalOffset, int verticalAlign, int verticalOffset) {
        this.signCountDigits = digit;
        this.signCountHorizontalOffset = horizontalOffset;
        this.signCountVerticalOffset = verticalOffset;
        this.signCountVerticalAlign = verticalAlign;
        return this;
    }

    public QMUITabBuilder setColorAttr(int normalColorAttr, int selectedColorAttr) {
        this.normalColorAttr = normalColorAttr;
        this.selectedColorAttr = selectedColorAttr;
        return this;
    }

    public QMUITabBuilder setNormalColorAttr(int normalColorAttr) {
        this.normalColorAttr = normalColorAttr;
        return this;
    }

    public QMUITabBuilder setSelectedColorAttr(int selectedColorAttr) {
        this.selectedColorAttr = selectedColorAttr;
        return this;
    }

    public QMUITabBuilder setColor(int normalColor, int selectColor) {
        this.normalColorAttr = 0;
        this.selectedColorAttr = 0;
        this.normalColor = normalColor;
        this.selectColor = selectColor;
        return this;
    }

    public QMUITabBuilder setNormalColor(int normalColor) {
        this.normalColorAttr = 0;
        this.normalColor = normalColor;
        return this;
    }

    public QMUITabBuilder setSelectColor(int selectColor) {
        this.selectedColorAttr = 0;
        this.selectColor = selectColor;
        return this;
    }

    public QMUITabBuilder setDynamicChangeIconColor(boolean dynamicChangeIconColor) {
        this.dynamicChangeIconColor = dynamicChangeIconColor;
        return this;
    }

    public QMUITabBuilder setGravity(int gravity) {
        this.gravity = gravity;
        return this;
    }

    public QMUITabBuilder setIconPosition(int iconPosition) {
        this.iconPosition = iconPosition;
        return this;
    }

    public QMUITabBuilder setText(CharSequence text) {
        this.text = text;
        return this;
    }

    public QMUITab build(Context context) {
        QMUITab tab = new QMUITab(this.text);
        if (!this.skinChangeWithTintColor) {
            if (!this.skinChangeNormalWithTintColor && this.normalDrawableAttr != 0) {
                this.normalDrawable = QMUIResHelper.getAttrDrawable(context, this.normalDrawableAttr);
            }
            if (!this.skinChangeSelectedWithTintColor && this.selectedDrawableAttr != 0) {
                this.selectedDrawable = QMUIResHelper.getAttrDrawable(context, this.selectedDrawableAttr);
            }
        }
        tab.skinChangeWithTintColor = this.skinChangeWithTintColor;
        tab.skinChangeNormalWithTintColor = this.skinChangeNormalWithTintColor;
        tab.skinChangeSelectedWithTintColor = this.skinChangeSelectedWithTintColor;
        if (this.normalDrawable != null) {
            if (this.dynamicChangeIconColor || this.selectedDrawable == null) {
                tab.tabIcon = new QMUITabIcon(this.normalDrawable, null, true);
                tab.skinChangeSelectedWithTintColor = tab.skinChangeNormalWithTintColor;
            } else {
                tab.tabIcon = new QMUITabIcon(this.normalDrawable, this.selectedDrawable, false);
            }
            tab.tabIcon.setBounds(0, 0, this.normalTabIconWidth, this.normalTabIconHeight);
        }
        tab.normalIconAttr = this.normalDrawableAttr;
        tab.selectedIconAttr = this.selectedDrawableAttr;
        tab.normalTabIconWidth = this.normalTabIconWidth;
        tab.normalTabIconHeight = this.normalTabIconHeight;
        tab.selectedTabIconScale = this.selectedTabIconScale;
        tab.gravity = this.gravity;
        tab.iconPosition = this.iconPosition;
        tab.normalTextSize = this.normalTextSize;
        tab.selectedTextSize = this.selectTextSize;
        tab.normalTypeface = this.normalTypeface;
        tab.selectedTypeface = this.selectedTypeface;
        tab.normalColorAttr = this.normalColorAttr;
        tab.selectedColorAttr = this.selectedColorAttr;
        tab.normalColor = this.normalColor;
        tab.selectColor = this.selectColor;
        tab.signCount = this.signCount;
        tab.signCountDigits = this.signCountDigits;
        tab.signCountHorizontalOffset = this.signCountHorizontalOffset;
        tab.signCountVerticalAlign = this.signCountVerticalAlign;
        tab.signCountVerticalOffset = this.signCountVerticalOffset;
        tab.iconTextGap = this.iconTextGap;
        tab.typefaceUpdateAreaPercent = this.typefaceUpdateAreaPercent;
        return tab;
    }
}

