/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.roundwidget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaButton;
import com.qmuiteam.qmui.skin.defaultAttr.IQMUISkinDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.roundwidget.QMUIRoundButtonDrawable;

public class QMUIRoundButton
extends QMUIAlphaButton
implements IQMUISkinDefaultAttrProvider {
    private QMUIRoundButtonDrawable mRoundBg;
    private static SimpleArrayMap<String, Integer> sDefaultSkinAttrs = new SimpleArrayMap(3);

    public QMUIRoundButton(Context context) {
        super(context);
        this.init(context, null, 0);
    }

    public QMUIRoundButton(Context context, AttributeSet attrs) {
        super(context, attrs, R.attr.QMUIButtonStyle);
        this.init(context, attrs, R.attr.QMUIButtonStyle);
    }

    public QMUIRoundButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mRoundBg = QMUIRoundButtonDrawable.fromAttributeSet(context, attrs, defStyleAttr);
        QMUIViewHelper.setBackgroundKeepingPadding((View)this, (Drawable)this.mRoundBg);
        this.setChangeAlphaWhenDisable(false);
        this.setChangeAlphaWhenPress(false);
    }

    public void setBackgroundColor(int color2) {
        this.mRoundBg.setBgData(ColorStateList.valueOf((int)color2));
    }

    public void setBgData(@Nullable ColorStateList colors) {
        this.mRoundBg.setBgData(colors);
    }

    public void setStrokeData(int width, @Nullable ColorStateList colors) {
        this.mRoundBg.setStrokeData(width, colors);
    }

    public int getStrokeWidth() {
        return this.mRoundBg.getStrokeWidth();
    }

    public void setStrokeColors(ColorStateList colors) {
        this.mRoundBg.setStrokeColors(colors);
    }

    @Override
    public SimpleArrayMap<String, Integer> getDefaultSkinAttrs() {
        return sDefaultSkinAttrs;
    }

    static {
        sDefaultSkinAttrs.put((Object)"background", (Object)R.attr.qmui_skin_support_round_btn_bg_color);
        sDefaultSkinAttrs.put((Object)"border", (Object)R.attr.qmui_skin_support_round_btn_border_color);
        sDefaultSkinAttrs.put((Object)"textColor", (Object)R.attr.qmui_skin_support_round_btn_text_color);
    }
}

