/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.popup;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.alpha.QMUIAlphaImageButton;
import com.qmuiteam.qmui.layout.QMUIConstraintLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.IBlankTouchDetector;
import com.qmuiteam.qmui.widget.popup.QMUIBasePopup;
import java.util.ArrayList;

public class QMUIFullScreenPopup
extends QMUIBasePopup<QMUIFullScreenPopup> {
    private OnBlankClickListener mOnBlankClickListener;
    private boolean mAddCloseBtn = false;
    private int mCloseIconAttr = R.attr.qmui_skin_support_popup_close_icon;
    private Drawable mCloseIcon = null;
    private ConstraintLayout.LayoutParams mCloseIvLayoutParams;
    private int mAnimStyle = -1;
    private ArrayList<ViewInfo> mViews = new ArrayList();

    public QMUIFullScreenPopup(Context context) {
        super(context);
        this.mWindow.setWidth(-1);
        this.mWindow.setHeight(-1);
        this.mWindow.setSoftInputMode(16);
        this.dimAmount(0.6f);
    }

    public QMUIFullScreenPopup onBlankClick(OnBlankClickListener onBlankClickListener) {
        this.mOnBlankClickListener = onBlankClickListener;
        return this;
    }

    public QMUIFullScreenPopup closeBtn(boolean close) {
        this.mAddCloseBtn = close;
        return this;
    }

    public QMUIFullScreenPopup closeIcon(Drawable drawable) {
        this.mCloseIcon = drawable;
        return this;
    }

    public QMUIFullScreenPopup closeIconAttr(int closeIconAttr) {
        this.mCloseIconAttr = closeIconAttr;
        return this;
    }

    public QMUIFullScreenPopup closeLp(ConstraintLayout.LayoutParams contentLayoutParams) {
        this.mCloseIvLayoutParams = contentLayoutParams;
        return this;
    }

    public int getCloseBtnId() {
        return R.id.qmui_popup_close_btn_id;
    }

    public QMUIFullScreenPopup animStyle(int animStyle) {
        this.mAnimStyle = animStyle;
        return this;
    }

    public QMUIFullScreenPopup addView(View view, ConstraintLayout.LayoutParams lp) {
        this.mViews.add(new ViewInfo(view, lp));
        return this;
    }

    public QMUIFullScreenPopup addView(View view) {
        this.mViews.add(new ViewInfo(view, this.defaultContentLp()));
        return this;
    }

    private ConstraintLayout.LayoutParams defaultContentLp() {
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(-2, -2);
        lp.leftToLeft = 0;
        lp.rightToRight = 0;
        lp.topToTop = 0;
        lp.bottomToBottom = 0;
        return lp;
    }

    private ConstraintLayout.LayoutParams defaultCloseIvLp() {
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(-2, -2);
        lp.leftToLeft = 0;
        lp.rightToRight = 0;
        lp.bottomToBottom = 0;
        lp.bottomMargin = QMUIDisplayHelper.dp2px(this.mContext, 48);
        return lp;
    }

    private QMUIAlphaImageButton createCloseIv() {
        QMUIAlphaImageButton closeBtn = new QMUIAlphaImageButton(this.mContext);
        closeBtn.setPadding(0, 0, 0, 0);
        closeBtn.setScaleType(ImageView.ScaleType.CENTER);
        closeBtn.setId(R.id.qmui_popup_close_btn_id);
        closeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QMUIFullScreenPopup.this.dismiss();
            }
        });
        closeBtn.setFitsSystemWindows(true);
        Drawable drawable = null;
        if (this.mCloseIcon != null) {
            drawable = this.mCloseIcon;
        } else if (this.mCloseIconAttr != 0) {
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire().src(this.mCloseIconAttr);
            QMUISkinHelper.setSkinValue((View)closeBtn, builder);
            builder.release();
            drawable = QMUIResHelper.getAttrDrawable(this.mContext, this.mCloseIconAttr);
        }
        closeBtn.setImageDrawable(drawable);
        return closeBtn;
    }

    public boolean isShowing() {
        return this.mWindow.isShowing();
    }

    public void show(View parent) {
        if (this.isShowing()) {
            return;
        }
        if (this.mViews.isEmpty()) {
            throw new RuntimeException("you should call addView() to add content view");
        }
        ArrayList<ViewInfo> views = new ArrayList<ViewInfo>(this.mViews);
        RootView rootView = new RootView(this.mContext);
        for (int i = 0; i < views.size(); ++i) {
            ViewInfo info = this.mViews.get(i);
            View view = info.view;
            if (view.getParent() != null) {
                ((ViewGroup)view.getParent()).removeView(view);
            }
            rootView.addView(view, (ViewGroup.LayoutParams)info.lp);
        }
        if (this.mAddCloseBtn) {
            if (this.mCloseIvLayoutParams == null) {
                this.mCloseIvLayoutParams = this.defaultCloseIvLp();
            }
            rootView.addView((View)this.createCloseIv(), (ViewGroup.LayoutParams)this.mCloseIvLayoutParams);
        }
        this.mWindow.setContentView((View)rootView);
        if (this.mAnimStyle != -1) {
            this.mWindow.setAnimationStyle(this.mAnimStyle);
        }
        this.showAtLocation(parent, 0, 0);
    }

    @Override
    protected void modifyWindowLayoutParams(WindowManager.LayoutParams lp) {
        lp.flags |= 0x10100;
        super.modifyWindowLayoutParams(lp);
    }

    class ViewInfo {
        private View view;
        private ConstraintLayout.LayoutParams lp;

        public ViewInfo(View view, ConstraintLayout.LayoutParams lp) {
            this.view = view;
            this.lp = lp;
        }
    }

    class RootView
    extends QMUIConstraintLayout {
        private boolean mShouldInvokeBlackClickWhenTouchUp;

        public RootView(Context context) {
            super(context);
            this.mShouldInvokeBlackClickWhenTouchUp = false;
        }

        public boolean onTouchEvent(MotionEvent event) {
            int action = event.getActionMasked();
            if (QMUIFullScreenPopup.this.mOnBlankClickListener == null) {
                return true;
            }
            if (action == 0) {
                this.mShouldInvokeBlackClickWhenTouchUp = this.isTouchInBlack(event);
            } else if (action == 2) {
                this.mShouldInvokeBlackClickWhenTouchUp = this.mShouldInvokeBlackClickWhenTouchUp && this.isTouchInBlack(event);
            } else if (action == 1 || action == 3) {
                boolean bl = this.mShouldInvokeBlackClickWhenTouchUp = this.mShouldInvokeBlackClickWhenTouchUp && this.isTouchInBlack(event);
                if (this.mShouldInvokeBlackClickWhenTouchUp) {
                    QMUIFullScreenPopup.this.mOnBlankClickListener.onBlankClick(QMUIFullScreenPopup.this);
                }
            }
            return true;
        }

        private boolean isTouchInBlack(MotionEvent event) {
            boolean isBlank;
            View childView = this.findChildViewUnder(event.getX(), event.getY());
            boolean bl = isBlank = childView == null;
            if (!isBlank && childView instanceof IBlankTouchDetector) {
                MotionEvent e = MotionEvent.obtain((MotionEvent)event);
                int offsetX = this.getScrollX() - childView.getLeft();
                int offsetY = this.getScrollY() - childView.getTop();
                e.offsetLocation((float)offsetX, (float)offsetY);
                isBlank = ((IBlankTouchDetector)childView).isTouchInBlank(e);
                e.recycle();
            }
            return isBlank;
        }

        private View findChildViewUnder(float x, float y) {
            int count = this.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = this.getChildAt(i);
                float translationX = child.getTranslationX();
                float translationY = child.getTranslationY();
                if (!(x >= (float)child.getLeft() + translationX) || !(x <= (float)child.getRight() + translationX) || !(y >= (float)child.getTop() + translationY) || !(y <= (float)child.getBottom() + translationY)) continue;
                return child;
            }
            return null;
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            super.onLayout(changed, left, top, right, bottom);
            for (ViewInfo viewInfo : QMUIFullScreenPopup.this.mViews) {
                View view = viewInfo.view;
                QMUIViewHelper.getOrCreateOffsetHelper(view).onViewLayout();
            }
        }
    }

    public static interface OnBlankClickListener {
        public void onBlankClick(QMUIFullScreenPopup var1);
    }
}

