/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.grouplist;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.widget.grouplist.QMUICommonListItemView;
import com.qmuiteam.qmui.widget.grouplist.QMUIGroupListSectionHeaderFooterView;

public class QMUIGroupListView
extends LinearLayout {
    private SparseArray<Section> mSections = new SparseArray();

    public QMUIGroupListView(Context context) {
        this(context, null);
    }

    public QMUIGroupListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public QMUIGroupListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
    }

    public static Section newSection(Context context) {
        return new Section(context);
    }

    public int getSectionCount() {
        return this.mSections.size();
    }

    public QMUICommonListItemView createItemView(@Nullable Drawable imageDrawable, CharSequence titleText, String detailText, int orientation, int accessoryType, int height) {
        QMUICommonListItemView itemView = new QMUICommonListItemView(this.getContext());
        itemView.setOrientation(orientation);
        itemView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, height));
        itemView.setImageDrawable(imageDrawable);
        itemView.setText(titleText);
        itemView.setDetailText(detailText);
        itemView.setAccessoryType(accessoryType);
        return itemView;
    }

    public QMUICommonListItemView createItemView(@Nullable Drawable imageDrawable, CharSequence titleText, String detailText, int orientation, int accessoryType) {
        if (orientation == 0) {
            int height = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_list_item_height_higher);
            return this.createItemView(imageDrawable, titleText, detailText, orientation, accessoryType, height);
        }
        int height = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_list_item_height);
        return this.createItemView(imageDrawable, titleText, detailText, orientation, accessoryType, height);
    }

    public QMUICommonListItemView createItemView(CharSequence titleText) {
        return this.createItemView(null, titleText, null, 1, 0);
    }

    public QMUICommonListItemView createItemView(int orientation) {
        return this.createItemView(null, null, null, orientation, 0);
    }

    private void addSection(Section section) {
        this.mSections.append(this.mSections.size(), (Object)section);
    }

    private void removeSection(Section section) {
        for (int i = 0; i < this.mSections.size(); ++i) {
            Section each = (Section)this.mSections.valueAt(i);
            if (each != section) continue;
            this.mSections.remove(i);
        }
    }

    public Section getSection(int index) {
        return (Section)this.mSections.get(index);
    }

    public static class Section {
        private Context mContext;
        private QMUIGroupListSectionHeaderFooterView mTitleView;
        private QMUIGroupListSectionHeaderFooterView mDescriptionView;
        private SparseArray<QMUICommonListItemView> mItemViews;
        private boolean mUseDefaultTitleIfNone;
        private boolean mUseTitleViewForSectionSpace = true;
        private int mSeparatorColorAttr = R.attr.qmui_skin_support_common_list_separator_color;
        private boolean mHandleSeparatorCustom = false;
        private boolean mShowSeparator = true;
        private boolean mOnlyShowStartEndSeparator = false;
        private boolean mOnlyShowMiddleSeparator = false;
        private int mMiddleSeparatorInsetLeft = 0;
        private int mMiddleSeparatorInsetRight = 0;
        private int mBgAttr = R.attr.qmui_skin_support_s_common_list_bg;
        private int mLeftIconWidth = -2;
        private int mLeftIconHeight = -2;

        public Section(Context context) {
            this.mContext = context;
            this.mItemViews = new SparseArray();
        }

        public Section addItemView(QMUICommonListItemView itemView, View.OnClickListener onClickListener) {
            return this.addItemView(itemView, onClickListener, null);
        }

        public Section addItemView(QMUICommonListItemView itemView, View.OnClickListener onClickListener, View.OnLongClickListener onLongClickListener) {
            if (onClickListener != null) {
                itemView.setOnClickListener(onClickListener);
            }
            if (onLongClickListener != null) {
                itemView.setOnLongClickListener(onLongClickListener);
            }
            this.mItemViews.append(this.mItemViews.size(), (Object)itemView);
            return this;
        }

        public Section setTitle(CharSequence title) {
            this.mTitleView = this.createSectionHeader(title);
            return this;
        }

        public Section setDescription(CharSequence description) {
            this.mDescriptionView = this.createSectionFooter(description);
            return this;
        }

        public Section setUseDefaultTitleIfNone(boolean useDefaultTitleIfNone) {
            this.mUseDefaultTitleIfNone = useDefaultTitleIfNone;
            return this;
        }

        public Section setUseTitleViewForSectionSpace(boolean useTitleViewForSectionSpace) {
            this.mUseTitleViewForSectionSpace = useTitleViewForSectionSpace;
            return this;
        }

        public Section setLeftIconSize(int width, int height) {
            this.mLeftIconHeight = height;
            this.mLeftIconWidth = width;
            return this;
        }

        public Section setSeparatorColorAttr(int attr2) {
            this.mSeparatorColorAttr = attr2;
            return this;
        }

        public Section setHandleSeparatorCustom(boolean handleSeparatorCustom) {
            this.mHandleSeparatorCustom = handleSeparatorCustom;
            return this;
        }

        public Section setShowSeparator(boolean showSeparator) {
            this.mShowSeparator = showSeparator;
            return this;
        }

        public Section setOnlyShowStartEndSeparator(boolean onlyShowStartEndSeparator) {
            this.mOnlyShowStartEndSeparator = onlyShowStartEndSeparator;
            return this;
        }

        public Section setOnlyShowMiddleSeparator(boolean onlyShowMiddleSeparator) {
            this.mOnlyShowMiddleSeparator = onlyShowMiddleSeparator;
            return this;
        }

        public Section setMiddleSeparatorInset(int insetLeft, int insetRight) {
            this.mMiddleSeparatorInsetLeft = insetLeft;
            this.mMiddleSeparatorInsetRight = insetRight;
            return this;
        }

        public Section setBgAttr(int bgAttr) {
            this.mBgAttr = bgAttr;
            return this;
        }

        public void addTo(QMUIGroupListView groupListView) {
            if (this.mTitleView == null) {
                if (this.mUseDefaultTitleIfNone) {
                    this.setTitle("Section " + groupListView.getSectionCount());
                } else if (this.mUseTitleViewForSectionSpace) {
                    this.setTitle("");
                }
            }
            if (this.mTitleView != null) {
                groupListView.addView((View)this.mTitleView);
            }
            int itemViewCount = this.mItemViews.size();
            QMUICommonListItemView.LayoutParamConfig leftIconLpConfig = new QMUICommonListItemView.LayoutParamConfig(){

                @Override
                public ConstraintLayout.LayoutParams onConfig(ConstraintLayout.LayoutParams lp) {
                    lp.width = Section.this.mLeftIconWidth;
                    lp.height = Section.this.mLeftIconHeight;
                    return lp;
                }
            };
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
            String skin = builder.background(this.mBgAttr).topSeparator(this.mSeparatorColorAttr).bottomSeparator(this.mSeparatorColorAttr).build();
            QMUISkinValueBuilder.release(builder);
            int separatorColor = QMUIResHelper.getAttrColor(groupListView.getContext(), this.mSeparatorColorAttr);
            for (int i = 0; i < itemViewCount; ++i) {
                QMUICommonListItemView itemView = (QMUICommonListItemView)this.mItemViews.get(i);
                Drawable bg = QMUISkinHelper.getSkinDrawable((View)groupListView, this.mBgAttr);
                QMUIViewHelper.setBackgroundKeepingPadding((View)itemView, bg == null ? null : bg.mutate());
                QMUISkinHelper.setSkinValue((View)itemView, skin);
                if (!this.mHandleSeparatorCustom && this.mShowSeparator) {
                    if (itemViewCount == 1) {
                        itemView.updateTopDivider(0, 0, 1, separatorColor);
                        itemView.updateBottomDivider(0, 0, 1, separatorColor);
                    } else if (i == 0) {
                        if (!this.mOnlyShowMiddleSeparator) {
                            itemView.updateTopDivider(0, 0, 1, separatorColor);
                        }
                        if (!this.mOnlyShowStartEndSeparator) {
                            itemView.updateBottomDivider(this.mMiddleSeparatorInsetLeft, this.mMiddleSeparatorInsetRight, 1, separatorColor);
                        }
                    } else if (i == itemViewCount - 1) {
                        if (!this.mOnlyShowMiddleSeparator) {
                            itemView.updateBottomDivider(0, 0, 1, separatorColor);
                        }
                    } else if (!this.mOnlyShowStartEndSeparator) {
                        itemView.updateBottomDivider(this.mMiddleSeparatorInsetLeft, this.mMiddleSeparatorInsetRight, 1, separatorColor);
                    }
                }
                itemView.updateImageViewLp(leftIconLpConfig);
                groupListView.addView((View)itemView);
            }
            if (this.mDescriptionView != null) {
                groupListView.addView((View)this.mDescriptionView);
            }
            groupListView.addSection(this);
        }

        public void removeFrom(QMUIGroupListView parent) {
            if (this.mTitleView != null && this.mTitleView.getParent() == parent) {
                parent.removeView((View)this.mTitleView);
            }
            for (int i = 0; i < this.mItemViews.size(); ++i) {
                QMUICommonListItemView itemView = (QMUICommonListItemView)this.mItemViews.get(i);
                parent.removeView((View)itemView);
            }
            if (this.mDescriptionView != null && this.mDescriptionView.getParent() == parent) {
                parent.removeView((View)this.mDescriptionView);
            }
            parent.removeSection(this);
        }

        public QMUIGroupListSectionHeaderFooterView createSectionHeader(CharSequence titleText) {
            return new QMUIGroupListSectionHeaderFooterView(this.mContext, titleText);
        }

        public QMUIGroupListSectionHeaderFooterView createSectionFooter(CharSequence text) {
            return new QMUIGroupListSectionHeaderFooterView(this.mContext, text, true);
        }
    }
}

