/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIResHelper;

public class QMUITipDialogView
extends QMUILinearLayout {
    private final int mMaxWidth;
    private final int mMiniWidth;
    private final int mMiniHeight;

    public QMUITipDialogView(Context context) {
        super(context);
        this.setOrientation(1);
        this.setGravity(1);
        int radius = QMUIResHelper.getAttrDimen(context, R.attr.qmui_tip_dialog_radius);
        Drawable background = QMUIResHelper.getAttrDrawable(context, R.attr.qmui_skin_support_tip_dialog_bg);
        int paddingHor = QMUIResHelper.getAttrDimen(context, R.attr.qmui_tip_dialog_padding_horizontal);
        int paddingVer = QMUIResHelper.getAttrDimen(context, R.attr.qmui_tip_dialog_padding_vertical);
        this.setBackground(background);
        this.setPadding(paddingHor, paddingVer, paddingHor, paddingVer);
        this.setRadius(radius);
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        builder.background(R.attr.qmui_skin_support_tip_dialog_bg);
        QMUISkinHelper.setSkinValue((View)this, builder);
        builder.release();
        this.mMaxWidth = QMUIResHelper.getAttrDimen(context, R.attr.qmui_tip_dialog_max_width);
        this.mMiniWidth = QMUIResHelper.getAttrDimen(context, R.attr.qmui_tip_dialog_min_width);
        this.mMiniHeight = QMUIResHelper.getAttrDimen(context, R.attr.qmui_tip_dialog_min_height);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        if (widthSize > this.mMaxWidth) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)widthMode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        boolean needRemeasure = false;
        if (this.getMeasuredWidth() < this.mMiniWidth) {
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMiniWidth, (int)0x40000000);
            needRemeasure = true;
        }
        if (this.getMeasuredHeight() < this.mMiniHeight) {
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMiniHeight, (int)0x40000000);
            needRemeasure = true;
        }
        if (needRemeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

