/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.QMUILoadingView;
import com.qmuiteam.qmui.widget.dialog.QMUIBaseDialog;
import com.qmuiteam.qmui.widget.dialog.QMUITipDialogView;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class QMUITipDialog
extends QMUIBaseDialog {
    public QMUITipDialog(Context context) {
        this(context, R.style.QMUI_TipDialog);
    }

    public QMUITipDialog(Context context, int themeResId) {
        super(context, themeResId);
        this.setCanceledOnTouchOutside(false);
    }

    public static class CustomBuilder {
        private Context mContext;
        private int mContentLayoutId;
        private QMUISkinManager mSkinManager;

        public CustomBuilder(Context context) {
            this.mContext = context;
        }

        public CustomBuilder setSkinManager(@Nullable QMUISkinManager skinManager) {
            this.mSkinManager = skinManager;
            return this;
        }

        public CustomBuilder setContent(@LayoutRes int layoutId) {
            this.mContentLayoutId = layoutId;
            return this;
        }

        public QMUITipDialog create() {
            QMUITipDialog dialog = new QMUITipDialog(this.mContext);
            dialog.setSkinManager(this.mSkinManager);
            Context dialogContext = dialog.getContext();
            QMUITipDialogView tipDialogView = new QMUITipDialogView(dialogContext);
            LayoutInflater.from((Context)dialogContext).inflate(this.mContentLayoutId, (ViewGroup)tipDialogView, true);
            dialog.setContentView((View)tipDialogView);
            return dialog;
        }
    }

    public static class Builder {
        public static final int ICON_TYPE_NOTHING = 0;
        public static final int ICON_TYPE_LOADING = 1;
        public static final int ICON_TYPE_SUCCESS = 2;
        public static final int ICON_TYPE_FAIL = 3;
        public static final int ICON_TYPE_INFO = 4;
        private int mCurrentIconType = 0;
        private Context mContext;
        private CharSequence mTipWord;
        private QMUISkinManager mSkinManager;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setIconType(int iconType) {
            this.mCurrentIconType = iconType;
            return this;
        }

        public Builder setTipWord(CharSequence tipWord) {
            this.mTipWord = tipWord;
            return this;
        }

        public Builder setSkinManager(@Nullable QMUISkinManager skinManager) {
            this.mSkinManager = skinManager;
            return this;
        }

        public QMUITipDialog create() {
            return this.create(true);
        }

        public QMUITipDialog create(boolean cancelable) {
            return this.create(cancelable, R.style.QMUI_TipDialog);
        }

        public QMUITipDialog create(boolean cancelable, int style2) {
            QMUITipDialog dialog = new QMUITipDialog(this.mContext, style2);
            dialog.setCancelable(cancelable);
            dialog.setSkinManager(this.mSkinManager);
            Context dialogContext = dialog.getContext();
            QMUITipDialogView dialogView = new QMUITipDialogView(dialogContext);
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
            if (this.mCurrentIconType == 1) {
                QMUILoadingView loadingView = new QMUILoadingView(dialogContext);
                loadingView.setColor(QMUIResHelper.getAttrColor(dialogContext, R.attr.qmui_skin_support_tip_dialog_loading_color));
                loadingView.setSize(QMUIResHelper.getAttrDimen(dialogContext, R.attr.qmui_tip_dialog_loading_size));
                builder.tintColor(R.attr.qmui_skin_support_tip_dialog_loading_color);
                QMUISkinHelper.setSkinValue((View)loadingView, builder);
                dialogView.addView(loadingView, (ViewGroup.LayoutParams)this.onCreateIconOrLoadingLayoutParams(dialogContext));
            } else if (this.mCurrentIconType == 2 || this.mCurrentIconType == 3 || this.mCurrentIconType == 4) {
                Drawable drawable2;
                AppCompatImageView imageView = new AppCompatImageView(dialogContext);
                builder.clear();
                if (this.mCurrentIconType == 2) {
                    drawable2 = QMUIResHelper.getAttrDrawable(dialogContext, R.attr.qmui_skin_support_tip_dialog_icon_success_src);
                    builder.src(R.attr.qmui_skin_support_tip_dialog_icon_success_src);
                } else if (this.mCurrentIconType == 3) {
                    drawable2 = QMUIResHelper.getAttrDrawable(dialogContext, R.attr.qmui_skin_support_tip_dialog_icon_error_src);
                    builder.src(R.attr.qmui_skin_support_tip_dialog_icon_error_src);
                } else {
                    drawable2 = QMUIResHelper.getAttrDrawable(dialogContext, R.attr.qmui_skin_support_tip_dialog_icon_info_src);
                    builder.src(R.attr.qmui_skin_support_tip_dialog_icon_info_src);
                }
                imageView.setImageDrawable(drawable2);
                QMUISkinHelper.setSkinValue((View)imageView, builder);
                dialogView.addView((View)imageView, (ViewGroup.LayoutParams)this.onCreateIconOrLoadingLayoutParams(dialogContext));
            }
            if (this.mTipWord != null && this.mTipWord.length() > 0) {
                QMUISpanTouchFixTextView tipView = new QMUISpanTouchFixTextView(dialogContext);
                tipView.setEllipsize(TextUtils.TruncateAt.END);
                tipView.setId(R.id.qmui_tip_content_id);
                tipView.setGravity(17);
                tipView.setTextSize(0, QMUIResHelper.getAttrDimen(dialogContext, R.attr.qmui_tip_dialog_text_size));
                tipView.setTextColor(QMUIResHelper.getAttrColor(dialogContext, R.attr.qmui_skin_support_tip_dialog_text_color));
                tipView.setText(this.mTipWord);
                builder.clear();
                builder.textColor(R.attr.qmui_skin_support_tip_dialog_text_color);
                QMUISkinHelper.setSkinValue((View)tipView, builder);
                dialogView.addView((View)tipView, (ViewGroup.LayoutParams)this.onCreateTextLayoutParams(dialogContext, this.mCurrentIconType));
            }
            builder.release();
            dialog.setContentView((View)dialogView);
            return dialog;
        }

        protected LinearLayout.LayoutParams onCreateIconOrLoadingLayoutParams(Context context) {
            return new LinearLayout.LayoutParams(-2, -2);
        }

        protected LinearLayout.LayoutParams onCreateTextLayoutParams(Context context, int iconType) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
            if (iconType != 0) {
                lp.topMargin = QMUIResHelper.getAttrDimen(context, R.attr.qmui_tip_dialog_text_margin_top);
            }
            return lp;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IconType {
        }
    }
}

