/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIButton;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUISpanHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class QMUIDialogAction {
    public static final int ACTION_PROP_POSITIVE = 0;
    public static final int ACTION_PROP_NEUTRAL = 1;
    public static final int ACTION_PROP_NEGATIVE = 2;
    private CharSequence mStr;
    private int mIconRes = 0;
    private int mActionProp = 1;
    private int mSkinTextColorAttr = 0;
    private int mSkinBackgroundAttr = 0;
    private int mSkinIconTintColorAttr = 0;
    private int mSkinSeparatorColorAttr = R.attr.qmui_skin_support_dialog_action_divider_color;
    private ActionListener mOnClickListener;
    private QMUIButton mButton;
    private boolean mIsEnabled = true;

    public QMUIDialogAction(Context context, int strRes) {
        this(context.getResources().getString(strRes));
    }

    public QMUIDialogAction(CharSequence str) {
        this(str, null);
    }

    public QMUIDialogAction(Context context, int strRes, @Nullable ActionListener onClickListener) {
        this(context.getResources().getString(strRes), onClickListener);
    }

    public QMUIDialogAction(CharSequence str, @Nullable ActionListener onClickListener) {
        this.mStr = str;
        this.mOnClickListener = onClickListener;
    }

    public QMUIDialogAction prop(int actionProp) {
        this.mActionProp = actionProp;
        return this;
    }

    public QMUIDialogAction iconRes(int iconRes) {
        this.mIconRes = iconRes;
        return this;
    }

    public QMUIDialogAction onClick(ActionListener onClickListener) {
        this.mOnClickListener = onClickListener;
        return this;
    }

    public QMUIDialogAction skinTextColorAttr(int skinTextColorAttr) {
        this.mSkinTextColorAttr = skinTextColorAttr;
        return this;
    }

    public QMUIDialogAction skinBackgroundAttr(int skinBackgroundAttr) {
        this.mSkinBackgroundAttr = skinBackgroundAttr;
        return this;
    }

    public QMUIDialogAction skinIconTintColorAttr(int skinIconTintColorAttr) {
        this.mSkinIconTintColorAttr = skinIconTintColorAttr;
        return this;
    }

    QMUIDialogAction skinSeparatorColorAttr(int skinSeparatorColorAttr) {
        this.mSkinSeparatorColorAttr = skinSeparatorColorAttr;
        return this;
    }

    public QMUIDialogAction setEnabled(boolean enabled) {
        this.mIsEnabled = enabled;
        if (this.mButton != null) {
            this.mButton.setEnabled(enabled);
        }
        return this;
    }

    public QMUIButton buildActionView(final QMUIDialog dialog, final int index) {
        this.mButton = this.generateActionButton(dialog.getContext(), this.mStr, this.mIconRes, this.mSkinBackgroundAttr, this.mSkinTextColorAttr, this.mSkinIconTintColorAttr);
        this.mButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (QMUIDialogAction.this.mOnClickListener != null && QMUIDialogAction.this.mButton.isEnabled()) {
                    QMUIDialogAction.this.mOnClickListener.onClick(dialog, index);
                }
            }
        });
        return this.mButton;
    }

    private QMUIButton generateActionButton(Context context, CharSequence text, int iconRes, int skinBackgroundAttr, int skinTextColorAttr, int iconTintColor) {
        QMUIButton button = new QMUIButton(context);
        button.setBackground(null);
        button.setMinHeight(0);
        button.setMinimumHeight(0);
        button.setChangeAlphaWhenDisable(true);
        button.setChangeAlphaWhenPress(true);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogActionStyleDef, R.attr.qmui_dialog_action_style, 0);
        int count = a.getIndexCount();
        int paddingHor = 0;
        int iconSpace = 0;
        ColorStateList negativeTextColor = null;
        ColorStateList positiveTextColor = null;
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_gravity) {
                button.setGravity(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_textColor) {
                button.setTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_textSize) {
                button.setTextSize(0, a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_qmui_dialog_action_button_padding_horizontal) {
                paddingHor = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_background) {
                button.setBackground(a.getDrawable(attr2));
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_android_minWidth) {
                int miniWidth = a.getDimensionPixelSize(attr2, 0);
                button.setMinWidth(miniWidth);
                button.setMinimumWidth(miniWidth);
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_qmui_dialog_positive_action_text_color) {
                positiveTextColor = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_qmui_dialog_negative_action_text_color) {
                negativeTextColor = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.QMUIDialogActionStyleDef_qmui_dialog_action_icon_space) {
                iconSpace = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 != R.styleable.QMUITextCommonStyleDef_android_textStyle) continue;
            int styleIndex = a.getInt(attr2, -1);
            button.setTypeface(null, styleIndex);
        }
        a.recycle();
        button.setPadding(paddingHor, 0, paddingHor, 0);
        if (iconRes <= 0) {
            button.setText(text);
        } else {
            button.setText(QMUISpanHelper.generateSideIconText(true, iconSpace, text, ContextCompat.getDrawable((Context)context, (int)iconRes), iconTintColor, (View)button));
        }
        button.setClickable(true);
        button.setEnabled(this.mIsEnabled);
        if (this.mActionProp == 2) {
            button.setTextColor(negativeTextColor);
            if (skinTextColorAttr == 0) {
                skinTextColorAttr = R.attr.qmui_skin_support_dialog_negative_action_text_color;
            }
        } else if (this.mActionProp == 0) {
            button.setTextColor(positiveTextColor);
            if (skinTextColorAttr == 0) {
                skinTextColorAttr = R.attr.qmui_skin_support_dialog_positive_action_text_color;
            }
        } else if (skinTextColorAttr == 0) {
            skinTextColorAttr = R.attr.qmui_skin_support_dialog_action_text_color;
        }
        QMUISkinValueBuilder skinValueBuilder = QMUISkinValueBuilder.acquire();
        skinBackgroundAttr = skinBackgroundAttr == 0 ? R.attr.qmui_skin_support_dialog_action_bg : skinBackgroundAttr;
        skinValueBuilder.background(skinBackgroundAttr);
        skinValueBuilder.textColor(skinTextColorAttr);
        if (this.mSkinSeparatorColorAttr != 0) {
            skinValueBuilder.topSeparator(this.mSkinSeparatorColorAttr);
            skinValueBuilder.leftSeparator(this.mSkinSeparatorColorAttr);
        }
        QMUISkinHelper.setSkinValue((View)button, skinValueBuilder);
        skinValueBuilder.release();
        return button;
    }

    public int getActionProp() {
        return this.mActionProp;
    }

    public static interface ActionListener {
        public void onClick(QMUIDialog var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Prop {
    }
}

