/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextWatcher;
import android.text.method.TransformationMethod;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIConstraintLayout;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIBaseDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogBuilder;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogMenuItemView;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogRootLayout;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogView;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;
import java.util.ArrayList;
import java.util.BitSet;

public class QMUIDialog
extends QMUIBaseDialog {
    private Context mBaseContext;

    public QMUIDialog(Context context) {
        this(context, R.style.QMUI_Dialog);
    }

    public QMUIDialog(Context context, int styleRes) {
        super(context, styleRes);
        this.mBaseContext = context;
        this.init();
    }

    private void init() {
        this.setCancelable(true);
        this.setCanceledOnTouchOutside(true);
    }

    public void showWithImmersiveCheck(Activity activity) {
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        Window activityWindow = activity.getWindow();
        int activitySystemUi = activityWindow.getDecorView().getSystemUiVisibility();
        if ((activitySystemUi & 0x400) == 1024 || (activitySystemUi & 4) == 4) {
            window.setFlags(8, 8);
            window.getDecorView().setSystemUiVisibility(activity.getWindow().getDecorView().getSystemUiVisibility());
            super.show();
            window.clearFlags(8);
        } else {
            super.show();
        }
    }

    public void showWithImmersiveCheck() {
        if (!(this.mBaseContext instanceof Activity)) {
            super.show();
            return;
        }
        Activity activity = (Activity)this.mBaseContext;
        this.showWithImmersiveCheck(activity);
    }

    public static abstract class AutoResizeDialogBuilder
    extends QMUIDialogBuilder {
        protected ScrollView mScrollView;

        public AutoResizeDialogBuilder(Context context) {
            super(context);
            this.setCheckKeyboardOverlay(true);
        }

        @Override
        @Nullable
        protected View onCreateContent(@NonNull QMUIDialog dialog, @NonNull QMUIDialogView parent, @NonNull Context context) {
            this.mScrollView = this.wrapWithScroll(this.onBuildContent(dialog, context));
            return this.mScrollView;
        }

        public abstract View onBuildContent(@NonNull QMUIDialog var1, @NonNull Context var2);
    }

    public static class CustomDialogBuilder
    extends QMUIDialogBuilder {
        private int mLayoutId;

        public CustomDialogBuilder(Context context) {
            super(context);
        }

        public CustomDialogBuilder setLayout(@LayoutRes int layoutResId) {
            this.mLayoutId = layoutResId;
            return this;
        }

        @Override
        @Nullable
        protected View onCreateContent(QMUIDialog dialog, QMUIDialogView parent, Context context) {
            return LayoutInflater.from((Context)context).inflate(this.mLayoutId, (ViewGroup)parent, false);
        }
    }

    public static class MultiCheckableDialogBuilder
    extends MenuBaseDialogBuilder<MultiCheckableDialogBuilder> {
        private BitSet mCheckedItems = new BitSet();

        public MultiCheckableDialogBuilder(Context context) {
            super(context);
        }

        public MultiCheckableDialogBuilder setCheckedItems(BitSet checkedItems) {
            this.mCheckedItems.clear();
            this.mCheckedItems.or(checkedItems);
            return this;
        }

        public MultiCheckableDialogBuilder setCheckedItems(int[] checkedIndexes) {
            this.mCheckedItems.clear();
            if (checkedIndexes != null && checkedIndexes.length > 0) {
                for (int checkedIndex : checkedIndexes) {
                    this.mCheckedItems.set(checkedIndex);
                }
            }
            return this;
        }

        public MultiCheckableDialogBuilder addItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            for (final CharSequence item : items) {
                this.addItem(new MenuBaseDialogBuilder.ItemViewFactory(){

                    @Override
                    public QMUIDialogMenuItemView createItemView(Context context) {
                        return new QMUIDialogMenuItemView.CheckItemView(context, true, item);
                    }
                }, listener);
            }
            return this;
        }

        @Override
        @Nullable
        protected View onCreateContent(QMUIDialog dialog, QMUIDialogView parent, Context context) {
            View result = super.onCreateContent(dialog, parent, context);
            for (int i = 0; i < this.mMenuItemViews.size(); ++i) {
                QMUIDialogMenuItemView itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(i);
                itemView.setChecked(this.mCheckedItems.get(i));
            }
            return result;
        }

        @Override
        protected void onItemClick(int index) {
            QMUIDialogMenuItemView itemView;
            itemView.setChecked(!(itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(index)).isChecked());
            this.mCheckedItems.set(index, itemView.isChecked());
        }

        public BitSet getCheckedItemRecord() {
            return (BitSet)this.mCheckedItems.clone();
        }

        public int[] getCheckedItemIndexes() {
            ArrayList<Integer> array = new ArrayList<Integer>();
            int length = this.mMenuItemViews.size();
            for (int i = 0; i < length; ++i) {
                QMUIDialogMenuItemView itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(i);
                if (!itemView.isChecked()) continue;
                array.add(itemView.getMenuIndex());
            }
            int[] output = new int[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                output[i] = (Integer)array.get(i);
            }
            return output;
        }

        protected boolean existCheckedItem() {
            return !this.mCheckedItems.isEmpty();
        }
    }

    public static class CheckableDialogBuilder
    extends MenuBaseDialogBuilder<CheckableDialogBuilder> {
        private int mCheckedIndex = -1;

        public CheckableDialogBuilder(Context context) {
            super(context);
        }

        public int getCheckedIndex() {
            return this.mCheckedIndex;
        }

        public CheckableDialogBuilder setCheckedIndex(int checkedIndex) {
            this.mCheckedIndex = checkedIndex;
            return this;
        }

        @Override
        @Nullable
        protected View onCreateContent(QMUIDialog dialog, QMUIDialogView parent, Context context) {
            View result = super.onCreateContent(dialog, parent, context);
            if (this.mCheckedIndex > -1 && this.mCheckedIndex < this.mMenuItemViews.size()) {
                ((QMUIDialogMenuItemView)this.mMenuItemViews.get(this.mCheckedIndex)).setChecked(true);
            }
            return result;
        }

        @Override
        protected void onItemClick(int index) {
            for (int i = 0; i < this.mMenuItemViews.size(); ++i) {
                QMUIDialogMenuItemView itemView = (QMUIDialogMenuItemView)this.mMenuItemViews.get(i);
                if (i == index) {
                    itemView.setChecked(true);
                    this.mCheckedIndex = index;
                    continue;
                }
                itemView.setChecked(false);
            }
        }

        public CheckableDialogBuilder addItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            for (final CharSequence item : items) {
                this.addItem(new MenuBaseDialogBuilder.ItemViewFactory(){

                    @Override
                    public QMUIDialogMenuItemView createItemView(Context context) {
                        return new QMUIDialogMenuItemView.MarkItemView(context, item);
                    }
                }, listener);
            }
            return this;
        }
    }

    public static class MenuDialogBuilder
    extends MenuBaseDialogBuilder<MenuDialogBuilder> {
        public MenuDialogBuilder(Context context) {
            super(context);
        }

        public MenuDialogBuilder addItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            for (CharSequence item : items) {
                this.addItem(item, listener);
            }
            return this;
        }

        public MenuDialogBuilder addItem(final CharSequence item, DialogInterface.OnClickListener listener) {
            this.addItem(new MenuBaseDialogBuilder.ItemViewFactory(){

                @Override
                public QMUIDialogMenuItemView createItemView(Context context) {
                    return new QMUIDialogMenuItemView.TextItemView(context, item);
                }
            }, listener);
            return this;
        }
    }

    public static class MenuBaseDialogBuilder<T extends QMUIDialogBuilder>
    extends QMUIDialogBuilder<T> {
        protected ArrayList<ItemViewFactory> mMenuItemViewsFactoryList;
        protected ArrayList<QMUIDialogMenuItemView> mMenuItemViews = new ArrayList();

        public MenuBaseDialogBuilder(Context context) {
            super(context);
            this.mMenuItemViewsFactoryList = new ArrayList();
        }

        public void clear() {
            this.mMenuItemViewsFactoryList.clear();
        }

        @Deprecated
        public T addItem(final QMUIDialogMenuItemView itemView, final DialogInterface.OnClickListener listener) {
            itemView.setMenuIndex(this.mMenuItemViewsFactoryList.size());
            itemView.setListener(new QMUIDialogMenuItemView.MenuItemViewListener(){

                @Override
                public void onClick(int index) {
                    MenuBaseDialogBuilder.this.onItemClick(index);
                    if (listener != null) {
                        listener.onClick((DialogInterface)MenuBaseDialogBuilder.this.mDialog, index);
                    }
                }
            });
            this.mMenuItemViewsFactoryList.add(new ItemViewFactory(){

                @Override
                public QMUIDialogMenuItemView createItemView(Context context) {
                    return itemView;
                }
            });
            return (T)this;
        }

        public T addItem(final ItemViewFactory itemViewFactory, final DialogInterface.OnClickListener listener) {
            this.mMenuItemViewsFactoryList.add(new ItemViewFactory(){

                @Override
                public QMUIDialogMenuItemView createItemView(Context context) {
                    QMUIDialogMenuItemView itemView = itemViewFactory.createItemView(context);
                    itemView.setMenuIndex(MenuBaseDialogBuilder.this.mMenuItemViewsFactoryList.indexOf(this));
                    itemView.setListener(new QMUIDialogMenuItemView.MenuItemViewListener(){

                        @Override
                        public void onClick(int index) {
                            MenuBaseDialogBuilder.this.onItemClick(index);
                            if (listener != null) {
                                listener.onClick((DialogInterface)MenuBaseDialogBuilder.this.mDialog, index);
                            }
                        }
                    });
                    return itemView;
                }
            });
            return (T)this;
        }

        protected void onItemClick(int index) {
        }

        @Override
        @Nullable
        protected View onCreateContent(QMUIDialog dialog, QMUIDialogView parent, Context context) {
            QMUILinearLayout layout2 = new QMUILinearLayout(context);
            layout2.setOrientation(1);
            TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogMenuContainerStyleDef, R.attr.qmui_dialog_menu_container_style, 0);
            int count = a.getIndexCount();
            int paddingTop = 0;
            int paddingBottom = 0;
            int paddingVerWhenSingle = 0;
            int paddingTopWhenTitle = 0;
            int paddingBottomWhenAction = 0;
            int itemHeight = -1;
            for (int i = 0; i < count; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_android_paddingTop) {
                    paddingTop = a.getDimensionPixelSize(attr2, paddingTop);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_android_paddingBottom) {
                    paddingBottom = a.getDimensionPixelSize(attr2, paddingBottom);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_qmui_dialog_menu_container_single_padding_vertical) {
                    paddingVerWhenSingle = a.getDimensionPixelSize(attr2, paddingVerWhenSingle);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_qmui_dialog_menu_container_padding_top_when_title_exist) {
                    paddingTopWhenTitle = a.getDimensionPixelSize(attr2, paddingTopWhenTitle);
                    continue;
                }
                if (attr2 == R.styleable.QMUIDialogMenuContainerStyleDef_qmui_dialog_menu_container_padding_bottom_when_action_exist) {
                    paddingBottomWhenAction = a.getDimensionPixelSize(attr2, paddingBottomWhenAction);
                    continue;
                }
                if (attr2 != R.styleable.QMUIDialogMenuContainerStyleDef_qmui_dialog_menu_item_height) continue;
                itemHeight = a.getDimensionPixelSize(attr2, itemHeight);
            }
            a.recycle();
            if (this.mMenuItemViewsFactoryList.size() == 1) {
                paddingBottom = paddingTop = paddingVerWhenSingle;
            }
            if (this.hasTitle()) {
                paddingTop = paddingTopWhenTitle;
            }
            if (this.mActions.size() > 0) {
                paddingBottom = paddingBottomWhenAction;
            }
            layout2.setPadding(0, paddingTop, 0, paddingBottom);
            LinearLayout.LayoutParams itemLp = new LinearLayout.LayoutParams(-1, itemHeight);
            itemLp.gravity = 16;
            this.mMenuItemViews.clear();
            for (ItemViewFactory factory : this.mMenuItemViewsFactoryList) {
                QMUIDialogMenuItemView itemView = factory.createItemView(context);
                layout2.addView((View)itemView, (ViewGroup.LayoutParams)itemLp);
                this.mMenuItemViews.add(itemView);
            }
            return this.wrapWithScroll((View)layout2);
        }

        public static interface ItemViewFactory {
            public QMUIDialogMenuItemView createItemView(Context var1);
        }
    }

    public static class EditTextDialogBuilder
    extends QMUIDialogBuilder<EditTextDialogBuilder> {
        protected String mPlaceholder;
        protected TransformationMethod mTransformationMethod;
        protected EditText mEditText;
        protected AppCompatImageView mRightImageView;
        private int mInputType = 1;
        private CharSequence mDefaultText = null;
        private TextWatcher mTextWatcher;

        public EditTextDialogBuilder(Context context) {
            super(context);
        }

        public EditTextDialogBuilder setPlaceholder(String placeholder) {
            this.mPlaceholder = placeholder;
            return this;
        }

        public EditTextDialogBuilder setPlaceholder(int resId) {
            return this.setPlaceholder(this.getBaseContext().getResources().getString(resId));
        }

        public EditTextDialogBuilder setDefaultText(CharSequence defaultText) {
            this.mDefaultText = defaultText;
            return this;
        }

        public EditTextDialogBuilder setTransformationMethod(TransformationMethod transformationMethod) {
            this.mTransformationMethod = transformationMethod;
            return this;
        }

        public EditTextDialogBuilder setInputType(int inputType) {
            this.mInputType = inputType;
            return this;
        }

        public EditTextDialogBuilder setTextWatcher(TextWatcher textWatcher) {
            this.mTextWatcher = textWatcher;
            return this;
        }

        @Override
        protected ConstraintLayout.LayoutParams onCreateContentLayoutParams(Context context) {
            int marginHor;
            ConstraintLayout.LayoutParams lp = super.onCreateContentLayoutParams(context);
            lp.leftMargin = marginHor = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_padding_horizontal);
            lp.rightMargin = marginHor;
            lp.topMargin = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_edit_margin_top);
            lp.bottomMargin = QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_edit_margin_bottom);
            return lp;
        }

        @Override
        @Nullable
        protected View onCreateContent(QMUIDialog dialog, QMUIDialogView parent, Context context) {
            QMUIConstraintLayout boxLayout = new QMUIConstraintLayout(context);
            boxLayout.onlyShowBottomDivider(0, 0, QMUIResHelper.getAttrDimen(context, R.attr.qmui_dialog_edit_bottom_line_height), QMUIResHelper.getAttrColor(context, R.attr.qmui_skin_support_dialog_edit_bottom_line_color));
            QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
            builder.bottomSeparator(R.attr.qmui_skin_support_dialog_edit_bottom_line_color);
            QMUISkinHelper.setSkinValue((View)boxLayout, builder);
            this.mEditText = new AppCompatEditText(context);
            this.mEditText.setBackgroundResource(0);
            MessageDialogBuilder.assignMessageTvWithAttr((TextView)this.mEditText, this.hasTitle(), R.attr.qmui_dialog_edit_content_style);
            this.mEditText.setFocusable(true);
            this.mEditText.setFocusableInTouchMode(true);
            this.mEditText.setImeOptions(2);
            this.mEditText.setId(R.id.qmui_dialog_edit_input);
            if (!QMUILangHelper.isNullOrEmpty(this.mDefaultText)) {
                this.mEditText.setText(this.mDefaultText);
            }
            if (this.mTextWatcher != null) {
                this.mEditText.addTextChangedListener(this.mTextWatcher);
            }
            builder.clear();
            builder.textColor(R.attr.qmui_skin_support_dialog_edit_text_color);
            builder.hintColor(R.attr.qmui_skin_support_dialog_edit_text_hint_color);
            QMUISkinHelper.setSkinValue((View)this.mEditText, builder);
            QMUISkinValueBuilder.release(builder);
            this.mRightImageView = new AppCompatImageView(context);
            this.mRightImageView.setId(R.id.qmui_dialog_edit_right_icon);
            this.mRightImageView.setVisibility(8);
            this.configRightImageView(this.mRightImageView, this.mEditText);
            if (this.mTransformationMethod != null) {
                this.mEditText.setTransformationMethod(this.mTransformationMethod);
            } else {
                this.mEditText.setInputType(this.mInputType);
            }
            if (this.mPlaceholder != null) {
                this.mEditText.setHint((CharSequence)this.mPlaceholder);
            }
            boxLayout.addView((View)this.mEditText, (ViewGroup.LayoutParams)this.createEditTextLayoutParams(context));
            boxLayout.addView((View)this.mRightImageView, (ViewGroup.LayoutParams)this.createRightIconLayoutParams(context));
            return boxLayout;
        }

        protected void configRightImageView(AppCompatImageView imageView, EditText editText) {
        }

        protected ConstraintLayout.LayoutParams createEditTextLayoutParams(Context context) {
            ConstraintLayout.LayoutParams editLp = new ConstraintLayout.LayoutParams(0, -2);
            editLp.leftToLeft = 0;
            editLp.topToTop = 0;
            editLp.rightToLeft = R.id.qmui_dialog_edit_right_icon;
            editLp.rightToRight = QMUIDisplayHelper.dp2px(context, 5);
            editLp.goneRightMargin = 0;
            return editLp;
        }

        protected ConstraintLayout.LayoutParams createRightIconLayoutParams(Context context) {
            ConstraintLayout.LayoutParams rightIconLp = new ConstraintLayout.LayoutParams(-2, -2);
            rightIconLp.rightToRight = 0;
            rightIconLp.bottomToBottom = R.id.qmui_dialog_edit_input;
            return rightIconLp;
        }

        @Override
        protected void onAfterCreate(QMUIDialog dialog, QMUIDialogRootLayout rootLayout, Context context) {
            super.onAfterCreate(dialog, rootLayout, context);
            final InputMethodManager inputMethodManager = (InputMethodManager)context.getSystemService("input_method");
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    inputMethodManager.hideSoftInputFromWindow(EditTextDialogBuilder.this.mEditText.getWindowToken(), 0);
                }
            });
            this.mEditText.postDelayed(new Runnable(){

                @Override
                public void run() {
                    EditTextDialogBuilder.this.mEditText.requestFocus();
                    inputMethodManager.showSoftInput((View)EditTextDialogBuilder.this.mEditText, 0);
                }
            }, 300L);
        }

        @Deprecated
        public EditText getEditText() {
            return this.mEditText;
        }

        public ImageView getRightImageView() {
            return this.mRightImageView;
        }
    }

    public static class CheckBoxMessageDialogBuilder
    extends QMUIDialogBuilder<CheckBoxMessageDialogBuilder> {
        protected String mMessage;
        private boolean mIsChecked = false;
        private QMUISpanTouchFixTextView mTextView;

        public CheckBoxMessageDialogBuilder(Context context) {
            super(context);
        }

        public CheckBoxMessageDialogBuilder setMessage(String message) {
            this.mMessage = message;
            return this;
        }

        public CheckBoxMessageDialogBuilder setMessage(int resid) {
            return this.setMessage(this.getBaseContext().getResources().getString(resid));
        }

        public boolean isChecked() {
            return this.mIsChecked;
        }

        public CheckBoxMessageDialogBuilder setChecked(boolean checked) {
            if (this.mIsChecked != checked) {
                this.mIsChecked = checked;
                if (this.mTextView != null) {
                    this.mTextView.setSelected(checked);
                }
            }
            return this;
        }

        @Override
        @Nullable
        protected View onCreateContent(QMUIDialog dialog, QMUIDialogView parent, Context context) {
            if (this.mMessage != null && this.mMessage.length() != 0) {
                this.mTextView = new QMUISpanTouchFixTextView(context);
                this.mTextView.setMovementMethodDefault();
                MessageDialogBuilder.assignMessageTvWithAttr((TextView)this.mTextView, this.hasTitle(), R.attr.qmui_dialog_message_content_style);
                this.mTextView.setText(this.mMessage);
                Drawable drawable2 = QMUISkinHelper.getSkinDrawable((View)this.mTextView, R.attr.qmui_skin_support_s_dialog_check_drawable);
                if (drawable2 != null) {
                    drawable2.setBounds(0, 0, drawable2.getIntrinsicWidth(), drawable2.getIntrinsicHeight());
                    this.mTextView.setCompoundDrawables(drawable2, null, null, null);
                }
                QMUISkinValueBuilder valueBuilder = QMUISkinValueBuilder.acquire();
                valueBuilder.textColor(R.attr.qmui_skin_support_dialog_message_text_color);
                valueBuilder.textCompoundLeftSrc(R.attr.qmui_skin_support_s_dialog_check_drawable);
                QMUISkinHelper.setSkinValue((View)this.mTextView, valueBuilder);
                QMUISkinValueBuilder.release(valueBuilder);
                this.mTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CheckBoxMessageDialogBuilder.this.setChecked(!CheckBoxMessageDialogBuilder.this.mIsChecked);
                    }
                });
                this.mTextView.setSelected(this.mIsChecked);
                return this.wrapWithScroll((View)this.mTextView);
            }
            return null;
        }

        @Deprecated
        public QMUISpanTouchFixTextView getTextView() {
            return this.mTextView;
        }
    }

    public static class MessageDialogBuilder
    extends QMUIDialogBuilder<MessageDialogBuilder> {
        protected CharSequence mMessage;

        public MessageDialogBuilder(Context context) {
            super(context);
        }

        public MessageDialogBuilder setMessage(CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public MessageDialogBuilder setMessage(int resId) {
            return this.setMessage(this.getBaseContext().getResources().getString(resId));
        }

        @Override
        @Nullable
        protected View onCreateContent(@NonNull QMUIDialog dialog, @NonNull QMUIDialogView parent, @NonNull Context context) {
            if (this.mMessage != null && this.mMessage.length() != 0) {
                QMUISpanTouchFixTextView tv = new QMUISpanTouchFixTextView(context);
                MessageDialogBuilder.assignMessageTvWithAttr((TextView)tv, this.hasTitle(), R.attr.qmui_dialog_message_content_style);
                tv.setText(this.mMessage);
                tv.setMovementMethodDefault();
                QMUISkinValueBuilder valueBuilder = QMUISkinValueBuilder.acquire();
                valueBuilder.textColor(R.attr.qmui_skin_support_dialog_message_text_color);
                QMUISkinHelper.setSkinValue((View)tv, valueBuilder);
                QMUISkinValueBuilder.release(valueBuilder);
                return this.wrapWithScroll((View)tv);
            }
            return null;
        }

        @Override
        @Nullable
        protected View onCreateTitle(@NonNull QMUIDialog dialog, @NonNull QMUIDialogView parent, @NonNull Context context) {
            View tv = super.onCreateTitle(dialog, parent, context);
            if (tv != null && (this.mMessage == null || this.mMessage.length() == 0)) {
                TypedArray a = context.obtainStyledAttributes(null, R.styleable.QMUIDialogTitleTvCustomDef, R.attr.qmui_dialog_title_style, 0);
                int count = a.getIndexCount();
                for (int i = 0; i < count; ++i) {
                    int attr2 = a.getIndex(i);
                    if (attr2 != R.styleable.QMUIDialogTitleTvCustomDef_qmui_paddingBottomWhenNotContent) continue;
                    tv.setPadding(tv.getPaddingLeft(), tv.getPaddingTop(), tv.getPaddingRight(), a.getDimensionPixelSize(attr2, tv.getPaddingBottom()));
                }
                a.recycle();
            }
            return tv;
        }

        public static void assignMessageTvWithAttr(TextView messageTv, boolean hasTitle, int defAttr) {
            QMUIResHelper.assignTextViewWithAttr(messageTv, defAttr);
            if (!hasTitle) {
                TypedArray a = messageTv.getContext().obtainStyledAttributes(null, R.styleable.QMUIDialogMessageTvCustomDef, defAttr, 0);
                int count = a.getIndexCount();
                for (int i = 0; i < count; ++i) {
                    int attr2 = a.getIndex(i);
                    if (attr2 != R.styleable.QMUIDialogMessageTvCustomDef_qmui_paddingTopWhenNotTitle) continue;
                    messageTv.setPadding(messageTv.getPaddingLeft(), a.getDimensionPixelSize(attr2, messageTv.getPaddingTop()), messageTv.getPaddingRight(), messageTv.getPaddingBottom());
                }
                a.recycle();
            }
        }
    }
}

