/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUIConstraintLayout;
import com.qmuiteam.qmui.layout.QMUIFrameLayout;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.skin.defaultAttr.QMUISkinSimpleDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetListItemModel;
import com.qmuiteam.qmui.widget.textview.QMUISpanTouchFixTextView;

public class QMUIBottomSheetListItemView
extends QMUIConstraintLayout {
    private AppCompatImageView mIconView;
    private QMUISpanTouchFixTextView mTextView;
    private QMUIFrameLayout mRedPointView;
    private AppCompatImageView mMarkView = null;
    private int mItemHeight;

    public QMUIBottomSheetListItemView(Context context, boolean markStyle, boolean gravityCenter) {
        super(context);
        this.setBackground(QMUIResHelper.getAttrDrawable(context, R.attr.qmui_skin_support_bottom_sheet_list_item_bg));
        int paddingHor = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_padding_hor);
        this.setPadding(paddingHor, 0, paddingHor, 0);
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        builder.background(R.attr.qmui_skin_support_bottom_sheet_list_item_bg);
        QMUISkinHelper.setSkinValue((View)this, builder);
        builder.clear();
        this.mIconView = new AppCompatImageView(context);
        this.mIconView.setId(View.generateViewId());
        this.mIconView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.mTextView = new QMUISpanTouchFixTextView(context);
        this.mTextView.setId(View.generateViewId());
        QMUISkinSimpleDefaultAttrProvider provider = new QMUISkinSimpleDefaultAttrProvider();
        provider.setDefaultSkinAttr("textColor", R.attr.qmui_skin_support_bottom_sheet_list_item_text_color);
        QMUIResHelper.assignTextViewWithAttr((TextView)this.mTextView, R.attr.qmui_bottom_sheet_list_item_text_style);
        QMUISkinHelper.setSkinDefaultProvider((View)this.mTextView, provider);
        this.mRedPointView = new QMUIFrameLayout(context);
        this.mRedPointView.setId(View.generateViewId());
        this.mRedPointView.setBackgroundColor(QMUIResHelper.getAttrColor(context, R.attr.qmui_skin_support_bottom_sheet_list_red_point_color));
        builder.background(R.attr.qmui_skin_support_bottom_sheet_list_red_point_color);
        QMUISkinHelper.setSkinValue((View)this.mRedPointView, builder);
        builder.clear();
        if (markStyle) {
            this.mMarkView = new AppCompatImageView(context);
            this.mMarkView.setId(View.generateViewId());
            this.mMarkView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            this.mMarkView.setImageDrawable(QMUIResHelper.getAttrDrawable(context, R.attr.qmui_skin_support_bottom_sheet_list_mark));
            builder.src(R.attr.qmui_skin_support_bottom_sheet_list_mark);
            QMUISkinHelper.setSkinValue((View)this.mMarkView, builder);
        }
        builder.release();
        int iconSize = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_list_item_icon_size);
        ConstraintLayout.LayoutParams lp = new ConstraintLayout.LayoutParams(iconSize, iconSize);
        lp.leftToLeft = 0;
        lp.topToTop = 0;
        lp.rightToLeft = this.mTextView.getId();
        lp.bottomToBottom = 0;
        lp.horizontalChainStyle = 2;
        lp.horizontalBias = gravityCenter ? 0.5f : 0.0f;
        this.addView((View)this.mIconView, (ViewGroup.LayoutParams)lp);
        lp = new ConstraintLayout.LayoutParams(-2, -2);
        lp.leftToRight = this.mIconView.getId();
        lp.rightToLeft = this.mRedPointView.getId();
        lp.topToTop = 0;
        lp.bottomToBottom = 0;
        lp.horizontalChainStyle = 2;
        lp.horizontalBias = gravityCenter ? 0.5f : 0.0f;
        lp.leftMargin = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_list_item_icon_margin_right);
        lp.goneLeftMargin = 0;
        this.addView((View)this.mTextView, (ViewGroup.LayoutParams)lp);
        int redPointSize = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_list_item_red_point_size);
        lp = new ConstraintLayout.LayoutParams(redPointSize, redPointSize);
        lp.leftToRight = this.mTextView.getId();
        if (markStyle) {
            lp.rightToLeft = this.mMarkView.getId();
            lp.rightMargin = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_list_item_mark_margin_left);
        } else {
            lp.rightToRight = 0;
        }
        lp.topToTop = 0;
        lp.bottomToBottom = 0;
        lp.horizontalChainStyle = 2;
        lp.horizontalBias = gravityCenter ? 0.5f : 0.0f;
        lp.leftMargin = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_list_item_tip_point_margin_left);
        this.addView((View)this.mRedPointView, (ViewGroup.LayoutParams)lp);
        if (markStyle) {
            lp = new ConstraintLayout.LayoutParams(-2, -2);
            lp.rightToRight = 0;
            lp.topToTop = 0;
            lp.bottomToBottom = 0;
            this.addView((View)this.mMarkView, (ViewGroup.LayoutParams)lp);
        }
        this.mItemHeight = QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_list_item_height);
    }

    public void render(@NonNull QMUIBottomSheetListItemModel itemModel, boolean isChecked) {
        QMUISkinValueBuilder builder = QMUISkinValueBuilder.acquire();
        if (itemModel.imageSkinSrcAttr != 0) {
            builder.src(itemModel.imageSkinSrcAttr);
            QMUISkinHelper.setSkinValue((View)this.mIconView, builder);
            this.mIconView.setImageDrawable(QMUISkinHelper.getSkinDrawable((View)this, itemModel.imageSkinSrcAttr));
            this.mIconView.setVisibility(0);
        } else {
            Drawable drawable2 = itemModel.image;
            if (drawable2 == null && itemModel.imageRes != 0) {
                drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)itemModel.imageRes);
            }
            if (drawable2 != null) {
                drawable2.mutate();
                this.mIconView.setImageDrawable(drawable2);
                if (itemModel.imageSkinTintColorAttr != 0) {
                    builder.tintColor(itemModel.imageSkinTintColorAttr);
                    QMUISkinHelper.setSkinValue((View)this.mIconView, builder);
                } else {
                    QMUISkinHelper.setSkinValue((View)this.mIconView, "");
                }
            } else {
                this.mIconView.setVisibility(8);
            }
        }
        builder.clear();
        this.mTextView.setText(itemModel.text);
        if (itemModel.typeface != null) {
            this.mTextView.setTypeface(itemModel.typeface);
        }
        if (itemModel.textSkinColorAttr != 0) {
            builder.textColor(itemModel.textSkinColorAttr);
            QMUISkinHelper.setSkinValue((View)this.mTextView, builder);
            ColorStateList color2 = QMUISkinHelper.getSkinColorStateList((View)this.mTextView, itemModel.textSkinColorAttr);
            if (color2 != null) {
                this.mTextView.setTextColor(color2);
            }
        } else {
            QMUISkinHelper.setSkinValue((View)this.mTextView, "");
        }
        this.mRedPointView.setVisibility(itemModel.hasRedPoint ? 0 : 8);
        if (this.mMarkView != null) {
            this.mMarkView.setVisibility(isChecked ? 0 : 4);
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)this.mItemHeight, (int)0x40000000));
    }
}

