/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerDecoration;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheetListItemView;
import org.jetbrains.annotations.NotNull;

public class QMUIBottomSheetListItemDecoration
extends RecyclerView.ItemDecoration
implements IQMUISkinHandlerDecoration {
    private final Paint mSeparatorPaint = new Paint();
    private final int mSeparatorAttr;

    public QMUIBottomSheetListItemDecoration(Context context) {
        this.mSeparatorPaint.setStrokeWidth((float)QMUIResHelper.getAttrDimen(context, R.attr.qmui_bottom_sheet_list_item_separator_height));
        this.mSeparatorPaint.setStyle(Paint.Style.STROKE);
        this.mSeparatorAttr = R.attr.qmui_skin_support_bottom_sheet_separator_color;
        if (this.mSeparatorAttr != 0) {
            this.mSeparatorPaint.setColor(QMUIResHelper.getAttrColor(context, this.mSeparatorAttr));
        }
    }

    public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
        RecyclerView.Adapter adapter = parent.getAdapter();
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (adapter == null || layoutManager == null || this.mSeparatorAttr == 0) {
            return;
        }
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View view = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(view);
            if (!(view instanceof QMUIBottomSheetListItemView)) continue;
            if (position > 0 && adapter.getItemViewType(position - 1) != 3) {
                int top = layoutManager.getDecoratedTop(view);
                c.drawLine(0.0f, (float)top, (float)parent.getWidth(), (float)top, this.mSeparatorPaint);
            }
            if (position + 1 >= adapter.getItemCount() || adapter.getItemViewType(position + 1) != 3) continue;
            int bottom = layoutManager.getDecoratedBottom(view);
            c.drawLine(0.0f, (float)bottom, (float)parent.getWidth(), (float)bottom, this.mSeparatorPaint);
        }
    }

    @Override
    public void handle(@NotNull RecyclerView recyclerView, @NotNull QMUISkinManager manager, int skinIndex, @NotNull Resources.Theme theme) {
        if (this.mSeparatorAttr != 0) {
            this.mSeparatorPaint.setColor(QMUIResHelper.getAttrColor(theme, this.mSeparatorAttr));
        }
    }
}

