/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.dialog;

import android.content.Context;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.dialog.QMUIBottomSheet;
import java.util.List;

public class QMUIBottomSheetGridLineLayout
extends LinearLayout {
    private static ItemWidthCalculator DEFAULT_CALCULATOR = new ItemWidthCalculator(){

        @Override
        public int calculate(Context context, int width, int miniWidth, int itemCount, int paddingLeft, int paddingRight) {
            int count;
            int parentSpacing = width - paddingLeft - paddingRight;
            int itemWidth = miniWidth;
            if (itemCount >= 3 && parentSpacing - itemCount * itemWidth > 0 && parentSpacing - itemCount * itemWidth < itemWidth) {
                count = parentSpacing / itemWidth;
                itemWidth = parentSpacing / count;
            }
            if (itemWidth * itemCount > parentSpacing) {
                count = (width - paddingLeft) / itemWidth;
                itemWidth = (int)((float)(width - paddingLeft) / ((float)count + 0.5f));
            }
            return itemWidth;
        }
    };
    private int maxItemCountInLines;
    private int miniItemWidth = -1;
    private List<Pair<View, LinearLayout.LayoutParams>> mFirstLineViews;
    private List<Pair<View, LinearLayout.LayoutParams>> mSecondLineViews;
    private int linePaddingHor;
    private int itemWidth;
    private final ItemWidthCalculator mItemWidthCalculator;

    public QMUIBottomSheetGridLineLayout(QMUIBottomSheet bottomSheet, @Nullable ItemWidthCalculator widthCalculator, List<Pair<View, LinearLayout.LayoutParams>> firstLineViews, List<Pair<View, LinearLayout.LayoutParams>> secondLineViews) {
        super(bottomSheet.getContext());
        this.setOrientation(1);
        this.setGravity(48);
        this.mItemWidthCalculator = widthCalculator == null ? DEFAULT_CALCULATOR : widthCalculator;
        int paddingTop = QMUIResHelper.getAttrDimen(bottomSheet.getContext(), R.attr.qmui_bottom_sheet_grid_padding_top);
        int paddingBottom = QMUIResHelper.getAttrDimen(bottomSheet.getContext(), R.attr.qmui_bottom_sheet_grid_padding_bottom);
        this.setPadding(0, paddingTop, 0, paddingBottom);
        this.mFirstLineViews = firstLineViews;
        this.mSecondLineViews = secondLineViews;
        this.maxItemCountInLines = Math.max(firstLineViews != null ? firstLineViews.size() : 0, secondLineViews != null ? secondLineViews.size() : 0);
        this.linePaddingHor = QMUIResHelper.getAttrDimen(bottomSheet.getContext(), R.attr.qmui_bottom_sheet_padding_hor);
        boolean hasFirstLine = false;
        if (firstLineViews != null && !firstLineViews.isEmpty()) {
            hasFirstLine = true;
            HorizontalScrollView firstLine = this.createHorScroller(bottomSheet, firstLineViews);
            this.addView((View)firstLine, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        }
        if (secondLineViews != null && !secondLineViews.isEmpty()) {
            HorizontalScrollView secondLine = this.createHorScroller(bottomSheet, secondLineViews);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
            if (hasFirstLine) {
                lp.topMargin = QMUIResHelper.getAttrDimen(bottomSheet.getContext(), R.attr.qmui_bottom_sheet_grid_line_vertical_space);
            }
            this.addView((View)secondLine, (ViewGroup.LayoutParams)lp);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measureWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.itemWidth = this.calculateItemWidth(measureWidth, this.maxItemCountInLines, this.linePaddingHor, this.linePaddingHor);
        if (this.mFirstLineViews != null) {
            for (Pair<View, LinearLayout.LayoutParams> pair : this.mFirstLineViews) {
                if (((LinearLayout.LayoutParams)pair.second).width == this.itemWidth) continue;
                ((LinearLayout.LayoutParams)pair.second).width = this.itemWidth;
            }
        }
        if (this.mSecondLineViews != null) {
            for (Pair<View, LinearLayout.LayoutParams> pair : this.mSecondLineViews) {
                if (((LinearLayout.LayoutParams)pair.second).width == this.itemWidth) continue;
                ((LinearLayout.LayoutParams)pair.second).width = this.itemWidth;
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected HorizontalScrollView createHorScroller(QMUIBottomSheet bottomSheet, List<Pair<View, LinearLayout.LayoutParams>> itemViews) {
        Context context = bottomSheet.getContext();
        HorizontalScrollView scroller = new HorizontalScrollView(context);
        scroller.setHorizontalScrollBarEnabled(false);
        scroller.setClipToPadding(true);
        LinearLayout linear = new LinearLayout(context);
        linear.setOrientation(0);
        linear.setGravity(16);
        linear.setPadding(this.linePaddingHor, 0, this.linePaddingHor, 0);
        scroller.addView((View)linear, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        for (int i = 0; i < itemViews.size(); ++i) {
            Pair<View, LinearLayout.LayoutParams> pair = itemViews.get(i);
            linear.addView((View)pair.first, (ViewGroup.LayoutParams)pair.second);
        }
        return scroller;
    }

    protected void measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        super.measureChild(child, parentWidthMeasureSpec, parentHeightMeasureSpec);
    }

    private int calculateItemWidth(int width, int calculateCount, int paddingLeft, int paddingRight) {
        if (this.miniItemWidth == -1) {
            this.miniItemWidth = QMUIResHelper.getAttrDimen(this.getContext(), R.attr.qmui_bottom_sheet_grid_item_mini_width);
        }
        return this.mItemWidthCalculator.calculate(this.getContext(), width, this.miniItemWidth, calculateCount, paddingLeft, paddingRight);
    }

    public static interface ItemWidthCalculator {
        public int calculate(Context var1, int var2, int var3, int var4, int var5, int var6);
    }
}

