/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.qmuiteam.qmui.util.QMUIWindowInsetHelper;
import com.qmuiteam.qmui.widget.QMUIPagerAdapter;

public class QMUIViewPager
extends ViewPager {
    private static final int DEFAULT_INFINITE_RATIO = 100;
    private boolean mIsSwipeable = true;
    private boolean mIsInMeasure = false;
    private boolean mEnableLoop = false;
    private int mInfiniteRatio = 100;

    public QMUIViewPager(Context context) {
        this(context, null);
    }

    public QMUIViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        QMUIWindowInsetHelper.overrideWithDoNotHandleWindowInsets((View)this);
    }

    public void setSwipeable(boolean enable) {
        this.mIsSwipeable = enable;
    }

    public int getInfiniteRatio() {
        return this.mInfiniteRatio;
    }

    public void setInfiniteRatio(int infiniteRatio) {
        this.mInfiniteRatio = infiniteRatio;
    }

    public boolean isEnableLoop() {
        return this.mEnableLoop;
    }

    public void setEnableLoop(boolean enableLoop) {
        if (this.mEnableLoop != enableLoop) {
            this.mEnableLoop = enableLoop;
            if (this.getAdapter() != null) {
                this.getAdapter().notifyDataSetChanged();
            }
        }
    }

    public void onViewAdded(View child) {
        super.onViewAdded(child);
        ViewCompat.requestApplyInsets((View)child);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        try {
            return this.mIsSwipeable && super.onTouchEvent(ev);
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        try {
            return this.mIsSwipeable && super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mIsInMeasure = true;
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mIsInMeasure = false;
    }

    public boolean isInMeasure() {
        return this.mIsInMeasure;
    }

    public void setAdapter(PagerAdapter adapter) {
        if (adapter instanceof QMUIPagerAdapter) {
            super.setAdapter((PagerAdapter)new WrapperPagerAdapter((QMUIPagerAdapter)adapter));
        } else {
            super.setAdapter(adapter);
        }
    }

    class WrapperPagerAdapter
    extends PagerAdapter {
        private QMUIPagerAdapter mAdapter;

        public WrapperPagerAdapter(QMUIPagerAdapter adapter) {
            this.mAdapter = adapter;
        }

        public int getCount() {
            int count = this.mAdapter.getCount();
            if (QMUIViewPager.this.mEnableLoop && count > 3) {
                count *= QMUIViewPager.this.mInfiniteRatio;
            }
            return count;
        }

        @NonNull
        public Object instantiateItem(@NonNull ViewGroup container, int position) {
            int realPosition = position;
            if (QMUIViewPager.this.mEnableLoop && this.mAdapter.getCount() != 0) {
                realPosition = position % this.mAdapter.getCount();
            }
            return this.mAdapter.instantiateItem(container, realPosition);
        }

        public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            int realPosition = position;
            if (QMUIViewPager.this.mEnableLoop && this.mAdapter.getCount() != 0) {
                realPosition = position % this.mAdapter.getCount();
            }
            this.mAdapter.destroyItem(container, realPosition, object);
        }

        public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
            return this.mAdapter.isViewFromObject(view, object);
        }

        public void restoreState(Parcelable bundle, ClassLoader classLoader) {
            this.mAdapter.restoreState(bundle, classLoader);
        }

        public Parcelable saveState() {
            return this.mAdapter.saveState();
        }

        public void startUpdate(@NonNull ViewGroup container) {
            this.mAdapter.startUpdate(container);
        }

        public void finishUpdate(@NonNull ViewGroup container) {
            this.mAdapter.finishUpdate(container);
        }

        public CharSequence getPageTitle(int position) {
            int virtualPosition = position % this.mAdapter.getCount();
            return this.mAdapter.getPageTitle(virtualPosition);
        }

        public float getPageWidth(int position) {
            return this.mAdapter.getPageWidth(position);
        }

        public void setPrimaryItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
            this.mAdapter.setPrimaryItem(container, position, object);
        }

        public void unregisterDataSetObserver(@NonNull DataSetObserver observer) {
            this.mAdapter.unregisterDataSetObserver(observer);
        }

        public void registerDataSetObserver(@NonNull DataSetObserver observer) {
            this.mAdapter.registerDataSetObserver(observer);
        }

        public void notifyDataSetChanged() {
            super.notifyDataSetChanged();
            this.mAdapter.notifyDataSetChanged();
        }

        public int getItemPosition(@NonNull Object object) {
            return this.mAdapter.getItemPosition(object);
        }
    }
}

