/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.layout.QMUILayoutHelper;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinValueBuilder;
import com.qmuiteam.qmui.skin.defaultAttr.IQMUISkinDefaultAttrProvider;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;
import com.qmuiteam.qmui.util.QMUIViewOffsetHelper;

public class QMUISlider
extends FrameLayout
implements IQMUISkinDefaultAttrProvider {
    public static final int PROGRESS_NOT_SET = -1;
    private Paint mBarPaint;
    private int mBarHeight;
    private int mBarNormalColor;
    private int mBarProgressColor;
    private int mRecordProgressColor;
    private boolean mConstraintThumbInMoving = true;
    private Callback mCallback;
    private IThumbView mThumbView;
    private QMUIViewOffsetHelper mThumbViewOffsetHelper;
    private int mTickCount;
    private int mCurrentProgress = 0;
    private boolean mIsProgressFirstSet = false;
    private boolean mClickToChangeProgress = false;
    private boolean mLongTouchToChangeProgress = false;
    private int mRecordProgress = -1;
    private int mDownTouchX = 0;
    private int mLastTouchX = 0;
    private boolean mIsThumbTouched = false;
    private boolean mIsMoving = false;
    private int mTouchSlop;
    private RectF mTempRect = new RectF();
    private LongPressAction mLongPressAction = new LongPressAction();
    private static SimpleArrayMap<String, Integer> sDefaultSkinAttrs = new SimpleArrayMap(2);

    public QMUISlider(@NonNull Context context) {
        this(context, null);
    }

    public QMUISlider(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.QMUISliderStyle);
    }

    public QMUISlider(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        boolean useClipChildrenByDeveloper;
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.QMUISlider, defStyleAttr, 0);
        this.mBarHeight = array.getDimensionPixelSize(R.styleable.QMUISlider_qmui_slider_bar_height, QMUIDisplayHelper.dp2px(context, 2));
        this.mBarNormalColor = array.getColor(R.styleable.QMUISlider_qmui_slider_bar_normal_color, -1);
        this.mBarProgressColor = array.getColor(R.styleable.QMUISlider_qmui_slider_bar_progress_color, -16776961);
        this.mRecordProgressColor = array.getColor(R.styleable.QMUISlider_qmui_slider_bar_record_progress_color, -7829368);
        this.mTickCount = array.getInt(R.styleable.QMUISlider_qmui_slider_bar_tick_count, 100);
        this.mConstraintThumbInMoving = array.getBoolean(R.styleable.QMUISlider_qmui_slider_bar_constraint_thumb_in_moving, true);
        int thumbSize = array.getDimensionPixelSize(R.styleable.QMUISlider_qmui_slider_bar_thumb_size, QMUIDisplayHelper.dp2px(this.getContext(), 24));
        int thumbStyleAttr = 0;
        String thumbStyleAttrString = array.getString(R.styleable.QMUISlider_qmui_slider_bar_thumb_style_attr);
        if (thumbStyleAttrString != null) {
            thumbStyleAttr = this.getResources().getIdentifier(thumbStyleAttrString, "attr", context.getPackageName());
        }
        if (!(useClipChildrenByDeveloper = array.getBoolean(R.styleable.QMUISlider_qmui_slider_bar_use_clip_children_by_developer, false))) {
            int paddingHor = array.getDimensionPixelOffset(R.styleable.QMUISlider_qmui_slider_bar_padding_hor_for_thumb_shadow, 0);
            int paddingVer = array.getDimensionPixelOffset(R.styleable.QMUISlider_qmui_slider_bar_padding_ver_for_thumb_shadow, 0);
            this.setPadding(paddingHor, paddingVer, paddingHor, paddingVer);
        }
        array.recycle();
        this.mBarPaint = new Paint();
        this.mBarPaint.setStyle(Paint.Style.FILL);
        this.mBarPaint.setAntiAlias(true);
        this.mTouchSlop = QMUIDisplayHelper.dp2px(context, 2);
        this.setWillNotDraw(false);
        this.setClipToPadding(false);
        this.setClipChildren(false);
        IThumbView thumbView = this.onCreateThumbView(context, thumbSize, thumbStyleAttr);
        if (!(thumbView instanceof View)) {
            throw new IllegalArgumentException("thumbView must be a instance of View");
        }
        this.mThumbView = thumbView;
        View thumbAsView = (View)thumbView;
        this.mThumbViewOffsetHelper = new QMUIViewOffsetHelper(thumbAsView);
        this.addView(thumbAsView, (ViewGroup.LayoutParams)this.onCreateThumbLayoutParams());
        thumbView.render(this.mCurrentProgress, this.mTickCount);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setCurrentProgress(int currentProgress) {
        int progress;
        if (!(this.mIsMoving || this.mCurrentProgress == (progress = QMUILangHelper.constrain(currentProgress, 0, this.mTickCount)) && this.mIsProgressFirstSet)) {
            this.mIsProgressFirstSet = true;
            this.safeSetCurrentProgress(progress);
            if (this.mCallback != null) {
                this.mCallback.onProgressChange(this, progress, this.mTickCount, false);
            }
            this.invalidate();
        }
    }

    public void setRecordProgress(int recordProgress) {
        if (recordProgress != this.mRecordProgress) {
            if (recordProgress != -1) {
                recordProgress = QMUILangHelper.constrain(recordProgress, 0, this.mTickCount);
            }
            this.mRecordProgress = recordProgress;
            this.invalidate();
        }
    }

    public int getCurrentProgress() {
        return this.mCurrentProgress;
    }

    public void setTickCount(int tickCount) {
        if (this.mTickCount != tickCount) {
            this.mTickCount = tickCount;
            this.setCurrentProgress(QMUILangHelper.constrain(this.mCurrentProgress, 0, this.mTickCount));
            this.mThumbView.render(this.mCurrentProgress, this.mTickCount);
            this.invalidate();
        }
    }

    public int getTickCount() {
        return this.mTickCount;
    }

    public void setThumbSkin(QMUISkinValueBuilder valueBuilder) {
        QMUISkinHelper.setSkinValue(this.convertThumbToView(), valueBuilder);
    }

    private void safeSetCurrentProgress(int currentProgress) {
        this.mCurrentProgress = currentProgress;
        this.mThumbView.render(currentProgress, this.mTickCount);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getMeasuredHeight() < this.mBarHeight) {
            super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)(this.mBarHeight + this.getPaddingTop() + this.getPaddingBottom()), (int)0x40000000));
        }
    }

    protected final void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.onLayoutCustomChildren(changed, left, top, right, bottom);
        View thumbView = this.convertThumbToView();
        int paddingTop = this.getPaddingTop();
        int thumbHeight = thumbView.getMeasuredHeight();
        int thumbWidth = thumbView.getMeasuredWidth();
        int l = this.getPaddingLeft() + this.mThumbView.getLeftRightMargin();
        int t = paddingTop + (bottom - top - paddingTop - this.getPaddingBottom() - thumbView.getMeasuredHeight()) / 2;
        thumbView.layout(l, t, l + thumbWidth, t + thumbHeight);
        this.mThumbViewOffsetHelper.onViewLayout();
    }

    protected void onLayoutCustomChildren(boolean changed, int left, int top, int right, int bottom) {
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int action = event.getAction();
        if (action == 0) {
            this.mLastTouchX = this.mDownTouchX = (int)event.getX();
            this.mIsThumbTouched = this.isThumbTouched(event.getX(), event.getY());
            if (this.mIsThumbTouched) {
                this.mThumbView.setPress(true);
            } else if (this.mLongTouchToChangeProgress) {
                this.removeCallbacks(this.mLongPressAction);
                this.postOnAnimationDelayed(this.mLongPressAction, 300L);
            }
            if (this.mCallback != null) {
                this.mCallback.onTouchDown(this, this.mCurrentProgress, this.mTickCount, this.mIsThumbTouched);
            }
        } else if (action == 2) {
            int x = (int)event.getX();
            int dx = x - this.mLastTouchX;
            this.mLastTouchX = x;
            if (!this.mIsMoving && this.mIsThumbTouched && Math.abs(this.mLastTouchX - this.mDownTouchX) > this.mTouchSlop) {
                this.removeCallbacks(this.mLongPressAction);
                this.mIsMoving = true;
                if (this.mCallback != null) {
                    this.mCallback.onStartMoving(this, this.mCurrentProgress, this.mTickCount);
                }
                dx = dx > 0 ? (dx -= this.mTouchSlop) : (dx += this.mTouchSlop);
            }
            if (this.mIsMoving) {
                QMUIViewHelper.safeRequestDisallowInterceptTouchEvent((View)this, true);
                int maxOffset = this.getMaxThumbOffset();
                int oldProgress = this.mCurrentProgress;
                if (this.mConstraintThumbInMoving) {
                    this.checkTouch(x, maxOffset);
                } else {
                    this.mThumbViewOffsetHelper.setLeftAndRightOffset(QMUILangHelper.constrain(this.mThumbViewOffsetHelper.getLeftAndRightOffset() + dx, 0, maxOffset));
                    this.calculateByThumbPosition(maxOffset);
                }
                if (this.mCallback != null && oldProgress != this.mCurrentProgress) {
                    this.mCallback.onProgressChange(this, this.mCurrentProgress, this.mTickCount, true);
                }
                this.invalidate();
            }
        } else if (action == 1 || action == 3) {
            this.removeCallbacks(this.mLongPressAction);
            this.mLastTouchX = -1;
            QMUIViewHelper.safeRequestDisallowInterceptTouchEvent((View)this, false);
            if (this.mIsMoving) {
                this.mIsMoving = false;
                if (this.mCallback != null) {
                    this.mCallback.onStopMoving(this, this.mCurrentProgress, this.mTickCount);
                }
            }
            if (this.mIsThumbTouched) {
                this.mIsThumbTouched = false;
                this.mThumbView.setPress(false);
            } else if (action == 1) {
                int x = (int)event.getX();
                boolean isRecordProgressClicked = this.isRecordProgressClicked(x);
                if (Math.abs(x - this.mDownTouchX) < this.mTouchSlop && (this.mClickToChangeProgress || isRecordProgressClicked)) {
                    int oldProgress = this.mCurrentProgress;
                    if (isRecordProgressClicked) {
                        this.safeSetCurrentProgress(this.mRecordProgress);
                    } else {
                        this.checkTouch(x, this.getMaxThumbOffset());
                    }
                    this.invalidate();
                    if (this.mCallback != null && oldProgress != this.mCurrentProgress) {
                        this.mCallback.onProgressChange(this, this.mCurrentProgress, this.mTickCount, true);
                    }
                }
            }
            if (this.mCallback != null) {
                this.mCallback.onTouchUp(this, this.mCurrentProgress, this.mTickCount);
            }
        } else {
            this.removeCallbacks(this.mLongPressAction);
        }
        return true;
    }

    private void checkTouch(int touchX, int maxOffset) {
        float step;
        if (this.mThumbView == null) {
            return;
        }
        int moveX = touchX - this.getPaddingLeft() - this.mThumbView.getLeftRightMargin();
        if ((float)moveX <= (step = (float)maxOffset / (float)this.mTickCount) / 2.0f) {
            this.mThumbViewOffsetHelper.setLeftAndRightOffset(0);
            this.safeSetCurrentProgress(0);
        } else if ((float)touchX >= (float)(this.getWidth() - this.getPaddingRight() - this.mThumbView.getLeftRightMargin()) - step / 2.0f) {
            this.mThumbViewOffsetHelper.setLeftAndRightOffset(maxOffset);
            this.safeSetCurrentProgress(this.mTickCount);
        } else {
            float percent = (float)moveX / (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - 2 * this.mThumbView.getLeftRightMargin());
            int target = (int)((float)this.mTickCount * percent + 0.5f);
            this.mThumbViewOffsetHelper.setLeftAndRightOffset((int)((float)target * step));
            this.safeSetCurrentProgress(target);
        }
    }

    public void setClickToChangeProgress(boolean clickToChangeProgress) {
        this.mClickToChangeProgress = clickToChangeProgress;
    }

    public void setLongTouchToChangeProgress(boolean longTouchToChangeProgress) {
        this.mLongTouchToChangeProgress = longTouchToChangeProgress;
    }

    public boolean isLongTouchToChangeProgress() {
        return this.mLongTouchToChangeProgress;
    }

    public boolean isClickToChangeProgress() {
        return this.mClickToChangeProgress;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int l = this.getPaddingLeft();
        int r = this.getWidth() - this.getPaddingRight();
        int bt = this.getPaddingTop() + (this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.mBarHeight) / 2;
        int bb = bt + this.mBarHeight;
        this.mBarPaint.setColor(this.mBarNormalColor);
        this.mTempRect.set((float)l, (float)bt, (float)r, (float)bb);
        this.drawRect(canvas, this.mTempRect, this.mBarHeight, this.mBarPaint, false);
        float step = (float)this.getMaxThumbOffset() / (float)this.mTickCount;
        int progressOffset = (int)(step * (float)this.mCurrentProgress);
        this.mBarPaint.setColor(this.mBarProgressColor);
        View thumb = this.convertThumbToView();
        if (thumb != null && thumb.getVisibility() == 0) {
            if (!this.mIsMoving) {
                this.mThumbViewOffsetHelper.setLeftAndRightOffset(progressOffset);
            }
            this.mTempRect.set((float)l, (float)bt, (float)(thumb.getRight() + thumb.getLeft()) / 2.0f, (float)bb);
            this.drawRect(canvas, this.mTempRect, this.mBarHeight, this.mBarPaint, true);
        } else {
            this.mTempRect.set((float)l, (float)bt, (float)(l + progressOffset), (float)bb);
            this.drawRect(canvas, this.mTempRect, this.mBarHeight, this.mBarPaint, true);
        }
        this.drawTick(canvas, this.mCurrentProgress, this.mTickCount, l, r, this.mTempRect.centerY(), this.mBarPaint, this.mBarNormalColor, this.mBarProgressColor);
        if (this.mRecordProgress != -1 && thumb != null) {
            this.mBarPaint.setColor(this.mRecordProgressColor);
            float recordPos = this.getPaddingLeft() + this.mThumbView.getLeftRightMargin() + (int)(step * (float)this.mRecordProgress);
            this.mTempRect.set(recordPos, (float)thumb.getTop(), recordPos + (float)thumb.getWidth(), (float)thumb.getBottom());
            this.drawRecordProgress(canvas, this.mTempRect, this.mBarPaint);
        }
    }

    protected void drawRect(Canvas canvas, RectF rect, int barHeight, Paint paint, boolean forProgress) {
        int radius = barHeight / 2;
        canvas.drawRoundRect(rect, (float)radius, (float)radius, paint);
    }

    protected void drawRecordProgress(Canvas canvas, RectF rect, Paint paint) {
        float radius = rect.height() / 2.0f;
        canvas.drawRoundRect(rect, radius, radius, paint);
    }

    protected void drawTick(Canvas canvas, int currentTickCount, int totalTickCount, int left, int right, float y, Paint paint, int barNormalColor, int barProgressColor) {
    }

    public void setBarHeight(int barHeight) {
        if (this.mBarHeight != barHeight) {
            this.mBarHeight = barHeight;
            this.requestLayout();
        }
    }

    public int getBarHeight() {
        return this.mBarHeight;
    }

    public void setBarNormalColor(int barNormalColor) {
        if (this.mBarNormalColor != barNormalColor) {
            this.mBarNormalColor = barNormalColor;
            this.invalidate();
        }
    }

    public int getBarNormalColor() {
        return this.mBarNormalColor;
    }

    public void setBarProgressColor(int barProgressColor) {
        if (this.mBarProgressColor != barProgressColor) {
            this.mBarProgressColor = barProgressColor;
            this.invalidate();
        }
    }

    public int getBarProgressColor() {
        return this.mBarProgressColor;
    }

    public void setRecordProgressColor(int recordProgressColor) {
        if (this.mRecordProgressColor != recordProgressColor) {
            this.mRecordProgressColor = recordProgressColor;
            this.invalidate();
        }
    }

    public int getRecordProgressColor() {
        return this.mRecordProgressColor;
    }

    public int getRecordProgress() {
        return this.mRecordProgress;
    }

    public void setConstraintThumbInMoving(boolean constraintThumbInMoving) {
        this.mConstraintThumbInMoving = constraintThumbInMoving;
    }

    private void calculateByThumbPosition(int maxOffset) {
        View thumbView = this.convertThumbToView();
        float percent = (float)this.mThumbViewOffsetHelper.getLeftAndRightOffset() * 1.0f / (float)maxOffset;
        this.safeSetCurrentProgress(QMUILangHelper.constrain((int)((float)this.mTickCount * percent + 0.5f), 0, this.mTickCount));
    }

    @NonNull
    protected IThumbView onCreateThumbView(Context context, int thumbSize, int thumbStyleAttr) {
        return new DefaultThumbView(context, thumbSize, thumbStyleAttr);
    }

    protected FrameLayout.LayoutParams onCreateThumbLayoutParams() {
        return new FrameLayout.LayoutParams(-2, -2);
    }

    private View convertThumbToView() {
        return (View)this.mThumbView;
    }

    private boolean isThumbTouched(float x, float y) {
        return this.isThumbViewTouched(this.convertThumbToView(), x, y);
    }

    protected boolean isThumbViewTouched(View thumbView, float x, float y) {
        return thumbView.getVisibility() == 0 && (float)thumbView.getLeft() <= x && (float)thumbView.getRight() >= x && (float)thumbView.getTop() <= y && (float)thumbView.getBottom() >= y;
    }

    protected boolean isRecordProgressClicked(int x) {
        if (this.mRecordProgress == -1) {
            return false;
        }
        View thumbView = this.convertThumbToView();
        float percent = (float)this.mRecordProgress * 1.0f / (float)this.mTickCount;
        float left = (float)(this.getWidth() - this.getPaddingLeft() - this.getPaddingRight()) * percent - (float)thumbView.getWidth() / 2.0f;
        float right = left + (float)thumbView.getWidth();
        return (float)x >= left && (float)x <= right;
    }

    private int getMaxThumbOffset() {
        return this.getWidth() - this.getPaddingLeft() - this.getPaddingRight() - this.mThumbView.getLeftRightMargin() * 2 - this.convertThumbToView().getWidth();
    }

    @Override
    public SimpleArrayMap<String, Integer> getDefaultSkinAttrs() {
        return sDefaultSkinAttrs;
    }

    static {
        sDefaultSkinAttrs.put((Object)"background", (Object)R.attr.qmui_skin_support_slider_bar_bg_color);
        sDefaultSkinAttrs.put((Object)"progressColor", (Object)R.attr.qmui_skin_support_slider_bar_progress_color);
        sDefaultSkinAttrs.put((Object)"hintColor", (Object)R.attr.qmui_skin_support_slider_record_progress_color);
    }

    class LongPressAction
    implements Runnable {
        LongPressAction() {
        }

        @Override
        public void run() {
            QMUISlider.this.mIsMoving = true;
            int oldProgress = QMUISlider.this.mCurrentProgress;
            QMUISlider.this.checkTouch(QMUISlider.this.mLastTouchX, QMUISlider.this.getMaxThumbOffset());
            QMUISlider.this.mIsThumbTouched = true;
            QMUISlider.this.mThumbView.setPress(true);
            if (QMUISlider.this.mCallback != null && oldProgress != QMUISlider.this.mCurrentProgress) {
                QMUISlider.this.mCallback.onLongTouch(QMUISlider.this, QMUISlider.this.mCurrentProgress, QMUISlider.this.mTickCount);
            }
        }
    }

    public static class DefaultThumbView
    extends View
    implements IThumbView,
    IQMUISkinDefaultAttrProvider {
        private final QMUILayoutHelper mLayoutHelper;
        private final int mSize;
        private static SimpleArrayMap<String, Integer> sDefaultSkinAttrs = new SimpleArrayMap(2);

        public DefaultThumbView(Context context, int size, int defAttr) {
            super(context, null, defAttr);
            this.mSize = size;
            this.mLayoutHelper = new QMUILayoutHelper(context, null, defAttr, this);
            this.mLayoutHelper.setRadius(size / 2);
            this.setPress(false);
        }

        protected void dispatchDraw(Canvas canvas) {
            super.dispatchDraw(canvas);
            this.mLayoutHelper.drawDividers(canvas, this.getWidth(), this.getHeight());
            this.mLayoutHelper.dispatchRoundBorderDraw(canvas);
        }

        public void setBorderColor(int color2) {
            this.mLayoutHelper.setBorderColor(color2);
            this.invalidate();
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            this.setMeasuredDimension(this.mSize, this.mSize);
        }

        @Override
        public void render(int progress, int tickCount) {
        }

        @Override
        public void setPress(boolean isPressed) {
        }

        @Override
        public int getLeftRightMargin() {
            return 0;
        }

        @Override
        public SimpleArrayMap<String, Integer> getDefaultSkinAttrs() {
            return sDefaultSkinAttrs;
        }

        static {
            sDefaultSkinAttrs.put((Object)"background", (Object)R.attr.qmui_skin_support_slider_thumb_bg_color);
            sDefaultSkinAttrs.put((Object)"border", (Object)R.attr.qmui_skin_support_slider_thumb_border_color);
        }
    }

    public static class DefaultCallback
    implements Callback {
        @Override
        public void onProgressChange(QMUISlider slider, int progress, int tickCount, boolean fromUser) {
        }

        @Override
        public void onTouchDown(QMUISlider slider, int progress, int tickCount, boolean hitThumb) {
        }

        @Override
        public void onTouchUp(QMUISlider slider, int progress, int tickCount) {
        }

        @Override
        public void onStartMoving(QMUISlider slider, int progress, int tickCount) {
        }

        @Override
        public void onStopMoving(QMUISlider slider, int progress, int tickCount) {
        }

        @Override
        public void onLongTouch(QMUISlider slider, int progress, int tickCount) {
        }
    }

    public static interface Callback {
        public void onProgressChange(QMUISlider var1, int var2, int var3, boolean var4);

        public void onTouchDown(QMUISlider var1, int var2, int var3, boolean var4);

        public void onTouchUp(QMUISlider var1, int var2, int var3);

        public void onStartMoving(QMUISlider var1, int var2, int var3);

        public void onStopMoving(QMUISlider var1, int var2, int var3);

        public void onLongTouch(QMUISlider var1, int var2, int var3);
    }

    public static interface IThumbView {
        public void render(int var1, int var2);

        public void setPress(boolean var1);

        public int getLeftRightMargin();
    }
}

