/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.widget.QMUISlider;

public class QMUISeekBar
extends QMUISlider {
    private int mTickHeight;
    private int mTickWidth;
    private static SimpleArrayMap<String, Integer> sDefaultSkinAttrs = new SimpleArrayMap(2);

    public QMUISeekBar(@NonNull Context context) {
        this(context, null);
    }

    public QMUISeekBar(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.QMUISeekBarStyle);
    }

    public QMUISeekBar(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray array = this.getContext().obtainStyledAttributes(attrs, R.styleable.QMUISeekBar, defStyleAttr, 0);
        this.mTickWidth = array.getDimensionPixelSize(R.styleable.QMUISeekBar_qmui_seek_bar_tick_width, QMUIDisplayHelper.dp2px(context, 1));
        this.mTickHeight = array.getDimensionPixelSize(R.styleable.QMUISeekBar_qmui_seek_bar_tick_height, QMUIDisplayHelper.dp2px(context, 4));
        array.recycle();
        this.setClickToChangeProgress(true);
    }

    public void setTickHeight(int tickHeight) {
        this.mTickHeight = tickHeight;
        this.invalidate();
    }

    public void setTickWidth(int tickWidth) {
        this.mTickWidth = tickWidth;
        this.invalidate();
    }

    public int getTickHeight() {
        return this.mTickHeight;
    }

    @Override
    protected void drawRect(Canvas canvas, RectF rect, int barHeight, Paint paint, boolean forProgress) {
        canvas.drawRect(rect, paint);
    }

    @Override
    protected void drawTick(Canvas canvas, int currentTickCount, int totalTickCount, int left, int right, float y, Paint paint, int barNormalColor, int barProgressColor) {
        if (this.mTickHeight <= 0 || this.mTickWidth <= 0 || totalTickCount < 1) {
            return;
        }
        float step = (float)(right - left - this.mTickWidth) / (float)totalTickCount;
        float t = y - (float)this.mTickHeight / 2.0f;
        float b = y + (float)this.mTickHeight / 2.0f;
        float x = (float)left + (float)this.mTickWidth / 2.0f;
        for (int i = 0; i <= totalTickCount; ++i) {
            float l = x - (float)this.mTickWidth / 2.0f;
            float r = x + (float)this.mTickWidth / 2.0f;
            paint.setColor(i <= currentTickCount ? barProgressColor : barNormalColor);
            paint.setStyle(Paint.Style.FILL);
            canvas.drawRect(l, t, r, b, paint);
            x += step;
        }
    }

    @Override
    public SimpleArrayMap<String, Integer> getDefaultSkinAttrs() {
        return sDefaultSkinAttrs;
    }

    static {
        sDefaultSkinAttrs.put((Object)"background", (Object)R.attr.qmui_skin_support_seek_bar_color);
        sDefaultSkinAttrs.put((Object)"progressColor", (Object)R.attr.qmui_skin_support_seek_bar_color);
    }
}

