/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.graphics.Insets;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.qmuiteam.qmui.R;

public class QMUIWindowInsetHelper {
    public static final InsetHandler consumeInsetWithPaddingHandler = new InsetHandler(){

        @Override
        public void handleInset(View view, Insets insets) {
            view.setPadding(insets.left, insets.top, insets.right, insets.bottom);
        }
    };
    public static final InsetHandler consumeInsetWithPaddingIgnoreBottomHandler = new InsetHandler(){

        @Override
        public void handleInset(View view, Insets insets) {
            view.setPadding(insets.left, insets.top, insets.right, 0);
        }
    };
    public static final InsetHandler consumeInsetWithPaddingIgnoreTopHandler = new InsetHandler(){

        @Override
        public void handleInset(View view, Insets insets) {
            view.setPadding(insets.left, 0, insets.right, insets.bottom);
        }
    };
    public static final InsetHandler consumeInsetWithPaddingWithGravityHandler = new InsetHandler(){

        @Override
        public void handleInset(View view, Insets insets) {
            Insets toUsed = QMUIWindowInsetHelper.adapterInsetsWithGravity(view, insets);
            view.setPadding(toUsed.left, toUsed.top, toUsed.right, toUsed.bottom);
        }
    };
    private static final OnApplyWindowInsetsListener sStopDispatchListener = new OnApplyWindowInsetsListener(){

        public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
            return WindowInsetsCompat.CONSUMED;
        }
    };
    private static final OnApplyWindowInsetsListener sOverrideWithNothingHandleListener = new OnApplyWindowInsetsListener(){

        public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
            return insets;
        }
    };

    public static void handleWindowInsets(View v, int insetsType) {
        QMUIWindowInsetHelper.handleWindowInsets(v, insetsType, false);
    }

    public static void handleWindowInsets(View v, int insetsType, boolean jumpSelfHandleIfMatchLast) {
        QMUIWindowInsetHelper.handleWindowInsets(v, insetsType, jumpSelfHandleIfMatchLast, false);
    }

    public static void handleWindowInsets(View v, int insetsType, boolean jumpSelfHandleIfMatchLast, boolean ignoreVisibility) {
        QMUIWindowInsetHelper.handleWindowInsets(v, insetsType, consumeInsetWithPaddingWithGravityHandler, jumpSelfHandleIfMatchLast, ignoreVisibility, false);
    }

    public static void handleWindowInsets(View v, int insetsType, boolean jumpSelfHandleIfMatchLast, boolean ignoreVisibility, boolean stopDispatch) {
        QMUIWindowInsetHelper.handleWindowInsets(v, insetsType, consumeInsetWithPaddingWithGravityHandler, jumpSelfHandleIfMatchLast, ignoreVisibility, stopDispatch);
    }

    public static void handleWindowInsets(View v, final int insetsType, final @NonNull InsetHandler insetHandler, boolean jumpSelfHandleIfMatchLast, final boolean ignoreVisibility, final boolean stopDispatch) {
        QMUIWindowInsetHelper.setOnApplyWindowInsetsListener(v, new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                if (v.getFitsSystemWindows()) {
                    Insets toUsed = ignoreVisibility ? insets.getInsetsIgnoringVisibility(insetsType) : insets.getInsets(insetsType);
                    insetHandler.handleInset(v, toUsed);
                    if (stopDispatch) {
                        return WindowInsetsCompat.CONSUMED;
                    }
                }
                return insets;
            }
        }, jumpSelfHandleIfMatchLast);
    }

    public static void stopDispatchWindowInsets(View v) {
        QMUIWindowInsetHelper.setOnApplyWindowInsetsListener(v, sStopDispatchListener, true);
    }

    public static void overrideWithDoNotHandleWindowInsets(View v) {
        QMUIWindowInsetHelper.setOnApplyWindowInsetsListener(v, sOverrideWithNothingHandleListener, false);
    }

    public static void setOnApplyWindowInsetsListener(final @NonNull View v, final @Nullable OnApplyWindowInsetsListener listener, final boolean reuseIfInputIsSame) {
        if (Build.VERSION.SDK_INT < 30) {
            v.setTag(R.id.tag_on_apply_window_listener, (Object)listener);
        }
        if (listener == null) {
            View.OnApplyWindowInsetsListener compatInsetsAnimationCallback = (View.OnApplyWindowInsetsListener)v.getTag(R.id.tag_window_insets_animation_callback);
            v.setOnApplyWindowInsetsListener(compatInsetsAnimationCallback);
            return;
        }
        v.setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){
            WindowInsetsCompat mLastInsets = null;
            WindowInsets mReturnedInsets = null;

            public WindowInsets onApplyWindowInsets(View view, WindowInsets insets) {
                WindowInsetsCompat compatInsets = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)insets, (View)view);
                boolean needRequestApplyInsetsAgain = true;
                if (Build.VERSION.SDK_INT < 30) {
                    QMUIWindowInsetHelper.callCompatInsetAnimationCallback(insets, v);
                    if (compatInsets.equals((Object)this.mLastInsets)) {
                        needRequestApplyInsetsAgain = false;
                        if (reuseIfInputIsSame) {
                            return this.mReturnedInsets;
                        }
                    }
                    this.mLastInsets = compatInsets;
                }
                compatInsets = listener.onApplyWindowInsets(view, compatInsets);
                if (Build.VERSION.SDK_INT >= 30) {
                    return compatInsets.toWindowInsets();
                }
                if (needRequestApplyInsetsAgain) {
                    ViewCompat.requestApplyInsets((View)view);
                }
                this.mReturnedInsets = compatInsets.toWindowInsets();
                return this.mReturnedInsets;
            }
        });
    }

    private static void callCompatInsetAnimationCallback(@NonNull WindowInsets insets, @NonNull View v) {
        View.OnApplyWindowInsetsListener insetsAnimationCallback = (View.OnApplyWindowInsetsListener)v.getTag(R.id.tag_window_insets_animation_callback);
        if (insetsAnimationCallback != null) {
            insetsAnimationCallback.onApplyWindowInsets(v, insets);
        }
    }

    public static Insets adapterInsetsWithGravity(View view, Insets insets) {
        int left = insets.left;
        int right = insets.right;
        int top = insets.top;
        int bottom = insets.bottom;
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp instanceof ConstraintLayout.LayoutParams) {
            ConstraintLayout.LayoutParams constraintLp = (ConstraintLayout.LayoutParams)lp;
            if (constraintLp.width == -2) {
                if (constraintLp.leftToLeft == 0) {
                    right = 0;
                } else if (constraintLp.rightToRight == 0) {
                    left = 0;
                }
            }
            if (constraintLp.height == -2) {
                if (constraintLp.topToTop == 0) {
                    bottom = 0;
                } else if (constraintLp.bottomToBottom == 0) {
                    top = 0;
                }
            }
        } else {
            int gravity = -1;
            if (lp instanceof FrameLayout.LayoutParams) {
                gravity = ((FrameLayout.LayoutParams)lp).gravity;
            }
            if (gravity == -1) {
                gravity = 51;
            }
            if (lp.width != -1) {
                int horizontalGravity = gravity & 7;
                switch (horizontalGravity) {
                    case 3: {
                        right = 0;
                        break;
                    }
                    case 5: {
                        left = 0;
                    }
                }
            }
            if (lp.height != -1) {
                int verticalGravity = gravity & 0x70;
                switch (verticalGravity) {
                    case 48: {
                        bottom = 0;
                        break;
                    }
                    case 80: {
                        top = 0;
                    }
                }
            }
        }
        return Insets.of((int)left, (int)top, (int)right, (int)bottom);
    }

    public static interface InsetHandler {
        public void handleInset(View var1, Insets var2);
    }
}

