/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUIDrawableHelper;
import com.qmuiteam.qmui.util.QMUIViewHelper;

public class QMUIResHelper {
    private static TypedValue sTmpValue;

    public static float getAttrFloatValue(Context context, int attr2) {
        return QMUIResHelper.getAttrFloatValue(context.getTheme(), attr2);
    }

    public static float getAttrFloatValue(Resources.Theme theme, int attr2) {
        if (sTmpValue == null) {
            sTmpValue = new TypedValue();
        }
        if (!theme.resolveAttribute(attr2, sTmpValue, true)) {
            return 0.0f;
        }
        return sTmpValue.getFloat();
    }

    public static int getAttrColor(Context context, int attrRes) {
        return QMUIResHelper.getAttrColor(context.getTheme(), attrRes);
    }

    public static int getAttrColor(Resources.Theme theme, int attr2) {
        if (sTmpValue == null) {
            sTmpValue = new TypedValue();
        }
        if (!theme.resolveAttribute(attr2, sTmpValue, true)) {
            return 0;
        }
        if (QMUIResHelper.sTmpValue.type == 2) {
            return QMUIResHelper.getAttrColor(theme, QMUIResHelper.sTmpValue.data);
        }
        return QMUIResHelper.sTmpValue.data;
    }

    @Nullable
    public static ColorStateList getAttrColorStateList(Context context, int attrRes) {
        return QMUIResHelper.getAttrColorStateList(context, context.getTheme(), attrRes);
    }

    @Nullable
    public static ColorStateList getAttrColorStateList(Context context, Resources.Theme theme, int attr2) {
        if (attr2 == 0) {
            return null;
        }
        if (sTmpValue == null) {
            sTmpValue = new TypedValue();
        }
        if (!theme.resolveAttribute(attr2, sTmpValue, true)) {
            return null;
        }
        if (QMUIResHelper.sTmpValue.type >= 28 && QMUIResHelper.sTmpValue.type <= 31) {
            return ColorStateList.valueOf((int)QMUIResHelper.sTmpValue.data);
        }
        if (QMUIResHelper.sTmpValue.type == 2) {
            return QMUIResHelper.getAttrColorStateList(context, theme, QMUIResHelper.sTmpValue.data);
        }
        if (QMUIResHelper.sTmpValue.resourceId == 0) {
            return null;
        }
        return ContextCompat.getColorStateList((Context)context, (int)QMUIResHelper.sTmpValue.resourceId);
    }

    @Nullable
    public static Drawable getAttrDrawable(Context context, int attr2) {
        return QMUIResHelper.getAttrDrawable(context, context.getTheme(), attr2);
    }

    @Nullable
    public static Drawable getAttrDrawable(Context context, Resources.Theme theme, int attr2) {
        if (attr2 == 0) {
            return null;
        }
        if (sTmpValue == null) {
            sTmpValue = new TypedValue();
        }
        if (!theme.resolveAttribute(attr2, sTmpValue, true)) {
            return null;
        }
        if (QMUIResHelper.sTmpValue.type >= 28 && QMUIResHelper.sTmpValue.type <= 31) {
            return new ColorDrawable(QMUIResHelper.sTmpValue.data);
        }
        if (QMUIResHelper.sTmpValue.type == 2) {
            return QMUIResHelper.getAttrDrawable(context, theme, QMUIResHelper.sTmpValue.data);
        }
        if (QMUIResHelper.sTmpValue.resourceId != 0) {
            return QMUIDrawableHelper.getVectorDrawable(context, QMUIResHelper.sTmpValue.resourceId);
        }
        return null;
    }

    @Nullable
    public static Drawable getAttrDrawable(Context context, TypedArray typedArray, int index) {
        TypedValue value = typedArray.peekValue(index);
        if (value != null && value.type != 2 && value.resourceId != 0) {
            return QMUIDrawableHelper.getVectorDrawable(context, value.resourceId);
        }
        return null;
    }

    public static int getAttrDimen(Context context, int attrRes) {
        if (sTmpValue == null) {
            sTmpValue = new TypedValue();
        }
        if (!context.getTheme().resolveAttribute(attrRes, sTmpValue, true)) {
            return 0;
        }
        return TypedValue.complexToDimensionPixelSize((int)QMUIResHelper.sTmpValue.data, (DisplayMetrics)QMUIDisplayHelper.getDisplayMetrics(context));
    }

    @Nullable
    public static String getAttrString(Context context, int attrRes) {
        if (sTmpValue == null) {
            sTmpValue = new TypedValue();
        }
        if (!context.getTheme().resolveAttribute(attrRes, sTmpValue, true)) {
            return null;
        }
        CharSequence str = QMUIResHelper.sTmpValue.string;
        return str == null ? null : str.toString();
    }

    public static int getAttrInt(Context context, int attrRes) {
        if (sTmpValue == null) {
            sTmpValue = new TypedValue();
        }
        context.getTheme().resolveAttribute(attrRes, sTmpValue, true);
        return QMUIResHelper.sTmpValue.data;
    }

    public static void assignTextViewWithAttr(TextView textView, int attrRes) {
        TypedArray a = textView.getContext().obtainStyledAttributes(null, R.styleable.QMUITextCommonStyleDef, attrRes, 0);
        int count = a.getIndexCount();
        int paddingLeft = textView.getPaddingLeft();
        int paddingRight = textView.getPaddingRight();
        int paddingTop = textView.getPaddingTop();
        int paddingBottom = textView.getPaddingBottom();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_gravity) {
                textView.setGravity(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_textColor) {
                textView.setTextColor(a.getColorStateList(attr2));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_textSize) {
                textView.setTextSize(0, (float)a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_paddingLeft) {
                paddingLeft = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_paddingRight) {
                paddingRight = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_paddingTop) {
                paddingTop = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_paddingBottom) {
                paddingBottom = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_singleLine) {
                textView.setSingleLine(a.getBoolean(attr2, false));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_ellipsize) {
                int ellipsize = a.getInt(attr2, 3);
                switch (ellipsize) {
                    case 1: {
                        textView.setEllipsize(TextUtils.TruncateAt.START);
                        break;
                    }
                    case 2: {
                        textView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
                        break;
                    }
                    case 3: {
                        textView.setEllipsize(TextUtils.TruncateAt.END);
                        break;
                    }
                    case 4: {
                        textView.setEllipsize(TextUtils.TruncateAt.MARQUEE);
                    }
                }
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_maxLines) {
                textView.setMaxLines(a.getInt(attr2, -1));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_background) {
                QMUIViewHelper.setBackgroundKeepingPadding((View)textView, a.getDrawable(attr2));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_lineSpacingExtra) {
                textView.setLineSpacing((float)a.getDimensionPixelSize(attr2, 0), 1.0f);
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_drawablePadding) {
                textView.setCompoundDrawablePadding(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.QMUITextCommonStyleDef_android_textColorHint) {
                textView.setHintTextColor(a.getColor(attr2, 0));
                continue;
            }
            if (attr2 != R.styleable.QMUITextCommonStyleDef_android_textStyle) continue;
            int styleIndex = a.getInt(attr2, -1);
            textView.setTypeface(null, styleIndex);
        }
        textView.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        a.recycle();
    }
}

