/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;

public class QMUIReflectHelper {
    private static final String TAG = "QMUIReflectHelper";

    private QMUIReflectHelper() {
    }

    public static <T> T getStaticFieldValue(Class<?> cls, String name) {
        if (null != cls && null != name) {
            try {
                Field field = QMUIReflectHelper.getField(cls, name);
                if (null != field) {
                    field.setAccessible(true);
                    return (T)field.get(cls);
                }
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("get static field " + name + " of " + cls + " error"), (Throwable)t);
            }
        }
        return null;
    }

    public static boolean setStaticFieldValue(Class<?> cls, String name, Object value) {
        if (null != cls && null != name) {
            try {
                Field field = QMUIReflectHelper.getField(cls, name);
                if (null != field) {
                    field.setAccessible(true);
                    field.set(cls, value);
                    return true;
                }
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("set static field " + name + " of " + cls + " error"), (Throwable)t);
            }
        }
        return false;
    }

    public static <T> T getFieldValue(Object obj, String name) {
        if (null != obj && null != name) {
            try {
                Field field = QMUIReflectHelper.getField(obj.getClass(), name);
                if (null != field) {
                    field.setAccessible(true);
                    return (T)field.get(obj);
                }
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("get field " + name + " of " + obj + " error"), (Throwable)t);
            }
        }
        return null;
    }

    public static <T> T getFieldValue(Object obj, Class<?> type) {
        if (null != obj && null != type) {
            try {
                Field field = QMUIReflectHelper.getField(obj.getClass(), type);
                if (null != field) {
                    field.setAccessible(true);
                    return (T)field.get(obj);
                }
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("get field with type " + type + " of " + obj + " error"), (Throwable)t);
            }
        }
        return null;
    }

    public static boolean setFieldValue(Object obj, String name, Object value) {
        if (null != obj && null != name) {
            try {
                Field field = QMUIReflectHelper.getField(obj.getClass(), name);
                if (null != field) {
                    field.setAccessible(true);
                    field.set(obj, value);
                    return true;
                }
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("set field " + name + " of " + obj + " error"), (Throwable)t);
            }
        }
        return false;
    }

    public static <T> T newInstance(String className, Object ... args) {
        try {
            return QMUIReflectHelper.newInstance(Class.forName(className), args);
        }
        catch (ClassNotFoundException e) {
            Log.w((String)TAG, (String)("new instance of " + className + " error"), (Throwable)e);
            return null;
        }
    }

    public static <T> T newInstance(Class<?> clazz, Object ... args) {
        Constructor<?>[] ctors;
        block2: for (Constructor<?> ctor : ctors = clazz.getDeclaredConstructors()) {
            Class<?>[] types = ctor.getParameterTypes();
            if (types.length != args.length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (null != args[i] && !types[i].isAssignableFrom(args[i].getClass())) continue block2;
            }
            try {
                ctor.setAccessible(true);
                return (T)ctor.newInstance(args);
            }
            catch (Throwable t) {
                Log.w((String)TAG, (String)("Invoke constructor " + ctor + " error"), (Throwable)t);
                return null;
            }
        }
        return null;
    }

    public static <T> T invokeStaticMethod(Class<?> klass, String name) {
        return QMUIReflectHelper.invokeStaticMethod(klass, name, new Class[0], new Object[0]);
    }

    public static <T> T invokeStaticMethod(Class<?> klass, String name, Class[] types, Object[] args) {
        if (null != klass && null != name && null != types && null != args && types.length == args.length) {
            try {
                Method method = QMUIReflectHelper.getMethod(klass, name, types);
                if (null != method) {
                    method.setAccessible(true);
                    return (T)method.invoke(klass, args);
                }
            }
            catch (Throwable e) {
                Log.w((String)TAG, (String)("Invoke " + name + "(" + Arrays.toString(types) + ") of " + klass + " error"), (Throwable)e);
            }
        }
        return null;
    }

    public static <T> T invokeMethod(Object obj, String name) {
        return QMUIReflectHelper.invokeMethod(obj, name, new Class[0], new Object[0]);
    }

    public static <T> T invokeMethod(Object obj, String name, Class[] types, Object[] args) {
        if (null != obj && null != name && null != types && null != args && types.length == args.length) {
            try {
                Method method = QMUIReflectHelper.getMethod(obj.getClass(), name, types);
                if (null != method) {
                    method.setAccessible(true);
                    return (T)method.invoke(obj, args);
                }
            }
            catch (Throwable e) {
                Log.w((String)TAG, (String)("Invoke " + name + "(" + Arrays.toString(types) + ") of " + obj + " error"), (Throwable)e);
            }
        }
        return null;
    }

    public static Field getField(Class<?> cls, String name) {
        try {
            return cls.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            Class<?> parent = cls.getSuperclass();
            if (null == parent) {
                return null;
            }
            return QMUIReflectHelper.getField(parent, name);
        }
    }

    public static Field getField(Class<?> cls, Class<?> type) {
        Field[] fields = cls.getDeclaredFields();
        if (fields.length <= 0) {
            Class<?> parent = cls.getSuperclass();
            if (null == parent) {
                return null;
            }
            return QMUIReflectHelper.getField(parent, type);
        }
        for (Field field : fields) {
            if (field.getType() != type) continue;
            return field;
        }
        return null;
    }

    private static Method getMethod(Class<?> cls, String name, Class<?>[] types) {
        try {
            return cls.getDeclaredMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            Class<?> parent = cls.getSuperclass();
            if (null == parent) {
                return null;
            }
            return QMUIReflectHelper.getMethod(parent, name, types);
        }
    }
}

