/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.util;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.Window;
import android.view.WindowManager;
import com.qmuiteam.qmui.util.QMUIDeviceHelper;
import com.qmuiteam.qmui.util.QMUINotchHelper;
import com.qmuiteam.qmui.util.QMUIStatusBarHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;

public class QMUIDisplayHelper {
    public static final float DENSITY = Resources.getSystem().getDisplayMetrics().density;
    private static final String TAG = "QMUIDisplayHelper";
    private static Boolean sHasCamera = null;
    private static final String VIVO_NAVIGATION_GESTURE = "navigation_gesture_on";
    private static final String HUAWAI_DISPLAY_NOTCH_STATUS = "display_notch_status";
    private static final String XIAOMI_DISPLAY_NOTCH_STATUS = "force_black";
    private static final String XIAOMI_FULLSCREEN_GESTURE = "force_fsg_nav_bar";

    public static DisplayMetrics getDisplayMetrics(Context context) {
        return context.getResources().getDisplayMetrics();
    }

    public static int dpToPx(int dpValue) {
        return (int)((float)dpValue * DENSITY + 0.5f);
    }

    public static int pxToDp(float pxValue) {
        return (int)(pxValue / DENSITY + 0.5f);
    }

    public static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static float getFontDensity(Context context) {
        return context.getResources().getDisplayMetrics().scaledDensity;
    }

    public static int getScreenWidth(Context context) {
        return QMUIDisplayHelper.getDisplayMetrics((Context)context).widthPixels;
    }

    public static int getScreenHeight(Context context) {
        int screenHeight = QMUIDisplayHelper.getDisplayMetrics((Context)context).heightPixels;
        if (QMUIDeviceHelper.isXiaomi() && QMUIDisplayHelper.xiaomiNavigationGestureEnabled(context)) {
            screenHeight += QMUIDisplayHelper.getResourceNavHeight(context);
        }
        return screenHeight;
    }

    public static int[] getRealScreenSize(Context context) {
        return QMUIDisplayHelper.doGetRealScreenSize(context);
    }

    private static int[] doGetRealScreenSize(Context context) {
        int[] size = new int[2];
        WindowManager w = (WindowManager)context.getSystemService("window");
        Display d = w.getDefaultDisplay();
        DisplayMetrics metrics = new DisplayMetrics();
        d.getMetrics(metrics);
        int widthPixels = metrics.widthPixels;
        int heightPixels = metrics.heightPixels;
        try {
            widthPixels = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)d, new Object[0]);
            heightPixels = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)d, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Build.VERSION.SDK_INT >= 17) {
            try {
                Point realSize = new Point();
                d.getRealSize(realSize);
                Display.class.getMethod("getRealSize", Point.class).invoke((Object)d, realSize);
                widthPixels = realSize.x;
                heightPixels = realSize.y;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        size[0] = widthPixels;
        size[1] = heightPixels;
        return size;
    }

    public static int getUsefulScreenWidth(Activity activity) {
        return QMUIDisplayHelper.getUsefulScreenWidth((Context)activity, QMUINotchHelper.hasNotch(activity));
    }

    public static int getUsefulScreenWidth(View view) {
        return QMUIDisplayHelper.getUsefulScreenWidth(view.getContext(), QMUINotchHelper.hasNotch(view));
    }

    public static int getUsefulScreenWidth(Context context, boolean hasNotch) {
        boolean isLandscape;
        int result = QMUIDisplayHelper.getRealScreenSize(context)[0];
        int orientation = context.getResources().getConfiguration().orientation;
        boolean bl = isLandscape = orientation == 2;
        if (!hasNotch) {
            if (isLandscape && QMUIDeviceHelper.isEssentialPhone() && Build.VERSION.SDK_INT < 26) {
                result -= 2 * QMUIStatusBarHelper.getStatusbarHeight(context);
            }
            return result;
        }
        if (isLandscape && QMUIDeviceHelper.isHuawei() && !QMUIDisplayHelper.huaweiIsNotchSetToShowInSetting(context)) {
            result -= QMUINotchHelper.getNotchSizeInHuawei(context)[1];
        }
        return result;
    }

    public static int getUsefulScreenHeight(Activity activity) {
        return QMUIDisplayHelper.getUsefulScreenHeight((Context)activity, QMUINotchHelper.hasNotch(activity));
    }

    public static int getUsefulScreenHeight(View view) {
        return QMUIDisplayHelper.getUsefulScreenHeight(view.getContext(), QMUINotchHelper.hasNotch(view));
    }

    private static int getUsefulScreenHeight(Context context, boolean hasNotch) {
        boolean isPortrait;
        int result = QMUIDisplayHelper.getRealScreenSize(context)[1];
        int orientation = context.getResources().getConfiguration().orientation;
        boolean bl = isPortrait = orientation == 1;
        if (!hasNotch) {
            if (isPortrait && QMUIDeviceHelper.isEssentialPhone() && Build.VERSION.SDK_INT < 26) {
                result -= 2 * QMUIStatusBarHelper.getStatusbarHeight(context);
            }
            return result;
        }
        return result;
    }

    public static boolean isNavMenuExist(Context context) {
        boolean hasMenuKey = ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
        return !hasMenuKey && !hasBackKey;
    }

    public static int dp2px(Context context, int dp) {
        return (int)((double)(QMUIDisplayHelper.getDensity(context) * (float)dp) + 0.5);
    }

    public static int sp2px(Context context, int sp) {
        return (int)((double)(QMUIDisplayHelper.getFontDensity(context) * (float)sp) + 0.5);
    }

    public static int px2dp(Context context, int px) {
        return (int)((double)((float)px / QMUIDisplayHelper.getDensity(context)) + 0.5);
    }

    public static int px2sp(Context context, int px) {
        return (int)((double)((float)px / QMUIDisplayHelper.getFontDensity(context)) + 0.5);
    }

    public static boolean hasStatusBar(Context context) {
        if (context instanceof Activity) {
            Activity activity = (Activity)context;
            WindowManager.LayoutParams attrs = activity.getWindow().getAttributes();
            return (attrs.flags & 0x400) != 1024;
        }
        return true;
    }

    public static int getActionBarHeight(Context context) {
        int actionBarHeight = 0;
        TypedValue tv = new TypedValue();
        if (context.getTheme().resolveAttribute(16843499, tv, true)) {
            actionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }
        return actionBarHeight;
    }

    public static int getStatusBarHeight(Context context) {
        if (QMUIDeviceHelper.isXiaomi()) {
            int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
            if (resourceId > 0) {
                return context.getResources().getDimensionPixelSize(resourceId);
            }
            return 0;
        }
        try {
            Class<?> c = Class.forName("com.android.internal.R$dimen");
            Object obj = c.newInstance();
            Field field = c.getField("status_bar_height");
            int x = Integer.parseInt(field.get(obj).toString());
            if (x > 0) {
                return context.getResources().getDimensionPixelSize(x);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static int getNavMenuHeight(Context context) {
        if (!QMUIDisplayHelper.isNavMenuExist(context)) {
            return 0;
        }
        int resourceNavHeight = QMUIDisplayHelper.getResourceNavHeight(context);
        if (resourceNavHeight >= 0) {
            return resourceNavHeight;
        }
        return QMUIDisplayHelper.getRealScreenSize(context)[1] - QMUIDisplayHelper.getScreenHeight(context);
    }

    private static int getResourceNavHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return -1;
    }

    public static final boolean hasCamera(Context context) {
        if (sHasCamera == null) {
            PackageManager pckMgr = context.getPackageManager();
            boolean flag = pckMgr.hasSystemFeature("android.hardware.camera.front");
            boolean flag1 = pckMgr.hasSystemFeature("android.hardware.camera");
            boolean flag2 = flag || flag1;
            sHasCamera = flag2;
        }
        return sHasCamera;
    }

    public static boolean hasHardwareMenuKey(Context context) {
        boolean flag = Build.VERSION.SDK_INT < 11 ? true : (Build.VERSION.SDK_INT >= 14 ? ViewConfiguration.get((Context)context).hasPermanentMenuKey() : false);
        return flag;
    }

    @SuppressLint(value={"MissingPermission"})
    public static boolean hasInternet(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return cm.getActiveNetworkInfo() != null;
    }

    public static boolean isPackageExist(Context context, String pckName) {
        try {
            PackageInfo pckInfo = context.getPackageManager().getPackageInfo(pckName, 0);
            if (pckInfo != null) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSdcardReady() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String getCurCountryLan(Context context) {
        Configuration config = context.getResources().getConfiguration();
        Locale sysLocale = Build.VERSION.SDK_INT >= 24 ? config.getLocales().get(0) : config.locale;
        return sysLocale.getLanguage() + "-" + sysLocale.getCountry();
    }

    public static boolean isZhCN(Context context) {
        Configuration config = context.getResources().getConfiguration();
        Locale sysLocale = Build.VERSION.SDK_INT >= 24 ? config.getLocales().get(0) : config.locale;
        String lang = sysLocale.getCountry();
        return lang.equalsIgnoreCase("CN");
    }

    public static void setFullScreen(Activity activity) {
        Window window = activity.getWindow();
        window.addFlags(512);
        window.addFlags(1024);
    }

    public static void cancelFullScreen(Activity activity) {
        Window window = activity.getWindow();
        window.clearFlags(1024);
        window.clearFlags(512);
    }

    public static boolean isFullScreen(Activity activity) {
        WindowManager.LayoutParams params = activity.getWindow().getAttributes();
        return (params.flags & 0x400) == 1024;
    }

    public static boolean isElevationSupported() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean hasNavigationBar(Context context) {
        boolean hasNav = QMUIDisplayHelper.deviceHasNavigationBar();
        if (!hasNav) {
            return false;
        }
        if (QMUIDeviceHelper.isVivo()) {
            return QMUIDisplayHelper.vivoNavigationGestureEnabled(context);
        }
        return true;
    }

    private static boolean deviceHasNavigationBar() {
        boolean haveNav = false;
        try {
            Class<?> windowManagerGlobalClass = Class.forName("android.view.WindowManagerGlobal");
            Method getWmServiceMethod = windowManagerGlobalClass.getDeclaredMethod("getWindowManagerService", new Class[0]);
            getWmServiceMethod.setAccessible(true);
            Object iWindowManager = getWmServiceMethod.invoke(null, new Object[0]);
            Class<?> iWindowManagerClass = iWindowManager.getClass();
            Method hasNavBarMethod = iWindowManagerClass.getDeclaredMethod("hasNavigationBar", new Class[0]);
            hasNavBarMethod.setAccessible(true);
            haveNav = (Boolean)hasNavBarMethod.invoke(iWindowManager, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return haveNav;
    }

    public static boolean vivoNavigationGestureEnabled(Context context) {
        int val = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)VIVO_NAVIGATION_GESTURE, (int)0);
        return val != 0;
    }

    public static boolean xiaomiNavigationGestureEnabled(Context context) {
        int val = Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)XIAOMI_FULLSCREEN_GESTURE, (int)0);
        return val != 0;
    }

    public static boolean huaweiIsNotchSetToShowInSetting(Context context) {
        int result = Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)HUAWAI_DISPLAY_NOTCH_STATUS, (int)0);
        return result == 0;
    }

    @TargetApi(value=17)
    public static boolean xiaomiIsNotchSetToShowInSetting(Context context) {
        return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)XIAOMI_DISPLAY_NOTCH_STATUS, (int)0) == 0;
    }
}

