/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.span;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.style.ImageSpan;
import android.view.View;
import androidx.annotation.NonNull;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerSpan;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.util.QMUIDrawableHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import org.jetbrains.annotations.NotNull;

public class QMUIAlignMiddleImageSpan
extends ImageSpan
implements IQMUISkinHandlerSpan {
    public static final int ALIGN_MIDDLE = -100;
    private float mFontWidthMultiple = -1.0f;
    private boolean mAvoidSuperChangeFontMetrics = false;
    private int mWidth;
    private Drawable mDrawable = this.getDrawable();
    private int mDrawableTintColorAttr;

    public QMUIAlignMiddleImageSpan(Drawable d, int verticalAlignment) {
        this(d, verticalAlignment, 0.0f);
    }

    public QMUIAlignMiddleImageSpan(@NonNull Drawable d, int verticalAlignment, float fontWidthMultiple) {
        super(d.mutate(), verticalAlignment);
        if (fontWidthMultiple >= 0.0f) {
            this.mFontWidthMultiple = fontWidthMultiple;
        }
    }

    public void setSkinSupportWithTintColor(View skinFollowView, int drawableTintColorAttr) {
        this.mDrawableTintColorAttr = drawableTintColorAttr;
        if (this.mDrawable != null && skinFollowView != null && drawableTintColorAttr != 0) {
            QMUIDrawableHelper.setDrawableTintColor(this.mDrawable, QMUISkinHelper.getSkinColor(skinFollowView, drawableTintColorAttr));
            skinFollowView.invalidate();
        }
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (this.mAvoidSuperChangeFontMetrics) {
            Drawable d = this.getDrawable();
            Rect rect = d.getBounds();
            this.mWidth = rect.right;
        } else {
            this.mWidth = super.getSize(paint, text, start, end, fm);
        }
        if (this.mFontWidthMultiple > 0.0f) {
            this.mWidth = (int)(paint.measureText("\u5b50") * this.mFontWidthMultiple);
        }
        return this.mWidth;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (this.mVerticalAlignment == -100) {
            Drawable d = this.mDrawable;
            canvas.save();
            Paint.FontMetricsInt fontMetricsInt = paint.getFontMetricsInt();
            int fontTop = y + fontMetricsInt.top;
            int fontMetricsHeight = fontMetricsInt.bottom - fontMetricsInt.top;
            int iconHeight = d.getBounds().bottom - d.getBounds().top;
            int iconTop = fontTop + (fontMetricsHeight - iconHeight) / 2;
            canvas.translate(x, (float)iconTop);
            d.draw(canvas);
            canvas.restore();
        } else {
            super.draw(canvas, text, start, end, x, top, y, bottom, paint);
        }
    }

    public void setAvoidSuperChangeFontMetrics(boolean avoidSuperChangeFontMetrics) {
        this.mAvoidSuperChangeFontMetrics = avoidSuperChangeFontMetrics;
    }

    @Override
    public void handle(@NotNull View view, @NotNull QMUISkinManager manager, int skinIndex, @NotNull Resources.Theme theme) {
        if (this.mDrawableTintColorAttr != 0) {
            QMUIDrawableHelper.setDrawableTintColor(this.mDrawable, QMUIResHelper.getAttrColor(theme, this.mDrawableTintColorAttr));
        }
    }
}

