/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.recyclerView;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.R;
import com.qmuiteam.qmui.skin.IQMUISkinHandlerDecoration;
import com.qmuiteam.qmui.skin.QMUISkinHelper;
import com.qmuiteam.qmui.skin.QMUISkinManager;
import com.qmuiteam.qmui.util.QMUILangHelper;
import com.qmuiteam.qmui.util.QMUIResHelper;
import com.qmuiteam.qmui.widget.section.QMUIStickySectionLayout;
import org.jetbrains.annotations.NotNull;

public class QMUIRVDraggableScrollBar
extends RecyclerView.ItemDecoration
implements IQMUISkinHandlerDecoration,
QMUIStickySectionLayout.DrawDecoration {
    private int[] STATE_PRESSED = new int[]{16842919};
    private int[] STATE_NORMAL = new int[0];
    private static final long DEFAULT_KEE_SHOW_DURATION = 800L;
    private static final long DEFAULT_TRANSITION_DURATION = 100L;
    private static final int MIN_COUNT_FOR_PERCENT_CALCULATE = 1000;
    RecyclerView mRecyclerView;
    QMUIStickySectionLayout mStickySectionLayout;
    private final int mStartMargin;
    private final int mEndMargin;
    private final int mInwardOffset;
    private final boolean mIsVerticalScroll;
    private final boolean mIsLocationInOppositeSide;
    private boolean mIsInDragging;
    private Drawable mScrollBarDrawable;
    private boolean mEnableScrollBarFadeInOut = false;
    private boolean mIsDraggable = true;
    private Callback mCallback;
    private long mKeepShownTime = 800L;
    private long mTransitionDuration = 100L;
    private long mStartTransitionTime = 0L;
    private int mBeginAlpha = -1;
    private int mTargetAlpha = -1;
    private int mCurrentAlpha = 255;
    private float mPercent = 0.0f;
    private int mDragInnerStart = 0;
    private int mScrollBarSkinRes = 0;
    private int mScrollBarSkinTintColorRes = 0;
    private Runnable mFadeScrollBarAction = new Runnable(){

        @Override
        public void run() {
            QMUIRVDraggableScrollBar.this.mTargetAlpha = 0;
            QMUIRVDraggableScrollBar.this.mBeginAlpha = QMUIRVDraggableScrollBar.this.mCurrentAlpha;
            QMUIRVDraggableScrollBar.this.mStartTransitionTime = System.currentTimeMillis();
            QMUIRVDraggableScrollBar.this.invalidate();
        }
    };
    private final RecyclerView.OnItemTouchListener mOnItemTouchListener = new RecyclerView.OnItemTouchListener(){

        public boolean onInterceptTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
            if (!QMUIRVDraggableScrollBar.this.mIsDraggable || QMUIRVDraggableScrollBar.this.mScrollBarDrawable == null || !QMUIRVDraggableScrollBar.this.needDrawScrollBar(rv)) {
                return false;
            }
            int action = e.getAction();
            int x = (int)e.getX();
            int y = (int)e.getY();
            if (action == 0) {
                Rect bounds = QMUIRVDraggableScrollBar.this.mScrollBarDrawable.getBounds();
                if (QMUIRVDraggableScrollBar.this.mCurrentAlpha > 0 && bounds.contains(x, y)) {
                    QMUIRVDraggableScrollBar.this.startDrag();
                    QMUIRVDraggableScrollBar.this.mDragInnerStart = QMUIRVDraggableScrollBar.this.mIsVerticalScroll ? y - bounds.top : x - bounds.left;
                }
            } else if (action == 2) {
                if (QMUIRVDraggableScrollBar.this.mIsInDragging) {
                    QMUIRVDraggableScrollBar.this.onDragging(rv, QMUIRVDraggableScrollBar.this.mScrollBarDrawable, x, y);
                }
            } else if ((action == 1 || action == 3) && QMUIRVDraggableScrollBar.this.mIsInDragging) {
                QMUIRVDraggableScrollBar.this.onDragging(rv, QMUIRVDraggableScrollBar.this.mScrollBarDrawable, x, y);
                QMUIRVDraggableScrollBar.this.endDrag();
            }
            return QMUIRVDraggableScrollBar.this.mIsInDragging;
        }

        public void onTouchEvent(@NonNull RecyclerView rv, @NonNull MotionEvent e) {
            if (!QMUIRVDraggableScrollBar.this.mIsDraggable || QMUIRVDraggableScrollBar.this.mScrollBarDrawable == null || !QMUIRVDraggableScrollBar.this.needDrawScrollBar(rv)) {
                return;
            }
            int action = e.getAction();
            int x = (int)e.getX();
            int y = (int)e.getY();
            if (action == 0) {
                Rect bounds = QMUIRVDraggableScrollBar.this.mScrollBarDrawable.getBounds();
                if (QMUIRVDraggableScrollBar.this.mCurrentAlpha > 0 && bounds.contains(x, y)) {
                    QMUIRVDraggableScrollBar.this.startDrag();
                    QMUIRVDraggableScrollBar.this.mDragInnerStart = QMUIRVDraggableScrollBar.this.mIsVerticalScroll ? y - bounds.top : x - bounds.left;
                }
            } else if (action == 2) {
                if (QMUIRVDraggableScrollBar.this.mIsInDragging) {
                    QMUIRVDraggableScrollBar.this.onDragging(rv, QMUIRVDraggableScrollBar.this.mScrollBarDrawable, x, y);
                }
            } else if ((action == 1 || action == 3) && QMUIRVDraggableScrollBar.this.mIsInDragging) {
                QMUIRVDraggableScrollBar.this.onDragging(rv, QMUIRVDraggableScrollBar.this.mScrollBarDrawable, x, y);
                QMUIRVDraggableScrollBar.this.endDrag();
            }
        }

        public void onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
            if (disallowIntercept && QMUIRVDraggableScrollBar.this.mIsInDragging) {
                QMUIRVDraggableScrollBar.this.endDrag();
            }
        }
    };
    private RecyclerView.OnScrollListener mScrollListener = new RecyclerView.OnScrollListener(){
        private int mPrevStatus = 0;

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            if (QMUIRVDraggableScrollBar.this.mEnableScrollBarFadeInOut) {
                if (this.mPrevStatus == 0 && newState != 0) {
                    QMUIRVDraggableScrollBar.this.mStartTransitionTime = System.currentTimeMillis();
                    QMUIRVDraggableScrollBar.this.mBeginAlpha = QMUIRVDraggableScrollBar.this.mCurrentAlpha;
                    QMUIRVDraggableScrollBar.this.mTargetAlpha = 255;
                    QMUIRVDraggableScrollBar.this.invalidate();
                } else if (newState == 0) {
                    recyclerView.postDelayed(QMUIRVDraggableScrollBar.this.mFadeScrollBarAction, QMUIRVDraggableScrollBar.this.mKeepShownTime);
                }
            }
            this.mPrevStatus = newState;
        }
    };

    public QMUIRVDraggableScrollBar(int startMargin, int endMargin, int inwardOffset, boolean isVerticalScroll, boolean isLocationInOppositeSide) {
        this.mStartMargin = startMargin;
        this.mEndMargin = endMargin;
        this.mInwardOffset = inwardOffset;
        this.mIsVerticalScroll = isVerticalScroll;
        this.mIsLocationInOppositeSide = isLocationInOppositeSide;
    }

    public QMUIRVDraggableScrollBar(int startMargin, int endMargin, int inwardOffset) {
        this(startMargin, endMargin, inwardOffset, true, false);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    private void invalidate() {
        if (this.mStickySectionLayout != null) {
            this.mStickySectionLayout.invalidate();
        } else if (this.mRecyclerView != null) {
            this.mRecyclerView.invalidate();
        }
    }

    public void setScrollBarDrawable(@Nullable Drawable scrollBarDrawable) {
        this.mScrollBarDrawable = scrollBarDrawable;
        if (scrollBarDrawable != null) {
            scrollBarDrawable.setState(this.mIsInDragging ? this.STATE_PRESSED : this.STATE_NORMAL);
        }
        if (this.mRecyclerView != null) {
            QMUISkinHelper.refreshRVItemDecoration(this.mRecyclerView, this);
        }
        this.invalidate();
    }

    public void setScrollBarSkinRes(int scrollBarSkinRes) {
        this.mScrollBarSkinRes = scrollBarSkinRes;
        if (this.mRecyclerView != null) {
            QMUISkinHelper.refreshRVItemDecoration(this.mRecyclerView, this);
        }
        this.invalidate();
    }

    public void setScrollBarSkinTintColorRes(int colorRes) {
        this.mScrollBarSkinTintColorRes = colorRes;
        if (this.mRecyclerView != null) {
            QMUISkinHelper.refreshRVItemDecoration(this.mRecyclerView, this);
        }
        this.invalidate();
    }

    public void setDraggable(boolean draggable) {
        this.mIsDraggable = draggable;
    }

    public boolean isDraggable() {
        return this.mIsDraggable;
    }

    public void setEnableScrollBarFadeInOut(boolean enableScrollBarFadeInOut) {
        if (this.mEnableScrollBarFadeInOut != enableScrollBarFadeInOut) {
            this.mEnableScrollBarFadeInOut = enableScrollBarFadeInOut;
            if (!this.mEnableScrollBarFadeInOut) {
                this.mBeginAlpha = -1;
                this.mTargetAlpha = -1;
                this.mCurrentAlpha = 255;
            } else if (this.mRecyclerView != null) {
                if (this.mRecyclerView.getScrollState() == 0) {
                    this.mCurrentAlpha = 0;
                }
            } else {
                this.mCurrentAlpha = 0;
            }
            this.invalidate();
        }
    }

    public boolean isEnableScrollBarFadeInOut() {
        return this.mEnableScrollBarFadeInOut;
    }

    private void commonAttachToRecyclerView(@Nullable RecyclerView recyclerView) {
        if (this.mRecyclerView == recyclerView) {
            return;
        }
        if (this.mRecyclerView != null) {
            this.destroyCallbacks();
        }
        this.mRecyclerView = recyclerView;
        if (recyclerView != null) {
            this.setupCallbacks();
            QMUISkinHelper.refreshRVItemDecoration(recyclerView, this);
        }
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) {
        if (this.mStickySectionLayout != null) {
            this.mStickySectionLayout.removeDrawDecoration(this);
            this.mStickySectionLayout = null;
        }
        this.commonAttachToRecyclerView(recyclerView);
    }

    public void attachToStickSectionLayout(@Nullable QMUIStickySectionLayout stickySectionLayout) {
        if (this.mStickySectionLayout == stickySectionLayout) {
            return;
        }
        if (this.mStickySectionLayout != null) {
            this.mStickySectionLayout.removeDrawDecoration(this);
        }
        this.mStickySectionLayout = stickySectionLayout;
        if (stickySectionLayout != null) {
            stickySectionLayout.addDrawDecoration(this);
            this.commonAttachToRecyclerView(stickySectionLayout.getRecyclerView());
        }
    }

    private void setupCallbacks() {
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)this);
        this.mRecyclerView.addOnItemTouchListener(this.mOnItemTouchListener);
        this.mRecyclerView.addOnScrollListener(this.mScrollListener);
    }

    private void destroyCallbacks() {
        this.mRecyclerView.removeItemDecoration((RecyclerView.ItemDecoration)this);
        this.mRecyclerView.removeOnItemTouchListener(this.mOnItemTouchListener);
        this.mRecyclerView.removeCallbacks(this.mFadeScrollBarAction);
        this.mRecyclerView.removeOnScrollListener(this.mScrollListener);
    }

    private void startDrag() {
        this.mIsInDragging = true;
        if (this.mScrollBarDrawable != null) {
            this.mScrollBarDrawable.setState(this.STATE_PRESSED);
        }
        if (this.mCallback != null) {
            this.mCallback.onDragStarted();
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.removeCallbacks(this.mFadeScrollBarAction);
        }
        this.invalidate();
    }

    private void endDrag() {
        this.mIsInDragging = false;
        if (this.mScrollBarDrawable != null) {
            this.mScrollBarDrawable.setState(this.STATE_NORMAL);
        }
        if (this.mCallback != null) {
            this.mCallback.onDragEnd();
        }
        this.invalidate();
    }

    private void onDragging(RecyclerView recyclerView, Drawable drawable2, int x, int y) {
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        int usefulSpace = this.getUsefulSpace(recyclerView) - (this.mIsVerticalScroll ? drawableHeight : drawableWidth);
        int useValue = this.mIsVerticalScroll ? y : x;
        float percent = (float)(useValue - this.mStartMargin - this.mDragInnerStart) * 1.0f / (float)usefulSpace;
        percent = QMUILangHelper.constrain(percent, 0.0f, 1.0f);
        if (this.mCallback != null) {
            this.mCallback.onDragToPercent(percent);
        }
        this.mPercent = percent;
        if (percent <= 0.0f) {
            recyclerView.scrollToPosition(0);
        } else if (percent >= 1.0f) {
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            if (adapter != null) {
                recyclerView.scrollToPosition(adapter.getItemCount() - 1);
            }
        } else {
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (adapter != null && adapter.getItemCount() > 1000 && layoutManager instanceof LinearLayoutManager) {
                ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset((int)((float)adapter.getItemCount() * this.mPercent), 0);
            } else {
                int range = this.getScrollRange(recyclerView);
                int offset = this.getCurrentOffset(recyclerView);
                int delta = (int)((float)range * this.mPercent - (float)offset);
                if (this.mIsVerticalScroll) {
                    recyclerView.scrollBy(0, delta);
                } else {
                    recyclerView.scrollBy(delta, 0);
                }
            }
        }
        this.invalidate();
    }

    public void onDrawOver(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        if (this.mStickySectionLayout == null) {
            this.drawScrollBar(c, parent);
        }
    }

    @Override
    public void onDraw(@NonNull Canvas c, @NonNull QMUIStickySectionLayout parent) {
    }

    @Override
    public void onDrawOver(@NonNull Canvas c, @NonNull QMUIStickySectionLayout parent) {
        if (this.mRecyclerView != null) {
            this.drawScrollBar(c, this.mRecyclerView);
        }
    }

    private void drawScrollBar(@NonNull Canvas c, @NonNull RecyclerView recyclerView) {
        Drawable drawable2 = this.ensureScrollBar(recyclerView.getContext());
        if (drawable2 == null || !this.needDrawScrollBar(recyclerView)) {
            return;
        }
        if (this.mTargetAlpha != -1 && this.mBeginAlpha != -1) {
            long duration;
            long transitionTime = System.currentTimeMillis() - this.mStartTransitionTime;
            if (transitionTime >= (duration = this.mTransitionDuration * (long)Math.abs(this.mTargetAlpha - this.mBeginAlpha) / 255L)) {
                this.mCurrentAlpha = this.mTargetAlpha;
                this.mTargetAlpha = -1;
                this.mBeginAlpha = -1;
            } else {
                this.mCurrentAlpha = (int)((float)this.mBeginAlpha + (float)((long)(this.mTargetAlpha - this.mBeginAlpha) * transitionTime) * 1.0f / (float)duration);
                recyclerView.postInvalidateOnAnimation();
            }
        }
        drawable2.setAlpha(this.mCurrentAlpha);
        if (!this.mIsInDragging) {
            this.mPercent = this.calculatePercent(recyclerView);
        }
        this.setScrollBarBounds(recyclerView, drawable2);
        drawable2.draw(c);
    }

    private int getUsefulSpace(@NonNull RecyclerView recyclerView) {
        if (this.mIsVerticalScroll) {
            return recyclerView.getHeight() - this.mStartMargin - this.mEndMargin;
        }
        return recyclerView.getWidth() - this.mStartMargin - this.mEndMargin;
    }

    private boolean needDrawScrollBar(RecyclerView recyclerView) {
        if (this.mIsVerticalScroll) {
            return recyclerView.canScrollVertically(-1) || recyclerView.canScrollVertically(1);
        }
        return recyclerView.canScrollHorizontally(-1) || recyclerView.canScrollHorizontally(1);
    }

    private void setScrollBarBounds(@NonNull RecyclerView recyclerView, @NonNull Drawable drawable2) {
        int left;
        int top;
        int usefulSpace = this.getUsefulSpace(recyclerView);
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        if (this.mIsVerticalScroll) {
            top = (int)((float)(usefulSpace - drawableHeight) * this.mPercent);
            left = this.mIsLocationInOppositeSide ? this.mInwardOffset : recyclerView.getWidth() - drawableWidth - this.mInwardOffset;
        } else {
            left = (int)((float)(usefulSpace - drawableWidth) * this.mPercent);
            top = this.mIsLocationInOppositeSide ? this.mInwardOffset : recyclerView.getHeight() - drawableHeight - this.mInwardOffset;
        }
        drawable2.setBounds(left, top, left + drawableWidth, top + drawableHeight);
    }

    private int getScrollRange(@NonNull RecyclerView recyclerView) {
        if (this.mIsVerticalScroll) {
            return recyclerView.computeVerticalScrollRange() - recyclerView.getHeight();
        }
        return recyclerView.computeHorizontalScrollRange() - recyclerView.getWidth();
    }

    private int getCurrentOffset(@NonNull RecyclerView recyclerView) {
        if (this.mIsVerticalScroll) {
            return recyclerView.computeVerticalScrollOffset();
        }
        return recyclerView.computeHorizontalScrollOffset();
    }

    private float calculatePercent(@NonNull RecyclerView recyclerView) {
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (adapter != null && adapter.getItemCount() > 1000 && layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            return (float)linearLayoutManager.findFirstCompletelyVisibleItemPosition() * 1.0f / (float)adapter.getItemCount();
        }
        return QMUILangHelper.constrain((float)this.getCurrentOffset(recyclerView) * 1.0f / (float)this.getScrollRange(recyclerView), 0.0f, 1.0f);
    }

    public Drawable ensureScrollBar(Context context) {
        if (this.mScrollBarDrawable == null) {
            this.setScrollBarDrawable(ContextCompat.getDrawable((Context)context, (int)R.drawable.qmui_icon_scroll_bar));
        }
        return this.mScrollBarDrawable;
    }

    @Override
    public void handle(@NotNull @NonNull RecyclerView recyclerView, @NotNull @NonNull QMUISkinManager manager, int skinIndex, @NotNull @NonNull Resources.Theme theme) {
        if (this.mScrollBarSkinRes != 0) {
            this.mScrollBarDrawable = QMUIResHelper.getAttrDrawable(recyclerView.getContext(), theme, this.mScrollBarSkinRes);
        } else if (this.mScrollBarSkinTintColorRes != 0 && this.mScrollBarDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mScrollBarDrawable, (ColorStateList)QMUIResHelper.getAttrColorStateList(recyclerView.getContext(), theme, this.mScrollBarSkinTintColorRes));
        }
        this.invalidate();
    }

    public static interface Callback {
        public void onDragStarted();

        public void onDragToPercent(float var1);

        public void onDragEnd();
    }
}

