/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.nestedScroll;

import android.content.Context;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedScrollCommon;
import com.qmuiteam.qmui.nestedScroll.IQMUIContinuousNestedTopView;

public class QMUIContinuousNestedTopRecyclerView
extends RecyclerView
implements IQMUIContinuousNestedTopView {
    public static final String KEY_SCROLL_INFO_POSITION = "@qmui_scroll_info_top_rv_pos";
    public static final String KEY_SCROLL_INFO_OFFSET = "@qmui_scroll_info_top_rv_offset";
    private IQMUIContinuousNestedScrollCommon.OnScrollNotifier mScrollNotifier;
    private final int[] mScrollConsumed = new int[2];

    public QMUIContinuousNestedTopRecyclerView(@NonNull Context context) {
        this(context, null);
        this.init();
    }

    public QMUIContinuousNestedTopRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
        this.init();
    }

    public QMUIContinuousNestedTopRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.setVerticalScrollBarEnabled(false);
    }

    @Override
    public int consumeScroll(int dyUnconsumed) {
        if (dyUnconsumed == Integer.MIN_VALUE) {
            this.scrollToPosition(0);
            return Integer.MIN_VALUE;
        }
        if (dyUnconsumed == Integer.MAX_VALUE) {
            RecyclerView.Adapter adapter = this.getAdapter();
            if (adapter != null) {
                this.scrollToPosition(adapter.getItemCount() - 1);
            }
            return Integer.MAX_VALUE;
        }
        boolean reStartNestedScroll = false;
        if (!this.hasNestedScrollingParent(0)) {
            reStartNestedScroll = true;
            this.startNestedScroll(2, 0);
            this.mScrollConsumed[0] = 0;
            this.mScrollConsumed[1] = 0;
            this.dispatchNestedPreScroll(0, dyUnconsumed, this.mScrollConsumed, null, 0);
            dyUnconsumed -= this.mScrollConsumed[1];
        }
        this.scrollBy(0, dyUnconsumed);
        if (reStartNestedScroll) {
            this.stopNestedScroll(0);
        }
        return 0;
    }

    @Override
    public int getCurrentScroll() {
        return this.computeVerticalScrollOffset();
    }

    @Override
    public int getScrollOffsetRange() {
        return Math.max(0, this.computeVerticalScrollRange() - this.getHeight());
    }

    @Override
    public void injectScrollNotifier(IQMUIContinuousNestedScrollCommon.OnScrollNotifier notifier) {
        this.mScrollNotifier = notifier;
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        if (this.mScrollNotifier != null) {
            this.mScrollNotifier.notify(this.getCurrentScroll(), this.getScrollOffsetRange());
        }
    }

    @Override
    public void saveScrollInfo(@NonNull Bundle bundle) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            LinearLayoutManager lm = (LinearLayoutManager)layoutManager;
            int pos = lm.findFirstVisibleItemPosition();
            View firstView = lm.findViewByPosition(pos);
            int offset = firstView == null ? 0 : firstView.getTop();
            bundle.putInt(KEY_SCROLL_INFO_POSITION, pos);
            bundle.putInt(KEY_SCROLL_INFO_OFFSET, offset);
        }
    }

    @Override
    public void restoreScrollInfo(@NonNull Bundle bundle) {
        RecyclerView.LayoutManager layoutManager = this.getLayoutManager();
        if (layoutManager instanceof LinearLayoutManager) {
            int pos = bundle.getInt(KEY_SCROLL_INFO_POSITION, 0);
            int offset = bundle.getInt(KEY_SCROLL_INFO_OFFSET, 0);
            ((LinearLayoutManager)layoutManager).scrollToPositionWithOffset(pos, offset);
            if (this.mScrollNotifier != null) {
                this.mScrollNotifier.notify(this.getCurrentScroll(), this.getScrollOffsetRange());
            }
        }
    }
}

