/*
 * Decompiled with CFR 0.152.
 */
package com.qmuiteam.qmui.widget.webview;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;
import com.qmuiteam.qmui.util.QMUINotchHelper;
import com.qmuiteam.qmui.util.QMUIWindowInsetHelper;
import com.qmuiteam.qmui.widget.IWindowInsetLayout;
import com.qmuiteam.qmui.widget.webview.QMUIWebViewClient;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class QMUIWebView
extends WebView
implements IWindowInsetLayout {
    private static final String TAG = "QMUIWebView";
    private static boolean sIsReflectionOccurError = false;
    private Object mAwContents;
    private Object mWebContents;
    private Method mSetDisplayCutoutSafeAreaMethod;
    private Rect mSafeAreaRectCache;
    private boolean mNeedDispatchSafeAreaInset = false;
    private Callback mCallback;
    private List<OnScrollChangeListener> mOnScrollChangeListeners = new ArrayList<OnScrollChangeListener>();
    private QMUIWindowInsetHelper mWindowInsetHelper;

    public QMUIWebView(Context context) {
        super(context);
        this.init();
    }

    public QMUIWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public QMUIWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.removeJavascriptInterface("searchBoxJavaBridge_");
        this.removeJavascriptInterface("accessibility");
        this.removeJavascriptInterface("accessibilityTraversal");
        this.mWindowInsetHelper = new QMUIWindowInsetHelper((ViewGroup)this, this);
    }

    public void addJavascriptInterface(Object object, String name) {
    }

    @Deprecated
    public void setCustomOnScrollChangeListener(OnScrollChangeListener onScrollChangeListener) {
        this.addCustomOnScrollChangeListener(onScrollChangeListener);
    }

    public void addCustomOnScrollChangeListener(OnScrollChangeListener listener) {
        if (!this.mOnScrollChangeListeners.contains(listener)) {
            this.mOnScrollChangeListeners.add(listener);
        }
    }

    public void removeOnScrollChangeListener(OnScrollChangeListener listener) {
        this.mOnScrollChangeListeners.remove(listener);
    }

    public void removeAllOnScrollChangeListener() {
        this.mOnScrollChangeListeners.clear();
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        for (OnScrollChangeListener onScrollListener : this.mOnScrollChangeListeners) {
            onScrollListener.onScrollChange(this, l, t, oldl, oldt);
        }
    }

    public void setWebViewClient(WebViewClient client) {
        if (client != null && !(client instanceof QMUIWebViewClient)) {
            throw new IllegalArgumentException("must use the instance of QMUIWebViewClient");
        }
        super.setWebViewClient(client);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event);
    }

    public void setNeedDispatchSafeAreaInset(boolean needDispatchSafeAreaInset) {
        if (this.mNeedDispatchSafeAreaInset != needDispatchSafeAreaInset) {
            this.mNeedDispatchSafeAreaInset = needDispatchSafeAreaInset;
            if (ViewCompat.isAttachedToWindow((View)this)) {
                if (needDispatchSafeAreaInset) {
                    ViewCompat.requestApplyInsets((View)this);
                } else {
                    this.setStyleDisplayCutoutSafeArea(new Rect());
                }
            }
        }
    }

    public boolean isNeedDispatchSafeAreaInset() {
        return this.mNeedDispatchSafeAreaInset;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    private void doNotSupportChangeCssEnv() {
        sIsReflectionOccurError = true;
        if (this.mCallback != null) {
            this.mCallback.onSureNotSupportChangeCssEnv();
        }
    }

    boolean isNotSupportChangeCssEnv() {
        return sIsReflectionOccurError;
    }

    @Override
    public boolean applySystemWindowInsets19(Rect insets) {
        return false;
    }

    @Override
    public boolean applySystemWindowInsets21(Object insets) {
        int bottom;
        int right;
        int top;
        int left;
        if (!this.mNeedDispatchSafeAreaInset) {
            return false;
        }
        float density = QMUIDisplayHelper.getDensity(this.getContext());
        if (QMUINotchHelper.isNotchOfficialSupport()) {
            WindowInsets windowInsets = (WindowInsets)insets;
            left = windowInsets.getSystemWindowInsetLeft();
            top = windowInsets.getSystemWindowInsetTop();
            right = windowInsets.getSystemWindowInsetRight();
            bottom = windowInsets.getSystemWindowInsetBottom();
        } else {
            WindowInsetsCompat insetsCompat = (WindowInsetsCompat)insets;
            left = insetsCompat.getSystemWindowInsetLeft();
            top = insetsCompat.getSystemWindowInsetTop();
            right = insetsCompat.getSystemWindowInsetRight();
            bottom = insetsCompat.getSystemWindowInsetBottom();
        }
        Rect rect = new Rect((int)((float)left / density + (float)this.getExtraInsetLeft(density)), (int)((float)top / density + (float)this.getExtraInsetTop(density)), (int)((float)right / density + (float)this.getExtraInsetRight(density)), (int)((float)bottom / density + (float)this.getExtraInsetBottom(density)));
        this.setStyleDisplayCutoutSafeArea(rect);
        return true;
    }

    protected int getExtraInsetTop(float density) {
        return 0;
    }

    protected int getExtraInsetLeft(float density) {
        return 0;
    }

    protected int getExtraInsetRight(float density) {
        return 0;
    }

    protected int getExtraInsetBottom(float density) {
        return 0;
    }

    public void destroy() {
        this.mAwContents = null;
        this.mWebContents = null;
        this.mSetDisplayCutoutSafeAreaMethod = null;
        this.stopLoading();
        super.destroy();
    }

    private void setStyleDisplayCutoutSafeArea(@NonNull Rect rect) {
        if (sIsReflectionOccurError || Build.VERSION.SDK_INT <= 24) {
            return;
        }
        if (rect == this.mSafeAreaRectCache) {
            return;
        }
        if (this.mSafeAreaRectCache == null) {
            this.mSafeAreaRectCache = new Rect(rect);
        } else {
            this.mSafeAreaRectCache.set(rect);
        }
        long start = System.currentTimeMillis();
        if (this.mAwContents == null || this.mWebContents == null || this.mSetDisplayCutoutSafeAreaMethod == null) {
            try {
                Field providerField = WebView.class.getDeclaredField("mProvider");
                providerField.setAccessible(true);
                Object provider = providerField.get(this);
                this.mAwContents = this.getAwContentsFieldValueInProvider(provider);
                if (this.mAwContents == null) {
                    return;
                }
                this.mWebContents = this.getWebContentsFieldValueInAwContents(this.mAwContents);
                if (this.mWebContents == null) {
                    return;
                }
                this.mSetDisplayCutoutSafeAreaMethod = this.getSetDisplayCutoutSafeAreaMethodInWebContents(this.mWebContents);
                if (this.mSetDisplayCutoutSafeAreaMethod == null) {
                    this.doNotSupportChangeCssEnv();
                    return;
                }
            }
            catch (Exception e) {
                this.doNotSupportChangeCssEnv();
                Log.i((String)TAG, (String)("setStyleDisplayCutoutSafeArea error: " + e));
            }
        }
        try {
            this.mSetDisplayCutoutSafeAreaMethod.setAccessible(true);
            this.mSetDisplayCutoutSafeAreaMethod.invoke(this.mWebContents, rect);
        }
        catch (Exception e) {
            sIsReflectionOccurError = true;
            Log.i((String)TAG, (String)("setStyleDisplayCutoutSafeArea error: " + e));
        }
        Log.i((String)TAG, (String)("setDisplayCutoutSafeArea speed time: " + (System.currentTimeMillis() - start)));
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewCompat.requestApplyInsets((View)this);
    }

    private Object getAwContentsFieldValueInProvider(Object provider) throws IllegalAccessException, NoSuchFieldException {
        try {
            Field awContentsField = provider.getClass().getDeclaredField("mAwContents");
            if (awContentsField != null) {
                awContentsField.setAccessible(true);
                return awContentsField.get(provider);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        for (Field field : provider.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            Object awContents = field.get(provider);
            if (awContents == null || !awContents.getClass().getSimpleName().equals("AwContents")) continue;
            return awContents;
        }
        return null;
    }

    private Object getWebContentsFieldValueInAwContents(Object awContents) throws IllegalAccessException {
        try {
            Field webContentsField = awContents.getClass().getDeclaredField("mWebContents");
            if (webContentsField != null) {
                webContentsField.setAccessible(true);
                return webContentsField.get(awContents);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        for (Field innerField : awContents.getClass().getDeclaredFields()) {
            innerField.setAccessible(true);
            Object webContents = innerField.get(awContents);
            if (webContents == null || !webContents.getClass().getSimpleName().equals("WebContentsImpl")) continue;
            return webContents;
        }
        return null;
    }

    private Method getSetDisplayCutoutSafeAreaMethodInWebContents(Object webContents) {
        try {
            Method setDisplayCutoutSafeAreaMethod = webContents.getClass().getDeclaredMethod("setDisplayCutoutSafeArea", Rect.class);
            if (setDisplayCutoutSafeAreaMethod != null) {
                return setDisplayCutoutSafeAreaMethod;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        for (Method method : webContents.getClass().getDeclaredMethods()) {
            if (method.getReturnType() != Void.TYPE || method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Rect.class) continue;
            return method;
        }
        return null;
    }

    public static interface OnScrollChangeListener {
        public void onScrollChange(WebView var1, int var2, int var3, int var4, int var5);
    }

    public static interface Callback {
        public void onSureNotSupportChangeCssEnv();
    }
}

